/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.dmx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.dmx.model.DmxPublisherExtId;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisher;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.dmx.ExtImpDmx;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DmxBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpDmx>> DMX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final int SECURE = 1;
    private static final String IMP = "</Impression><Impression><![CDATA[%s]]></Impression>";
    private static final String SEARCH = "</Impression>";
    private static final List<Integer> VIDEO_PROTOCOLS = Arrays.asList(2, 3, 5, 6, 7, 8);
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public DmxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        try {
            DmxBidder.validateRequest((BidRequest)request);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List imps = request.getImp();
        String updatedPublisherId = null;
        String updatedSellerId = null;
        try {
            ExtImpDmx extImp = this.parseImpExt((Imp)imps.get(0));
            String extImpPublisherId = extImp.getPublisherId();
            updatedPublisherId = StringUtils.isNotBlank((CharSequence)extImpPublisherId) ? extImpPublisherId : extImp.getMemberId();
            updatedSellerId = extImp.getSellerId();
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
        }
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : imps) {
            try {
                ExtImpDmx extImp = this.parseImpExt(imp);
                if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{extImp.getPublisherId(), extImp.getMemberId()})) {
                    return Result.withError((BidderError)BidderError.badInput((String)"Missing Params for auction to be send"));
                }
                Imp validImp = DmxBidder.modifyImp((Imp)imp, (ExtImpDmx)extImp);
                if (validImp == null) continue;
                validImps.add(validImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        BidRequest outgoingRequest = request.toBuilder().imp(validImps).site(this.modifySite(request.getSite(), updatedPublisherId)).app(this.modifyApp(request.getApp(), request.getDevice(), updatedPublisherId)).build();
        String urlParameter = StringUtils.isNotBlank((CharSequence)updatedSellerId) ? "?sellerid=" + HttpUtil.encodeUrl((String)updatedSellerId) : "";
        String uri = this.endpointUrl + urlParameter;
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)uri, (JacksonMapper)this.mapper)), errors);
    }

    private static void validateRequest(BidRequest bidRequest) {
        User user = bidRequest.getUser();
        App app = bidRequest.getApp();
        if (user == null && app == null) {
            throw new PreBidException("No user id or app id found. Could not send request to DMX.");
        }
        if (app != null) {
            if (StringUtils.isNotBlank((CharSequence)app.getId())) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)bidRequest.getDevice().getIfa())) {
                return;
            }
        }
        if (user != null) {
            if (StringUtils.isNotBlank((CharSequence)user.getId())) {
                return;
            }
            ExtUser userExt = user.getExt();
            if (userExt != null && CollectionUtils.isNotEmpty((Collection)userExt.getEids())) {
                return;
            }
        }
        throw new PreBidException("This request contained no identifier");
    }

    private ExtImpDmx parseImpExt(Imp imp) {
        try {
            return (ExtImpDmx)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), DMX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static Imp modifyImp(Imp imp, ExtImpDmx extImp) {
        Imp updatedImp = DmxBidder.fetchParams((Imp)imp, (ExtImpDmx)extImp);
        if (updatedImp == null) {
            return null;
        }
        if (updatedImp.getVideo() != null) {
            return updatedImp;
        }
        Banner banner = updatedImp.getBanner();
        if (banner != null && CollectionUtils.isNotEmpty((Collection)banner.getFormat())) {
            return updatedImp;
        }
        return null;
    }

    private static Imp fetchParams(Imp imp, ExtImpDmx extImp) {
        String impTagId = imp.getTagid();
        String extTagId = extImp.getTagId();
        String dmxId = extImp.getDmxId();
        String tagId = (String)StringUtils.defaultIfBlank((CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)dmxId, (CharSequence)extTagId)), (CharSequence)impTagId);
        if (StringUtils.isBlank((CharSequence)tagId)) {
            return null;
        }
        return imp.toBuilder().tagid(tagId).secure(Integer.valueOf(StringUtils.isAllBlank((CharSequence[])new CharSequence[]{extTagId, dmxId}) ? imp.getSecure() : 1)).bidfloor(DmxBidder.resolveBidFloor((ExtImpDmx)extImp, (BigDecimal)imp.getBidfloor())).banner(DmxBidder.resolveBanner((Banner)imp.getBanner())).video(DmxBidder.resolveVideo((Video)imp.getVideo())).build();
    }

    private static BigDecimal resolveBidFloor(ExtImpDmx extImp, BigDecimal bidFloor) {
        BigDecimal extBidFloor = extImp.getBidFloor();
        return BidderUtil.isValidPrice((BigDecimal)extBidFloor) ? extBidFloor : bidFloor;
    }

    private static Banner resolveBanner(Banner banner) {
        Format firstFormat;
        List format;
        Integer width = banner == null ? null : banner.getW();
        Integer height = banner == null ? null : banner.getH();
        List list = format = banner != null ? banner.getFormat() : null;
        if ((height == null || width == null) && CollectionUtils.isNotEmpty((Collection)format) && (firstFormat = (Format)format.get(0)) != null) {
            return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
        }
        return banner;
    }

    private static Video resolveVideo(Video video) {
        return video == null ? null : video.toBuilder().protocols(DmxBidder.resolveVideoProtocols((List)video.getProtocols())).build();
    }

    private static List<Integer> resolveVideoProtocols(List<Integer> videoProtocols) {
        return CollectionUtils.isNotEmpty(videoProtocols) ? videoProtocols : VIDEO_PROTOCOLS;
    }

    private Site modifySite(Site site, String updatedPublisherId) {
        return site == null ? null : site.toBuilder().publisher(this.modifyPublisher(site.getPublisher(), updatedPublisherId, false)).build();
    }

    private App modifyApp(App app, Device device, String updatedPublisherId) {
        return app == null ? null : app.toBuilder().id(StringUtils.isNotBlank((CharSequence)app.getId()) ? app.getId() : device.getIfa()).publisher(this.modifyPublisher(app.getPublisher(), updatedPublisherId, true)).build();
    }

    private Publisher modifyPublisher(Publisher publisher, String updatedPublisherId, boolean setExtOnEmptyPublisher) {
        DmxPublisherExtId dmxPublisherExtId = DmxPublisherExtId.of((String)updatedPublisherId);
        ObjectNode encodedPublisherExt = (ObjectNode)this.mapper.mapper().valueToTree((Object)dmxPublisherExtId);
        ExtPublisher extPublisher = ExtPublisher.empty();
        extPublisher.addProperty("dmx", (JsonNode)encodedPublisherExt);
        if (publisher == null) {
            return Publisher.builder().id(updatedPublisherId).ext((ExtPublisher)(setExtOnEmptyPublisher ? extPublisher : null)).build();
        }
        return publisher.toBuilder().id((String)ObjectUtils.defaultIfNull((Object)publisher.getId(), (Object)updatedPublisherId)).ext(extPublisher).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.decodeBodyToBidResponse(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (SeatBid seatBid : bidResponse.getSeatbid()) {
            for (Bid bid : seatBid.getBid()) {
                try {
                    BidType bidType = DmxBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp());
                    Bid updatedBid = bidType == BidType.video ? bid.toBuilder().adm(DmxBidder.getAdm((Bid)bid)).build() : bid;
                    BidderBid bidderBid = BidderBid.of((Bid)updatedBid, (BidType)bidType, (String)bidResponse.getCur());
                    bidderBids.add(bidderBid);
                }
                catch (PreBidException e) {
                    errors.add(BidderError.badInput((String)e.getMessage()));
                }
            }
        }
        return Result.of(bidderBids, errors);
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        return imps.stream().filter(imp -> Objects.equals(imp.getId(), impId)).map(imp -> imp.getVideo() != null ? BidType.video : BidType.banner).findFirst().orElseThrow(() -> new PreBidException("Failed to find impression " + impId));
    }

    private static String getAdm(Bid bid) {
        String wrappedNurl = "</Impression><Impression><![CDATA[%s]]></Impression>".formatted(bid.getNurl());
        return bid.getAdm().replaceFirst("</Impression>", wrappedNurl);
    }
}

