/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.brave;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.brave.ExtImpBrave;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BraveBidder
implements Bidder<BidRequest> {
    private static final String PUBLISHER_MACRO = "{{.PublisherID}}";
    private static final String BIDDER_CURRENCY = "USD";
    private static final TypeReference<ExtPrebid<?, ExtImpBrave>> BRAVE_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BraveBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        String url;
        try {
            ExtImpBrave extImpBrave = this.parseImpExt((Imp)request.getImp().get(0));
            url = this.resolveEndpoint(extImpBrave.getPlacementId());
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        BidRequest outgoingRequest = request.toBuilder().imp(BraveBidder.removeFirstImpExt((List)request.getImp())).build();
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)url, (JacksonMapper)this.mapper));
    }

    private ExtImpBrave parseImpExt(Imp imp) {
        try {
            return (ExtImpBrave)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BRAVE_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder not provided");
        }
    }

    private static List<Imp> removeFirstImpExt(List<Imp> imps) {
        return IntStream.range(0, imps.size()).mapToObj(impIndex -> impIndex == 0 ? ((Imp)imps.get(impIndex)).toBuilder().ext(null).build() : (Imp)imps.get(impIndex)).toList();
    }

    private String resolveEndpoint(String publisherId) {
        return this.endpointUrl.replace("{{.PublisherID}}", StringUtils.stripToEmpty((String)publisherId));
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)BraveBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null) {
            throw new PreBidException("Bad Server Response");
        }
        if (CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        return BraveBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().limit(1L).filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)BraveBidder.getBidType((Bid)bid, (List)bidRequest.getImp()), (String)"USD")).toList();
    }

    private static BidType getBidType(Bid bid, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(bid.getImpid())) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

