/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bluesea;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.bluesea.ExtImpBlueSea;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BlueSeaBidder
implements Bidder<BidRequest> {
    private static final Set<String> SUPPORTED_BID_TYPES_TEXTUAL = Set.of("banner", "video", "native");
    private static final TypeReference<ExtPrebid<?, ExtImpBlueSea>> BLUE_SEA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BlueSeaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpBlueSea extImpBlueSea = this.parseImpExt(imp);
                requests.add(this.makeRequest(bidRequest, extImpBlueSea));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpBlueSea parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpBlueSea)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BLUE_SEA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest, ExtImpBlueSea extImpBlueSea) {
        return BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.resolveUrl(extImpBlueSea), (JacksonMapper)this.mapper);
    }

    private String resolveUrl(ExtImpBlueSea extImpBlueSea) {
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(this.endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(this.endpointUrl, e.getMessage()));
        }
        return uriBuilder.addParameter("pubid", extImpBlueSea.getPubId()).addParameter("token", extImpBlueSea.getToken()).toString();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList errors = new ArrayList();
        List bids = BlueSeaBidder.extractBids((BidResponse)bidResponse, errors);
        return Result.of((Object)bids, errors);
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BlueSeaBidder.makeBidderBid((Bid)bid, (String)bidResponse.getCur(), (List)errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, String currency, List<BidderError> errors) {
        try {
            return BidderBid.of((Bid)bid, (BidType)BlueSeaBidder.resolveBidType((Bid)bid), (String)currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
    }

    private static BidType resolveBidType(Bid bid) {
        String bidTypeTextual;
        ObjectNode bidExt = bid.getExt();
        JsonNode mediaTypeNode = bidExt != null ? bidExt.at("/mediatype") : null;
        return switch (bidTypeTextual = Optional.ofNullable(mediaTypeNode).filter(JsonNode::isTextual).map(JsonNode::asText).orElseThrow(() -> new PreBidException("Missing bid media type in bid with id: %s".formatted(bid.getId())))) {
            case "banner" -> BidType.banner;
            case "video" -> BidType.video;
            case "native" -> BidType.xNative;
            default -> throw new PreBidException("Unknown bid type: %s, in bid with id: %s".formatted(bidTypeTextual, bid.getId()));
        };
    }
}

