/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bliink;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BliinkBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BliinkBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(BliinkBidder.headers()).body(this.mapper.encodeToBytes((Object)bidRequest)).payload((Object)bidRequest).build());
    }

    private static MultiMap headers() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        ArrayList errors = new ArrayList();
        try {
            bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        return Result.of((Object)BliinkBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse, errors), errors);
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            errors.add(BidderError.badServerResponse((String)"Empty SeatBid array"));
            return Collections.emptyList();
        }
        return Optional.ofNullable((SeatBid)bidResponse.getSeatbid().get(0)).map(SeatBid::getBid).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(bid -> BliinkBidder.makeBidderBid((Bid)bid, (List)bidRequest.getImp(), (String)bidResponse.getCur(), (List)errors)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static BidderBid makeBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = BliinkBidder.getBidType((String)bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        BidType bidType = null;
        int mediaTypeCount = 0;
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                bidType = BidType.banner;
                ++mediaTypeCount;
            }
            if (imp.getVideo() != null) {
                bidType = BidType.video;
                ++mediaTypeCount;
            }
            if (imp.getXNative() != null) {
                bidType = BidType.xNative;
                ++mediaTypeCount;
            }
            if (imp.getAudio() == null) continue;
            bidType = BidType.audio;
            ++mediaTypeCount;
        }
        if (mediaTypeCount != 1) {
            throw new PreBidException("unable to fetch mediaType in multi-format: %s".formatted(impId));
        }
        return bidType;
    }
}

