/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bizzclick;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.HttpResponse;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.bizzclick.ExtImpBizzclick;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BizzclickBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpBizzclick>> BIZZCLICK_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String URL_SOURCE_ID_MACRO = "{{.SourceId}}";
    private static final String URL_ACCOUNT_ID_MACRO = "{{.AccountID}}";
    private static final String DEFAULT_CURRENCY = "USD";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BizzclickBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpBizzclick extImpBizzclick;
        List imps = request.getImp();
        try {
            extImpBizzclick = this.parseImpExt((Imp)imps.get(0));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        List<Imp> modifiedImps = imps.stream().map(BizzclickBidder::modifyImp).toList();
        return Result.withValue((Object)this.createHttpRequest(request, modifiedImps, extImpBizzclick));
    }

    private ExtImpBizzclick parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpBizzclick)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BIZZCLICK_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder not provided");
        }
    }

    private static Imp modifyImp(Imp imp) {
        return imp.toBuilder().ext(null).build();
    }

    private HttpRequest<BidRequest> createHttpRequest(BidRequest request, List<Imp> imps, ExtImpBizzclick ext) {
        BidRequest modifiedRequest = request.toBuilder().imp(imps).build();
        return HttpRequest.builder().method(HttpMethod.POST).headers(BizzclickBidder.headers((Device)modifiedRequest.getDevice())).uri(this.buildEndpointUrl(ext)).body(this.mapper.encodeToBytes((Object)modifiedRequest)).payload((Object)modifiedRequest).build();
    }

    private static MultiMap headers(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
        }
        return headers;
    }

    private String buildEndpointUrl(ExtImpBizzclick ext) {
        return this.endpointUrl.replace("{{.SourceId}}", HttpUtil.encodeUrl((String)ext.getPlacementId())).replace("{{.AccountID}}", HttpUtil.encodeUrl((String)ext.getAccountId()));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.parseBidResponse(httpCall.getResponse());
            return Result.withValues((List)BizzclickBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private BidResponse parseBidResponse(HttpResponse response) {
        try {
            return (BidResponse)this.mapper.decodeValue(response.getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Bad server response.");
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        SeatBid seatBid = (SeatBid)bidResponse.getSeatbid().get(0);
        if (seatBid == null || CollectionUtils.isEmpty((Collection)seatBid.getBid())) {
            return Collections.emptyList();
        }
        return seatBid.getBid().stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)BizzclickBidder.resolveBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)"USD")).toList();
    }

    private static BidType resolveBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!Objects.equals(impId, imp.getId())) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

