/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.beachfront;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.beachfront.BeachfrontFloorResolver;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.util.BidderUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeachfrontFloorResolver {
    public static final BigDecimal MIN_BID_FLOOR = BigDecimal.valueOf(0.01);
    public static final String DEFAULT_BID_CURRENCY = "USD";
    private final CurrencyConversionService currencyConversionService;

    public BeachfrontFloorResolver(CurrencyConversionService currencyConversionService) {
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
    }

    public BidFloorResult resolveBidFloor(BigDecimal extImpBidFloor, Imp imp, BidRequest bidRequest) {
        BidFloorResult bidFloorResult = this.convertBidFloor(bidRequest, imp.getBidfloor(), extImpBidFloor, imp.getBidfloorcur());
        return bidFloorResult.isError() || bidFloorResult.isWarning() ? bidFloorResult : BeachfrontFloorResolver.proceedWithHigherFloor((BigDecimal)extImpBidFloor, (BigDecimal)bidFloorResult.getPrice().getValue());
    }

    private BidFloorResult convertBidFloor(BidRequest bidRequest, BigDecimal impBidFloor, BigDecimal extImpBidFloor, String impBidFloorCur) {
        Price initialBidFloorPrice = Price.of((String)impBidFloorCur, (BigDecimal)impBidFloor);
        if (!BidderUtil.shouldConvertBidFloor((Price)initialBidFloorPrice, (String)"USD")) {
            return BidFloorResult.succeeded((Price)initialBidFloorPrice);
        }
        BidFloorResult result = this.convertBidFloor(initialBidFloorPrice, bidRequest);
        return result.isError() ? BeachfrontFloorResolver.processBidFloorFallback((BigDecimal)impBidFloor, (BigDecimal)extImpBidFloor, (String)impBidFloorCur) : result;
    }

    private BidFloorResult convertBidFloor(Price bidFloor, BidRequest bidRequest) {
        try {
            BigDecimal conversionResult = this.currencyConversionService.convertCurrency(bidFloor.getValue(), bidRequest, bidFloor.getCurrency(), "USD");
            return BidFloorResult.succeeded((Price)Price.of((String)"USD", (BigDecimal)conversionResult));
        }
        catch (PreBidException e) {
            return BidFloorResult.error((BidderError)BidderError.badInput((String)e.getMessage()));
        }
    }

    private static BidFloorResult processBidFloorFallback(BigDecimal impBidFloor, BigDecimal extImpBidFloor, String bidFloorCur) {
        return extImpBidFloor != null && extImpBidFloor.compareTo(MIN_BID_FLOOR) > 0 ? BeachfrontFloorResolver.fallbackWithWarning((BigDecimal)impBidFloor, (BigDecimal)extImpBidFloor, (String)bidFloorCur) : BeachfrontFloorResolver.currencyConversionError((BigDecimal)impBidFloor, (String)bidFloorCur);
    }

    private static BidFloorResult fallbackWithWarning(BigDecimal impBidFloor, BigDecimal extImpBidFloor, String bidFloorCur) {
        BidderError fallbackWarning = BidderError.badInput((String)"The following error was received from the currency converter while attempting to convert the imp.bidfloor value of %s from %s to USD: Currency service was unable to convert currency.\nThe provided value of imp.ext.beachfront.bidfloor, %s USD is being used as a fallback.".formatted(impBidFloor, bidFloorCur, extImpBidFloor));
        return BidFloorResult.fallbackWithWarning((Price)Price.of((String)"USD", (BigDecimal)extImpBidFloor), (BidderError)fallbackWarning);
    }

    private static BidFloorResult currencyConversionError(BigDecimal impBidFloor, String bidFloorCur) {
        return BidFloorResult.error((BidderError)BidderError.badInput((String)"The following error was received from the currency converter while attempting to convert the imp.bidfloor value of %s from %s to USD: Currency service was unable to convert currency.\nA value of imp.ext.beachfront.bidfloor was not provided. The bid is being skipped.".formatted(impBidFloor, bidFloorCur)));
    }

    private static BidFloorResult proceedWithHigherFloor(BigDecimal extImpBidFloor, BigDecimal convertedBidFloor) {
        BigDecimal resolvedExtImpBidFloor = (BigDecimal)ObjectUtils.defaultIfNull((Object)extImpBidFloor, (Object)BigDecimal.ZERO);
        if (convertedBidFloor != null && convertedBidFloor.compareTo(resolvedExtImpBidFloor) >= 0) {
            return BidFloorResult.succeeded((Price)Price.of((String)"USD", (BigDecimal)convertedBidFloor));
        }
        Price resultingPrice = extImpBidFloor != null && extImpBidFloor.compareTo(MIN_BID_FLOOR) > 0 ? Price.of((String)"USD", (BigDecimal)resolvedExtImpBidFloor) : Price.of((String)"", (BigDecimal)BigDecimal.ZERO);
        return BidFloorResult.succeeded((Price)resultingPrice);
    }
}

