/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.audiencenetwork;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.audiencenetwork.AudienceNetworkBidder;
import org.prebid.server.bidder.audiencenetwork.proto.AudienceNetworkAdMarkup;
import org.prebid.server.bidder.audiencenetwork.proto.AudienceNetworkExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.HttpResponse;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.audiencenetwork.ExtImpAudienceNetwork;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AudienceNetworkBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAudienceNetwork>> AUDIENCE_NETWORK_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final List<Integer> SUPPORTED_BANNER_HEIGHT = Arrays.asList(250, 50);
    private final String endpointUrl;
    private final String platformId;
    private final String appSecret;
    private final String timeoutNotificationUrlTemplate;
    private final JacksonMapper mapper;

    public AudienceNetworkBidder(String endpointUrl, String platformId, String appSecret, String timeoutNotificationUrlTemplate, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.platformId = AudienceNetworkBidder.checkBlankString((String)Objects.requireNonNull(platformId), (String)"platform-id");
        this.appSecret = AudienceNetworkBidder.checkBlankString((String)Objects.requireNonNull(appSecret), (String)"app-secret");
        this.timeoutNotificationUrlTemplate = HttpUtil.validateUrl((String)Objects.requireNonNull(timeoutNotificationUrlTemplate));
        this.mapper = Objects.requireNonNull(mapper);
    }

    private static String checkBlankString(String paramValue, String paramName) {
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            throw new IllegalArgumentException("No facebook %s specified. Calls to the Audience Network will fail.\nDid you set adapters.facebook.%s in the app config?".formatted(paramName, paramName));
        }
        return paramValue;
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        User user = bidRequest.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getBuyeruid())) {
            return Result.withError((BidderError)BidderError.badInput((String)"Missing bidder token in 'user.buyeruid'"));
        }
        if (bidRequest.getSite() != null) {
            return Result.withError((BidderError)BidderError.badInput((String)"Site impressions are not supported."));
        }
        MultiMap headers = HttpUtil.headers().add("X-Fb-Pool-Routing-Token", bidRequest.getUser().getBuyeruid());
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                httpRequests.add(this.makeHttpRequest(imp, bidRequest, headers));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private HttpRequest<BidRequest> makeHttpRequest(Imp imp, BidRequest bidRequest, MultiMap headers) {
        ExtImpAudienceNetwork resolvedImpExt = this.parseAndResolveExtImpAudienceNetwork(imp);
        Imp modifiedImp = AudienceNetworkBidder.modifyImp((Imp)imp, (ExtImpAudienceNetwork)resolvedImpExt);
        String publisherId = resolvedImpExt.getPublisherId();
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(Collections.singletonList(modifiedImp)).app(AudienceNetworkBidder.makeApp((App)bidRequest.getApp(), (String)publisherId)).ext((ExtRequest)this.mapper.fillExtension((FlexibleExtension)ExtRequest.empty(), (Object)AudienceNetworkExt.of((String)this.platformId, (String)this.makeAuthId(bidRequest.getId())))).build();
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes((Object)outgoingRequest)).headers(headers).payload((Object)outgoingRequest).build();
    }

    private ExtImpAudienceNetwork parseAndResolveExtImpAudienceNetwork(Imp imp) {
        ExtImpAudienceNetwork extImpAudienceNetwork;
        try {
            extImpAudienceNetwork = (ExtImpAudienceNetwork)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), AUDIENCE_NETWORK_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
        String placementId = extImpAudienceNetwork.getPlacementId();
        if (StringUtils.isBlank((CharSequence)placementId)) {
            throw new PreBidException("Missing placementId param");
        }
        String[] placementSplit = placementId.split("_");
        int splitLength = placementSplit.length;
        if (splitLength == 1) {
            if (StringUtils.isBlank((CharSequence)extImpAudienceNetwork.getPublisherId())) {
                throw new PreBidException("Missing publisherId param");
            }
            return extImpAudienceNetwork;
        }
        if (splitLength == 2) {
            return ExtImpAudienceNetwork.of((String)placementSplit[1], (String)placementSplit[0]);
        }
        throw new PreBidException("Invalid placementId param '%s' and publisherId param '%s'".formatted(placementId, extImpAudienceNetwork.getPublisherId()));
    }

    private static Imp modifyImp(Imp imp, ExtImpAudienceNetwork extImpAudienceNetwork) {
        BidType impType = AudienceNetworkBidder.resolveImpType((Imp)imp);
        String impId = imp.getId();
        if (impType == null) {
            throw new PreBidException("imp #%s with invalid type".formatted(impId));
        }
        boolean impInstlEqOne = Objects.equals(imp.getInstl(), 1);
        if (impInstlEqOne && impType != BidType.banner) {
            throw new PreBidException("imp #%s: interstitial imps are only supported for banner".formatted(impId));
        }
        Imp.ImpBuilder impBuilder = imp.toBuilder();
        switch (2.$SwitchMap$org$prebid$server$proto$openrtb$ext$response$BidType[impType.ordinal()]) {
            case 1: {
                impBuilder.banner(AudienceNetworkBidder.modifyBanner((Imp)imp, (boolean)impInstlEqOne));
                break;
            }
            case 2: {
                impBuilder.video(imp.getVideo().toBuilder().w(Integer.valueOf(0)).h(Integer.valueOf(0)).build());
                break;
            }
            case 3: {
                impBuilder.xNative(AudienceNetworkBidder.modifyNative((Native)imp.getXNative()));
            }
        }
        return impBuilder.ext(null).tagid(extImpAudienceNetwork.getPublisherId() + "_" + extImpAudienceNetwork.getPlacementId()).build();
    }

    private static BidType resolveImpType(Imp imp) {
        if (imp.getBanner() != null) {
            return BidType.banner;
        }
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        if (imp.getAudio() != null) {
            return BidType.audio;
        }
        if (imp.getXNative() != null) {
            return BidType.xNative;
        }
        return null;
    }

    private static Banner modifyBanner(Imp imp, boolean impInstlEqOne) {
        Banner banner = imp.getBanner();
        String impId = imp.getId();
        if (banner == null) {
            throw new PreBidException("imp #%s: Banner is null".formatted(impId));
        }
        if (impInstlEqOne) {
            return banner.toBuilder().w(Integer.valueOf(0)).h(Integer.valueOf(0)).format(null).build();
        }
        if (banner.getH() == null) {
            for (Format format : banner.getFormat()) {
                if (format == null || !AudienceNetworkBidder.isBannerHeightValid((Integer)format.getH())) continue;
                return banner.toBuilder().w(Integer.valueOf(-1)).h(format.getH()).format(null).build();
            }
            throw new PreBidException("imp #%s: banner height required".formatted(impId));
        }
        if (!AudienceNetworkBidder.isBannerHeightValid((Integer)banner.getH())) {
            throw new PreBidException("imp #%s: only banner heights 50 and 250 are supported".formatted(impId));
        }
        return banner.toBuilder().w(Integer.valueOf(-1)).format(null).build();
    }

    private static boolean isBannerHeightValid(Integer h) {
        return SUPPORTED_BANNER_HEIGHT.contains(h);
    }

    private static Native modifyNative(Native xNative) {
        return Native.builder().api(xNative.getApi()).battr(xNative.getBattr()).ext(xNative.getExt()).build();
    }

    private static App makeApp(App app, String pubId) {
        if (app == null) {
            return null;
        }
        return app.toBuilder().publisher(Publisher.builder().id(pubId).build()).build();
    }

    private String makeAuthId(String requestId) {
        Mac mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_256, (byte[])this.appSecret.getBytes());
        return Hex.encodeHexString((byte[])mac.doFinal(requestId != null ? requestId.getBytes() : null));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        HttpResponse response = httpCall.getResponse();
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(response.getBody(), BidResponse.class);
            return this.extractBids(bidResponse, bidRequest.getImp());
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private Result<List<BidderBid>> extractBids(BidResponse bidResponse, List<Imp> imps) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Result.empty();
        }
        ArrayList errors = new ArrayList();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.toBidderBid(bid, imps, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
        return Result.of(bidderBids, errors);
    }

    private BidderBid toBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        try {
            if (StringUtils.isBlank((CharSequence)bid.getAdm())) {
                throw new PreBidException("Bid %s missing 'adm'".formatted(bid.getId()));
            }
            String bidId = ((AudienceNetworkAdMarkup)this.mapper.decodeValue(bid.getAdm(), AudienceNetworkAdMarkup.class)).getBidId();
            if (StringUtils.isBlank((CharSequence)bidId)) {
                throw new PreBidException("bid %s missing 'bid_id' in 'adm'".formatted(bid.getId()));
            }
            Bid modifiedBid = bid.toBuilder().adid(bidId).crid(bidId).build();
            return BidderBid.of((Bid)modifiedBid, (BidType)AudienceNetworkBidder.getBidType((String)modifiedBid.getImpid(), imps), (String)currency);
        }
        catch (PreBidException | DecodeException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!impId.equals(imp.getId())) continue;
            BidType bidType = AudienceNetworkBidder.resolveImpType((Imp)imp);
            if (bidType == null) {
                throw new PreBidException("Processing an invalid impression; cannot resolve impression type");
            }
            return bidType;
        }
        throw new PreBidException("Invalid bid imp ID %s does not match any imp IDs from the original bid request".formatted(impId));
    }

    public HttpRequest<Void> makeTimeoutNotification(HttpRequest<BidRequest> httpRequest) {
        String publisherId;
        BidRequest bidRequest = (BidRequest)httpRequest.getPayload();
        String requestId = bidRequest.getId();
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            return null;
        }
        App app = bidRequest.getApp();
        Publisher publisher = app != null ? app.getPublisher() : null;
        String string = publisherId = publisher != null ? publisher.getId() : null;
        if (StringUtils.isEmpty((CharSequence)publisherId)) {
            return null;
        }
        return HttpRequest.builder().method(HttpMethod.GET).uri(this.timeoutNotificationUrlTemplate.formatted(this.platformId, publisherId, requestId)).build();
    }
}

