/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.amx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.amx.model.AmxBidExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.amx.ExtImpAmx;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AmxBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAmx>> AMX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String ADAPTER_VERSION = "pbs1.2";
    private static final String VERSION_PARAM = "v";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AmxBidder(String endpointUrl, JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
        this.endpointUrl = AmxBidder.resolveEndpointUrl((String)endpointUrl);
    }

    private static String resolveEndpointUrl(String url) {
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(HttpUtil.validateUrl((String)Objects.requireNonNull(url)));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url: %s, error: %s".formatted(url, e.getMessage()));
        }
        return uriBuilder.addParameter("v", "pbs1.2").toString();
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        String publisherId = null;
        for (Imp imp : request.getImp()) {
            try {
                String adUnitId;
                ExtImpAmx extImpAmx = this.parseImpExt(imp);
                String tagId = extImpAmx.getTagId();
                if (StringUtils.isNotBlank((CharSequence)tagId)) {
                    publisherId = tagId;
                }
                Imp modifiedImp = StringUtils.isNotBlank((CharSequence)(adUnitId = extImpAmx.getAdUnitId())) ? imp.toBuilder().tagid(adUnitId).build() : imp;
                modifiedImps.add(modifiedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        BidRequest outgoingRequest = this.createOutgoingRequest(request, publisherId, modifiedImps);
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper)), errors);
    }

    private ExtImpAmx parseImpExt(Imp imp) {
        try {
            return (ExtImpAmx)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), AMX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private BidRequest createOutgoingRequest(BidRequest request, String publisherId, List<Imp> imps) {
        BidRequest.BidRequestBuilder outgoingRequest = request.toBuilder();
        if (StringUtils.isNotBlank((CharSequence)publisherId)) {
            Site site;
            App app = request.getApp();
            if (app != null) {
                outgoingRequest.app(app.toBuilder().publisher(this.resolvePublisher(app.getPublisher(), publisherId)).build());
            }
            if ((site = request.getSite()) != null) {
                outgoingRequest.site(site.toBuilder().publisher(this.resolvePublisher(site.getPublisher(), publisherId)).build());
            }
        }
        return outgoingRequest.imp(imps).build();
    }

    private Publisher resolvePublisher(Publisher publisher, String publisherId) {
        return publisher != null ? publisher.toBuilder().id(publisherId).build() : Publisher.builder().id(publisherId).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            ArrayList errors = new ArrayList();
            return Result.of((Object)this.extractBids(bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || bidResponse.getSeatbid() == null) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.createBidderBid(bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid createBidderBid(Bid bid, String cur, List<BidderError> errors) {
        AmxBidExt amxBidExt;
        try {
            amxBidExt = this.parseBidderExt(bid.getExt());
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)this.getBidType(amxBidExt), (String)cur);
    }

    private AmxBidExt parseBidderExt(ObjectNode ext) {
        if (ext == null || StringUtils.isBlank((CharSequence)ext.toPrettyString())) {
            return AmxBidExt.of(null, null);
        }
        try {
            return (AmxBidExt)this.mapper.mapper().convertValue((Object)ext, AmxBidExt.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private BidType getBidType(AmxBidExt amxBidExt) {
        if (amxBidExt.getStartDelay() != null) {
            return BidType.video;
        }
        if (amxBidExt.getCreativeType() != null && amxBidExt.getCreativeType() == 10) {
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

