/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.aja;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.aja.proto.ExtImpAja;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AjaBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAja>> AJA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AjaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        ArrayList<HttpRequest> result = new ArrayList<HttpRequest>();
        ArrayList<String> tagIds = new ArrayList<String>();
        HashMap<String, Imp> impsByTagID = new HashMap<String, Imp>();
        for (Imp imp : bidRequest.getImp()) {
            ExtImpAja extImpAja = this.parseExtAJA(imp, errors);
            if (extImpAja == null) continue;
            String tagId = (imp = imp.toBuilder().tagid(extImpAja.getAdSpotID()).ext(null).build()).getTagid();
            if (!impsByTagID.containsKey(tagId)) {
                tagIds.add(tagId);
            }
            impsByTagID.put(tagId, imp);
        }
        for (String tagId : tagIds) {
            Imp imp = (Imp)impsByTagID.get(tagId);
            HttpRequest singleRequest = this.createSingleRequest(imp, bidRequest, this.endpointUrl);
            result.add(singleRequest);
        }
        return Result.of(result, errors);
    }

    private ExtImpAja parseExtAJA(Imp imp, List<BidderError> errors) {
        try {
            return (ExtImpAja)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), AJA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            errors.add(BidderError.badInput((String)"Failed to unmarshal ext.bidder impID: %s err: %s".formatted(imp.getId(), e.getMessage())));
            return null;
        }
    }

    private HttpRequest<BidRequest> createSingleRequest(Imp imp, BidRequest request, String url) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)url, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private Result<List<BidderBid>> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Result.empty();
        }
        ArrayList errors = new ArrayList();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> AjaBidder.bidFromResponse((List)bidRequest.getImp(), (Bid)bid, (List)errors, (String)bidResponse.getCur())).filter(Objects::nonNull).toList();
        return Result.of(bidderBids, errors);
    }

    private static BidderBid bidFromResponse(List<Imp> imps, Bid bid, List<BidderError> errors, String currency) {
        try {
            BidType bidType = AjaBidder.getBidType((String)bid.getImpid(), imps, (String)bid.getId());
            return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps, String bidId) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() == null) continue;
            return BidType.video;
        }
        throw new PreBidException("Response received for unexpected type of bid bidID: " + bidId);
    }
}

