/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adview;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adview.ExtImpAdview;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdviewBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdview>> ADVIEW_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String ACCOUNT_ID_MACRO = "{{AccountId}}";
    private static final String BIDDER_CURRENCY = "USD";
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final JacksonMapper mapper;

    public AdviewBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        BidRequest modifiedBidRequest;
        ExtImpAdview extImpAdview;
        Imp firstImp = (Imp)request.getImp().get(0);
        try {
            extImpAdview = this.parseExtImp(firstImp);
            Price bidFloorPrice = this.resolveBidFloor(firstImp, request);
            modifiedBidRequest = AdviewBidder.modifyRequest((BidRequest)request, (String)extImpAdview.getMasterTagId(), (Price)bidFloorPrice);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)modifiedBidRequest, (String)this.resolveEndpoint(extImpAdview.getAccountId()), (JacksonMapper)this.mapper));
    }

    private ExtImpAdview parseExtImp(Imp imp) {
        try {
            return (ExtImpAdview)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADVIEW_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("invalid imp.ext");
        }
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of((String)imp.getBidfloorcur(), (BigDecimal)imp.getBidfloor());
        return BidderUtil.isValidPrice((Price)initialBidFloorPrice) ? this.convertBidFloor(initialBidFloorPrice, imp.getId(), bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, String impId, BidRequest bidRequest) {
        String bidFloorCur = bidFloorPrice.getCurrency();
        try {
            BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorCur, "USD");
            return Price.of((String)"USD", (BigDecimal)convertedPrice);
        }
        catch (PreBidException e) {
            throw new PreBidException("Unable to convert provided bid floor currency from %s to %s for imp `%s`".formatted(bidFloorCur, "USD", impId));
        }
    }

    private static BidRequest modifyRequest(BidRequest bidRequest, String masterTagId, Price bidFloorPrice) {
        return bidRequest.toBuilder().imp(AdviewBidder.modifyImps((List)bidRequest.getImp(), (String)masterTagId, (Price)bidFloorPrice)).cur(Collections.singletonList("USD")).build();
    }

    private static List<Imp> modifyImps(List<Imp> imps, String masterTagId, Price bidFloorPrice) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>(imps);
        modifiedImps.set(0, AdviewBidder.modifyImp((Imp)imps.get(0), (String)masterTagId, (Price)bidFloorPrice));
        return modifiedImps;
    }

    private static Imp modifyImp(Imp imp, String masterTagId, Price bidFloorPrice) {
        return imp.toBuilder().tagid(masterTagId).bidfloor(bidFloorPrice.getValue()).bidfloorcur(bidFloorPrice.getCurrency()).banner(AdviewBidder.resolveBanner((Banner)imp.getBanner())).build();
    }

    private static Banner resolveBanner(Banner banner) {
        List formats;
        List list = formats = banner != null ? banner.getFormat() : null;
        if (CollectionUtils.isNotEmpty((Collection)formats)) {
            Format firstFormat = (Format)formats.get(0);
            return firstFormat != null ? banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build() : banner;
        }
        return banner;
    }

    private String resolveEndpoint(String accountId) {
        return this.endpointUrl.replace("{{AccountId}}", HttpUtil.encodeUrl((String)accountId));
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)AdviewBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return AdviewBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)AdviewBidder.getBidMediaType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

