/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adprime;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adprime.ExtImpAdprime;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdprimeBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdprime>> ADPRIME_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdprimeBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        List imps = bidRequest.getImp();
        for (Imp imp : imps) {
            try {
                ExtImpAdprime extImpAdprime = (ExtImpAdprime)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADPRIME_EXT_TYPE_REFERENCE)).getBidder();
                httpRequests.add(this.makeHttpRequest(this.modifyBidRequest(bidRequest, extImpAdprime, this.modifyImp(imp, extImpAdprime))));
            }
            catch (IllegalArgumentException e) {
                return Result.withError((BidderError)BidderError.badInput((String)"Unable to decode the impression ext for id: '%s'".formatted(imp.getId())));
            }
        }
        return Result.of(httpRequests, Collections.emptyList());
    }

    private Imp modifyImp(Imp imp, ExtImpAdprime impExt) {
        String tagId = impExt.getTagId();
        ObjectNode modifiedImpExtBidder = this.mapper.mapper().createObjectNode();
        modifiedImpExtBidder.set("TagID", (JsonNode)TextNode.valueOf((String)tagId));
        modifiedImpExtBidder.set("placementId", (JsonNode)TextNode.valueOf((String)tagId));
        return imp.toBuilder().tagid(tagId).ext((ObjectNode)this.mapper.mapper().createObjectNode().set("bidder", (JsonNode)modifiedImpExtBidder)).build();
    }

    private BidRequest modifyBidRequest(BidRequest bidRequest, ExtImpAdprime extImpAdprime, Imp imp) {
        return bidRequest.toBuilder().user(this.resolveUser(bidRequest, extImpAdprime)).site(this.resolveSite(bidRequest, extImpAdprime)).imp(List.of(imp)).build();
    }

    private User resolveUser(BidRequest bidRequest, ExtImpAdprime extImpAdprime) {
        User user = bidRequest.getUser();
        List audiences = extImpAdprime.getAudiences();
        if (Objects.isNull(bidRequest.getSite()) || CollectionUtils.isEmpty((Collection)audiences)) {
            return user;
        }
        User.UserBuilder userBuilder = user != null ? user.toBuilder() : User.builder();
        return userBuilder.customdata(String.join((CharSequence)",", audiences)).build();
    }

    private Site resolveSite(BidRequest bidRequest, ExtImpAdprime extImpAdprime) {
        Site site = bidRequest.getSite();
        List keywords = extImpAdprime.getKeywords();
        return Objects.nonNull(site) && CollectionUtils.isNotEmpty((Collection)keywords) ? site.toBuilder().keywords(String.join((CharSequence)",", keywords)).build() : site;
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest) {
        return BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList errors = new ArrayList();
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)AdprimeBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return AdprimeBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse, errors);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> AdprimeBidder.resolveBidderBid((Bid)bid, (String)bidResponse.getCur(), (List)bidRequest.getImp(), (List)errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid resolveBidderBid(Bid bid, String currency, List<Imp> imps, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = AdprimeBidder.getBidType((String)bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            throw new PreBidException("Unknown impression type for ID: '%s'".formatted(impId));
        }
        throw new PreBidException("Failed to find impression for ID: '%s'".formatted(impId));
    }
}

