/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.admixer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.admixer.ExtImpAdmixer;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdmixerBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdmixer>> ADMIXER_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdmixerBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdmixer extImp = this.parseImpExt(imp);
                Imp updatedImp = this.processImp(imp, extImp);
                validImps.add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        BidRequest outgoingRequest = request.toBuilder().imp(validImps).build();
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper)), errors);
    }

    private ExtImpAdmixer parseImpExt(Imp imp) {
        ExtImpAdmixer extImpAdmixer;
        try {
            extImpAdmixer = (ExtImpAdmixer)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADMIXER_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Wrong Admixer bidder ext in imp with id : " + imp.getId());
        }
        String zoneId = extImpAdmixer.getZone();
        if (StringUtils.length((CharSequence)zoneId) < 32 || StringUtils.length((CharSequence)zoneId) > 36) {
            throw new PreBidException("ZoneId must be UUID/GUID");
        }
        return extImpAdmixer;
    }

    private Imp processImp(Imp imp, ExtImpAdmixer extImpAdmixer) {
        return imp.toBuilder().tagid(extImpAdmixer.getZone()).bidfloor(AdmixerBidder.resolveBidFloor((BigDecimal)extImpAdmixer.getCustomFloor(), (BigDecimal)imp.getBidfloor())).ext(this.makeImpExt(extImpAdmixer.getCustomParams())).build();
    }

    private static BigDecimal resolveBidFloor(BigDecimal customBidFloor, BigDecimal bidFloor) {
        BigDecimal resolvedCustomBidFloor = AdmixerBidder.isValidBidFloor((BigDecimal)customBidFloor) ? customBidFloor : null;
        BigDecimal resolvedBidFloor = AdmixerBidder.isValidBidFloor((BigDecimal)bidFloor) ? bidFloor : null;
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)resolvedBidFloor, (Object)resolvedCustomBidFloor);
    }

    private static boolean isValidBidFloor(BigDecimal bidFloor) {
        return bidFloor != null && bidFloor.compareTo(BigDecimal.ZERO) > 0;
    }

    private ObjectNode makeImpExt(Map<String, JsonNode> customParams) {
        return customParams != null ? (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtImpAdmixer.of(null, null, customParams)) : null;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.decodeBodyToBidResponse(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) || CollectionUtils.isEmpty((Collection)((SeatBid)bidResponse.getSeatbid().get(0)).getBid())) {
            return Result.empty();
        }
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().map(SeatBid::getBid).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)AdmixerBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
        return Result.withValues(bidderBids);
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getAudio() == null) continue;
            return BidType.audio;
        }
        return BidType.banner;
    }
}

