/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.aax;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AaxBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private static final String USD_CURRENCY = "USD";

    public AaxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper));
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List bidderBids = this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse, errors);
            return Result.of((Object)bidderBids, errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errorList) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse, errorList);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errorList) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid(bid, bidRequest.getImp(), errorList)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BidderBid resolveBidderBid(Bid bid, List<Imp> imps, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = this.getBidType(bid, imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)"USD");
    }

    private BidType getBidType(Bid bid, List<Imp> imps) {
        return (BidType)ObjectUtil.firstNonNull((Supplier[])new Supplier[]{() -> AaxBidder.bidTypeFromExt((ObjectNode)bid.getExt()), () -> AaxBidder.bidTypeFromImp((String)bid.getImpid(), (List)imps)});
    }

    private static BidType bidTypeFromExt(ObjectNode bidExt) {
        String bidType;
        JsonNode bidTypeNode = bidExt != null ? bidExt.get("adCodeType") : null;
        String string = bidType = bidTypeNode != null ? bidTypeNode.textValue() : null;
        if (bidType == null) {
            return null;
        }
        return switch (bidType) {
            case "banner" -> BidType.banner;
            case "native" -> BidType.xNative;
            case "video" -> BidType.video;
            default -> null;
        };
    }

    private static BidType bidTypeFromImp(String impId, List<Imp> imps) {
        BidType bidType = null;
        int counter = 0;
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                ++counter;
                bidType = BidType.banner;
            }
            if (imp.getVideo() != null) {
                ++counter;
                bidType = BidType.video;
            }
            if (imp.getXNative() == null) continue;
            ++counter;
            bidType = BidType.xNative;
        }
        if (counter != 1) {
            throw new PreBidException(String.format("Unable to fetch mediaType in multi-format: %s", impId));
        }
        return bidType;
    }
}

