/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import java.beans.ConstructorProperties;
import org.prebid.server.bidder.UsersyncFormat;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.bidder.UsersyncMethodType;

public final class UsersyncMethod {
    private final UsersyncMethodType type;
    private final String usersyncUrl;
    private final String redirectUrl;
    private final boolean supportCORS;
    private final UsersyncFormat formatOverride;

    @ConstructorProperties(value={"type", "usersyncUrl", "redirectUrl", "supportCORS", "formatOverride"})
    UsersyncMethod(UsersyncMethodType type, String usersyncUrl, String redirectUrl, boolean supportCORS, UsersyncFormat formatOverride) {
        this.type = type;
        this.usersyncUrl = usersyncUrl;
        this.redirectUrl = redirectUrl;
        this.supportCORS = supportCORS;
        this.formatOverride = formatOverride;
    }

    public static UsersyncMethodBuilder builder() {
        return new UsersyncMethodBuilder();
    }

    public UsersyncMethodType getType() {
        return this.type;
    }

    public String getUsersyncUrl() {
        return this.usersyncUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean isSupportCORS() {
        return this.supportCORS;
    }

    public UsersyncFormat getFormatOverride() {
        return this.formatOverride;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsersyncMethod)) {
            return false;
        }
        UsersyncMethod other = (UsersyncMethod)o;
        if (this.isSupportCORS() != other.isSupportCORS()) {
            return false;
        }
        UsersyncMethodType this$type = this.getType();
        UsersyncMethodType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$usersyncUrl = this.getUsersyncUrl();
        String other$usersyncUrl = other.getUsersyncUrl();
        if (this$usersyncUrl == null ? other$usersyncUrl != null : !this$usersyncUrl.equals(other$usersyncUrl)) {
            return false;
        }
        String this$redirectUrl = this.getRedirectUrl();
        String other$redirectUrl = other.getRedirectUrl();
        if (this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl)) {
            return false;
        }
        UsersyncFormat this$formatOverride = this.getFormatOverride();
        UsersyncFormat other$formatOverride = other.getFormatOverride();
        return !(this$formatOverride == null ? other$formatOverride != null : !this$formatOverride.equals(other$formatOverride));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSupportCORS() ? 79 : 97);
        UsersyncMethodType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $usersyncUrl = this.getUsersyncUrl();
        result = result * 59 + ($usersyncUrl == null ? 43 : $usersyncUrl.hashCode());
        String $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
        UsersyncFormat $formatOverride = this.getFormatOverride();
        result = result * 59 + ($formatOverride == null ? 43 : $formatOverride.hashCode());
        return result;
    }

    public String toString() {
        return "UsersyncMethod(type=" + this.getType() + ", usersyncUrl=" + this.getUsersyncUrl() + ", redirectUrl=" + this.getRedirectUrl() + ", supportCORS=" + this.isSupportCORS() + ", formatOverride=" + this.getFormatOverride() + ")";
    }
}

