/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.video.BidRequestVideo;
import com.iab.openrtb.request.video.Pod;
import com.iab.openrtb.request.video.PodError;
import com.iab.openrtb.request.video.Podconfig;
import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.DebugResolver;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.VideoStoredRequestProcessor;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.CachedDebugLog;
import org.prebid.server.auction.model.WithPodErrors;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.auction.requestfactory.Ortb2RequestFactory;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConversionManager;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisher;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisherPrebid;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class VideoRequestFactory {
    private static final String DEBUG = "debug";
    private static final int DEFAULT_CACHE_LOG_TTL = 3600;
    private static final String ENDPOINT = Endpoint.openrtb2_video.value();
    private final int maxRequestSize;
    private final boolean enforceStoredRequest;
    private final Pattern escapeLogCacheRegexPattern;
    private final Ortb2RequestFactory ortb2RequestFactory;
    private final VideoStoredRequestProcessor storedRequestProcessor;
    private final BidRequestOrtbVersionConversionManager ortbVersionConversionManager;
    private final Ortb2ImplicitParametersResolver paramsResolver;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final DebugResolver debugResolver;
    private final JacksonMapper mapper;

    public VideoRequestFactory(int maxRequestSize, boolean enforceStoredRequest, String escapeLogCacheRegex, Ortb2RequestFactory ortb2RequestFactory, VideoStoredRequestProcessor storedRequestProcessor, BidRequestOrtbVersionConversionManager ortbVersionConversionManager, Ortb2ImplicitParametersResolver paramsResolver, PrivacyEnforcementService privacyEnforcementService, DebugResolver debugResolver, JacksonMapper mapper) {
        this.enforceStoredRequest = enforceStoredRequest;
        this.maxRequestSize = maxRequestSize;
        this.ortb2RequestFactory = Objects.requireNonNull(ortb2RequestFactory);
        this.storedRequestProcessor = Objects.requireNonNull(storedRequestProcessor);
        this.ortbVersionConversionManager = Objects.requireNonNull(ortbVersionConversionManager);
        this.paramsResolver = Objects.requireNonNull(paramsResolver);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.debugResolver = Objects.requireNonNull(debugResolver);
        this.mapper = Objects.requireNonNull(mapper);
        this.escapeLogCacheRegexPattern = StringUtils.isNotBlank((CharSequence)escapeLogCacheRegex) ? Pattern.compile(escapeLogCacheRegex) : null;
    }

    public Future<WithPodErrors<AuctionContext>> fromRequest(RoutingContext routingContext, long startTime) {
        String body;
        try {
            body = this.extractAndValidateBody(routingContext);
        }
        catch (InvalidRequestException e) {
            return Future.failedFuture((Throwable)e);
        }
        ArrayList podErrors = new ArrayList();
        AuctionContext initialAuctionContext = this.ortb2RequestFactory.createAuctionContext(Endpoint.openrtb2_video, MetricName.video);
        return this.ortb2RequestFactory.executeEntrypointHooks(routingContext, body, initialAuctionContext).compose(httpRequest -> this.createBidRequest(httpRequest).compose(bidRequest -> this.validateRequest(bidRequest, httpRequest, initialAuctionContext.getDebugWarnings())).map(bidRequestWithErrors -> (WithPodErrors)VideoRequestFactory.populatePodErrors((List)bidRequestWithErrors.getPodErrors(), (List)podErrors, (Object)bidRequestWithErrors)).map(bidRequestWithErrors -> this.ortb2RequestFactory.enrichAuctionContext(initialAuctionContext, httpRequest, (BidRequest)bidRequestWithErrors.getData(), startTime))).compose(auctionContext -> this.ortb2RequestFactory.fetchAccountWithoutStoredRequestLookup(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).map(auctionContext -> auctionContext.with(this.debugResolver.debugContextFrom(auctionContext))).compose(auctionContext -> this.ortb2RequestFactory.activityInfrastructureFrom(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.privacyEnforcementService.contextFromBidRequest(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).map(auctionContext -> auctionContext.with(this.ortb2RequestFactory.enrichBidRequestWithAccountAndPrivacyData(auctionContext))).compose(auctionContext -> this.ortb2RequestFactory.executeProcessedAuctionRequestHooks(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).populateUserAdditionalInfo(arg_0)).map(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).enrichWithPriceFloors(arg_0)).map(auctionContext -> this.ortb2RequestFactory.updateTimeout(auctionContext, startTime)).recover(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).restoreResultFromRejection(arg_0)).map(arg_0 -> this.updateContextWithDebugLog(arg_0)).map(auctionContext -> WithPodErrors.of((Object)auctionContext, (List)podErrors));
    }

    private String extractAndValidateBody(RoutingContext routingContext) {
        String body = routingContext.getBodyAsString();
        if (body == null) {
            throw new InvalidRequestException("Incoming request has no body");
        }
        if (body.length() > this.maxRequestSize) {
            throw new InvalidRequestException("Request size exceeded max size of %d bytes.".formatted(this.maxRequestSize));
        }
        return body;
    }

    private Future<WithPodErrors<BidRequest>> createBidRequest(HttpRequestContext httpRequest) {
        BidRequestVideo bidRequestVideo;
        boolean debugEnabled = this.isDebugEnabled(httpRequest);
        try {
            bidRequestVideo = this.parseRequest(httpRequest);
        }
        catch (InvalidRequestException e) {
            return Future.failedFuture((Throwable)e);
        }
        String storedRequestId = bidRequestVideo.getStoredrequestid();
        if (StringUtils.isBlank((CharSequence)storedRequestId) && this.enforceStoredRequest) {
            return Future.failedFuture((Throwable)new InvalidRequestException("Unable to find required stored request id"));
        }
        Set podConfigIds = VideoRequestFactory.podConfigIds((BidRequestVideo)bidRequestVideo);
        String accountId = this.accountIdFrom(bidRequestVideo);
        return this.storedRequestProcessor.processVideoRequest(accountId, storedRequestId, podConfigIds, bidRequestVideo).map(bidRequestToErrors -> WithPodErrors.of((Object)this.ortbVersionConversionManager.convertToAuctionSupportedVersion((BidRequest)bidRequestToErrors.getData()), (List)bidRequestToErrors.getPodErrors())).map(bidRequestToErrors -> this.fillImplicitParameters(httpRequest, bidRequestToErrors, debugEnabled));
    }

    private AuctionContext updateContextWithDebugLog(AuctionContext auctionContext) {
        HttpRequestContext requestContext = auctionContext.getHttpRequest();
        boolean debugEnabled = this.isDebugEnabled(requestContext);
        CachedDebugLog cachedDebugLog = new CachedDebugLog(debugEnabled, 3600, this.escapeLogCacheRegexPattern, this.mapper);
        if (cachedDebugLog.isEnabled()) {
            cachedDebugLog.setRequest(requestContext.getBody());
            cachedDebugLog.setHeadersLog(requestContext.getHeaders());
        }
        return auctionContext.toBuilder().cachedDebugLog(cachedDebugLog).build();
    }

    private boolean isDebugEnabled(HttpRequestContext requestContext) {
        CaseInsensitiveMultiMap queryParams = (CaseInsensitiveMultiMap)ObjectUtil.getIfNotNull((Object)requestContext, HttpRequestContext::getQueryParams);
        String debugParam = (String)ObjectUtil.getIfNotNull((Object)queryParams, params -> params.get("debug"));
        return BooleanUtils.toBoolean((String)debugParam);
    }

    private BidRequestVideo parseRequest(HttpRequestContext httpRequest) {
        try {
            BidRequestVideo bidRequestVideo = (BidRequestVideo)this.mapper.decodeValue(httpRequest.getBody(), BidRequestVideo.class);
            return this.insertDeviceUa(httpRequest, bidRequestVideo);
        }
        catch (DecodeException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private BidRequestVideo insertDeviceUa(HttpRequestContext httpRequest, BidRequestVideo bidRequestVideo) {
        String deviceUa;
        Device device = bidRequestVideo.getDevice();
        String string = deviceUa = device != null ? device.getUa() : null;
        if (StringUtils.isBlank((CharSequence)deviceUa)) {
            String userAgentHeader = httpRequest.getHeaders().get(HttpUtil.USER_AGENT_HEADER);
            if (StringUtils.isEmpty((CharSequence)userAgentHeader)) {
                throw new InvalidRequestException("Device.UA and User-Agent Header is not presented");
            }
            Device.DeviceBuilder deviceBuilder = device == null ? Device.builder() : device.toBuilder();
            return bidRequestVideo.toBuilder().device(deviceBuilder.ua(userAgentHeader).build()).build();
        }
        return bidRequestVideo;
    }

    private String accountIdFrom(BidRequestVideo bidRequestVideo) {
        App app = bidRequestVideo.getApp();
        Publisher appPublisher = app != null ? app.getPublisher() : null;
        Site site = bidRequestVideo.getSite();
        Publisher sitePublisher = site != null ? site.getPublisher() : null;
        Publisher publisher = (Publisher)ObjectUtils.defaultIfNull((Object)appPublisher, (Object)sitePublisher);
        String publisherId = publisher != null ? this.resolvePublisherId(publisher) : null;
        return (String)ObjectUtils.defaultIfNull((Object)publisherId, (Object)"");
    }

    private String resolvePublisherId(Publisher publisher) {
        String parentAccountId = this.parentAccountIdFromExtPublisher(publisher.getExt());
        return (String)ObjectUtils.defaultIfNull((Object)parentAccountId, (Object)publisher.getId());
    }

    private String parentAccountIdFromExtPublisher(ExtPublisher extPublisher) {
        ExtPublisherPrebid extPublisherPrebid = extPublisher != null ? extPublisher.getPrebid() : null;
        return extPublisherPrebid != null ? StringUtils.stripToNull((String)extPublisherPrebid.getParentAccount()) : null;
    }

    private static Set<String> podConfigIds(BidRequestVideo incomingBidRequest) {
        Podconfig podconfig = incomingBidRequest.getPodconfig();
        if (podconfig != null && CollectionUtils.isNotEmpty((Collection)podconfig.getPods())) {
            return podconfig.getPods().stream().map(Pod::getConfigId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static <T> T populatePodErrors(List<PodError> from, List<PodError> to, T returnObject) {
        to.addAll(from);
        return returnObject;
    }

    private WithPodErrors<BidRequest> fillImplicitParameters(HttpRequestContext httpRequest, WithPodErrors<BidRequest> bidRequestToErrors, boolean debugEnabled) {
        BidRequest bidRequest = (BidRequest)bidRequestToErrors.getData();
        BidRequest updatedBidRequest = this.paramsResolver.resolve(bidRequest, httpRequest, ENDPOINT, false);
        BidRequest updatedWithDebugBidRequest = debugEnabled ? updatedBidRequest.toBuilder().test(Integer.valueOf(1)).build() : updatedBidRequest;
        return WithPodErrors.of((Object)updatedWithDebugBidRequest, (List)bidRequestToErrors.getPodErrors());
    }

    private Future<WithPodErrors<BidRequest>> validateRequest(WithPodErrors<BidRequest> requestWithPodErrors, HttpRequestContext httpRequestContext, List<String> warnings) {
        return this.ortb2RequestFactory.validateRequest((BidRequest)requestWithPodErrors.getData(), httpRequestContext, warnings).map(bidRequest -> requestWithPodErrors);
    }
}

