/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model.debug;

import java.beans.ConstructorProperties;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;

public final class DebugContext {
    private static final DebugContext EMPTY = DebugContext.of((boolean)false, (boolean)false, null);
    private final boolean debugEnabled;
    private final boolean shouldReturnAllBidStatuses;
    private final TraceLevel traceLevel;

    public static DebugContext empty() {
        return EMPTY;
    }

    @ConstructorProperties(value={"debugEnabled", "shouldReturnAllBidStatuses", "traceLevel"})
    private DebugContext(boolean debugEnabled, boolean shouldReturnAllBidStatuses, TraceLevel traceLevel) {
        this.debugEnabled = debugEnabled;
        this.shouldReturnAllBidStatuses = shouldReturnAllBidStatuses;
        this.traceLevel = traceLevel;
    }

    public static DebugContext of(boolean debugEnabled, boolean shouldReturnAllBidStatuses, TraceLevel traceLevel) {
        return new DebugContext(debugEnabled, shouldReturnAllBidStatuses, traceLevel);
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isShouldReturnAllBidStatuses() {
        return this.shouldReturnAllBidStatuses;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugContext)) {
            return false;
        }
        DebugContext other = (DebugContext)o;
        if (this.isDebugEnabled() != other.isDebugEnabled()) {
            return false;
        }
        if (this.isShouldReturnAllBidStatuses() != other.isShouldReturnAllBidStatuses()) {
            return false;
        }
        TraceLevel this$traceLevel = this.getTraceLevel();
        TraceLevel other$traceLevel = other.getTraceLevel();
        return !(this$traceLevel == null ? other$traceLevel != null : !this$traceLevel.equals(other$traceLevel));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebugEnabled() ? 79 : 97);
        result = result * 59 + (this.isShouldReturnAllBidStatuses() ? 79 : 97);
        TraceLevel $traceLevel = this.getTraceLevel();
        result = result * 59 + ($traceLevel == null ? 43 : $traceLevel.hashCode());
        return result;
    }

    public String toString() {
        return "DebugContext(debugEnabled=" + this.isDebugEnabled() + ", shouldReturnAllBidStatuses=" + this.isShouldReturnAllBidStatuses() + ", traceLevel=" + this.getTraceLevel() + ")";
    }
}

