/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import java.beans.ConstructorProperties;
import org.prebid.server.auction.model.BidRequestCacheInfo;

public final class BidRequestCacheInfo {
    private static final BidRequestCacheInfo NO_CACHE = BidRequestCacheInfo.builder().doCaching(false).shouldCacheBids(false).cacheBidsTtl(null).shouldCacheVideoBids(false).cacheVideoBidsTtl(null).returnCreativeBids(false).returnCreativeVideoBids(false).shouldCacheWinningBidsOnly(false).build();
    private final boolean doCaching;
    private final boolean shouldCacheBids;
    private final Integer cacheBidsTtl;
    private final boolean shouldCacheVideoBids;
    private final Integer cacheVideoBidsTtl;
    private final boolean returnCreativeBids;
    private final boolean returnCreativeVideoBids;
    private final boolean shouldCacheWinningBidsOnly;

    public static BidRequestCacheInfo noCache() {
        return NO_CACHE;
    }

    @ConstructorProperties(value={"doCaching", "shouldCacheBids", "cacheBidsTtl", "shouldCacheVideoBids", "cacheVideoBidsTtl", "returnCreativeBids", "returnCreativeVideoBids", "shouldCacheWinningBidsOnly"})
    BidRequestCacheInfo(boolean doCaching, boolean shouldCacheBids, Integer cacheBidsTtl, boolean shouldCacheVideoBids, Integer cacheVideoBidsTtl, boolean returnCreativeBids, boolean returnCreativeVideoBids, boolean shouldCacheWinningBidsOnly) {
        this.doCaching = doCaching;
        this.shouldCacheBids = shouldCacheBids;
        this.cacheBidsTtl = cacheBidsTtl;
        this.shouldCacheVideoBids = shouldCacheVideoBids;
        this.cacheVideoBidsTtl = cacheVideoBidsTtl;
        this.returnCreativeBids = returnCreativeBids;
        this.returnCreativeVideoBids = returnCreativeVideoBids;
        this.shouldCacheWinningBidsOnly = shouldCacheWinningBidsOnly;
    }

    public static BidRequestCacheInfoBuilder builder() {
        return new BidRequestCacheInfoBuilder();
    }

    public boolean isDoCaching() {
        return this.doCaching;
    }

    public boolean isShouldCacheBids() {
        return this.shouldCacheBids;
    }

    public Integer getCacheBidsTtl() {
        return this.cacheBidsTtl;
    }

    public boolean isShouldCacheVideoBids() {
        return this.shouldCacheVideoBids;
    }

    public Integer getCacheVideoBidsTtl() {
        return this.cacheVideoBidsTtl;
    }

    public boolean isReturnCreativeBids() {
        return this.returnCreativeBids;
    }

    public boolean isReturnCreativeVideoBids() {
        return this.returnCreativeVideoBids;
    }

    public boolean isShouldCacheWinningBidsOnly() {
        return this.shouldCacheWinningBidsOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidRequestCacheInfo)) {
            return false;
        }
        BidRequestCacheInfo other = (BidRequestCacheInfo)o;
        if (this.isDoCaching() != other.isDoCaching()) {
            return false;
        }
        if (this.isShouldCacheBids() != other.isShouldCacheBids()) {
            return false;
        }
        if (this.isShouldCacheVideoBids() != other.isShouldCacheVideoBids()) {
            return false;
        }
        if (this.isReturnCreativeBids() != other.isReturnCreativeBids()) {
            return false;
        }
        if (this.isReturnCreativeVideoBids() != other.isReturnCreativeVideoBids()) {
            return false;
        }
        if (this.isShouldCacheWinningBidsOnly() != other.isShouldCacheWinningBidsOnly()) {
            return false;
        }
        Integer this$cacheBidsTtl = this.getCacheBidsTtl();
        Integer other$cacheBidsTtl = other.getCacheBidsTtl();
        if (this$cacheBidsTtl == null ? other$cacheBidsTtl != null : !((Object)this$cacheBidsTtl).equals(other$cacheBidsTtl)) {
            return false;
        }
        Integer this$cacheVideoBidsTtl = this.getCacheVideoBidsTtl();
        Integer other$cacheVideoBidsTtl = other.getCacheVideoBidsTtl();
        return !(this$cacheVideoBidsTtl == null ? other$cacheVideoBidsTtl != null : !((Object)this$cacheVideoBidsTtl).equals(other$cacheVideoBidsTtl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDoCaching() ? 79 : 97);
        result = result * 59 + (this.isShouldCacheBids() ? 79 : 97);
        result = result * 59 + (this.isShouldCacheVideoBids() ? 79 : 97);
        result = result * 59 + (this.isReturnCreativeBids() ? 79 : 97);
        result = result * 59 + (this.isReturnCreativeVideoBids() ? 79 : 97);
        result = result * 59 + (this.isShouldCacheWinningBidsOnly() ? 79 : 97);
        Integer $cacheBidsTtl = this.getCacheBidsTtl();
        result = result * 59 + ($cacheBidsTtl == null ? 43 : ((Object)$cacheBidsTtl).hashCode());
        Integer $cacheVideoBidsTtl = this.getCacheVideoBidsTtl();
        result = result * 59 + ($cacheVideoBidsTtl == null ? 43 : ((Object)$cacheVideoBidsTtl).hashCode());
        return result;
    }

    public String toString() {
        return "BidRequestCacheInfo(doCaching=" + this.isDoCaching() + ", shouldCacheBids=" + this.isShouldCacheBids() + ", cacheBidsTtl=" + this.getCacheBidsTtl() + ", shouldCacheVideoBids=" + this.isShouldCacheVideoBids() + ", cacheVideoBidsTtl=" + this.getCacheVideoBidsTtl() + ", returnCreativeBids=" + this.isReturnCreativeBids() + ", returnCreativeVideoBids=" + this.isReturnCreativeVideoBids() + ", shouldCacheWinningBidsOnly=" + this.isShouldCacheWinningBidsOnly() + ")";
    }
}

