/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.mediatypeprocessor;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.SetUtils;
import org.prebid.server.auction.mediatypeprocessor.BidderMediaTypeProcessor;
import org.prebid.server.auction.mediatypeprocessor.MediaTypeProcessingResult;
import org.prebid.server.auction.mediatypeprocessor.MediaTypeProcessor;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.spring.config.bidder.model.MediaType;

/*
 * Exception performing whole class analysis ignored.
 */
public class BidderMediaTypeProcessor
implements MediaTypeProcessor {
    private static final EnumSet<MediaType> NONE_OF_MEDIA_TYPES = EnumSet.noneOf(MediaType.class);
    private final BidderCatalog bidderCatalog;

    public BidderMediaTypeProcessor(BidderCatalog bidderCatalog) {
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
    }

    public MediaTypeProcessingResult process(BidRequest bidRequest, String supportedBidderName) {
        Set supportedMediaTypes = this.extractSupportedMediaTypes(bidRequest, supportedBidderName);
        if (supportedMediaTypes.isEmpty()) {
            return MediaTypeProcessingResult.rejected(Collections.singletonList(BidderError.badInput((String)"Bidder does not support any media types.")));
        }
        ArrayList errors = new ArrayList();
        BidRequest modifiedBidRequest = this.processBidRequest(bidRequest, supportedMediaTypes, errors);
        return modifiedBidRequest != null ? MediaTypeProcessingResult.succeeded((BidRequest)modifiedBidRequest, errors) : MediaTypeProcessingResult.rejected(errors);
    }

    private Set<MediaType> extractSupportedMediaTypes(BidRequest bidRequest, String supportedBidderName) {
        BidderInfo.CapabilitiesInfo capabilitiesInfo = this.bidderCatalog.bidderInfoByName(supportedBidderName).getCapabilities();
        Supplier<BidderInfo.PlatformInfo> fetchSupportedMediaTypes = bidRequest.getSite() != null ? () -> ((BidderInfo.CapabilitiesInfo)capabilitiesInfo).getSite() : (bidRequest.getApp() != null ? () -> ((BidderInfo.CapabilitiesInfo)capabilitiesInfo).getApp() : () -> ((BidderInfo.CapabilitiesInfo)capabilitiesInfo).getDooh());
        return Optional.ofNullable(fetchSupportedMediaTypes.get()).map(BidderInfo.PlatformInfo::getMediaTypes).filter(mediaTypes -> !mediaTypes.isEmpty()).map(EnumSet::copyOf).orElse(NONE_OF_MEDIA_TYPES);
    }

    private BidRequest processBidRequest(BidRequest bidRequest, Set<MediaType> supportedMediaTypes, List<BidderError> errors) {
        List modifiedImps = bidRequest.getImp().stream().map(imp -> BidderMediaTypeProcessor.processImp((Imp)imp, (Set)supportedMediaTypes, (List)errors)).filter(Objects::nonNull).collect(Collectors.toList());
        if (modifiedImps.isEmpty()) {
            errors.add(BidderError.badInput((String)"Bid request contains 0 impressions after filtering."));
            return null;
        }
        return bidRequest.toBuilder().imp(modifiedImps).build();
    }

    private static Imp processImp(Imp imp, Set<MediaType> supportedMediaTypes, List<BidderError> errors) {
        Set impMediaTypes = BidderMediaTypeProcessor.getMediaTypes((Imp)imp);
        SetUtils.SetView unsupportedMediaTypes = SetUtils.difference((Set)impMediaTypes, supportedMediaTypes);
        if (unsupportedMediaTypes.isEmpty()) {
            return imp;
        }
        if (impMediaTypes.equals(unsupportedMediaTypes)) {
            errors.add(BidderError.badInput((String)("Imp " + imp.getId() + " does not have a supported media type and has been removed from the request for this bidder.")));
            return null;
        }
        Imp.ImpBuilder impBuilder = imp.toBuilder();
        unsupportedMediaTypes.forEach(unsupportedMediaType -> BidderMediaTypeProcessor.removeMediaType((Imp.ImpBuilder)impBuilder, (MediaType)unsupportedMediaType));
        return impBuilder.build();
    }

    private static Set<MediaType> getMediaTypes(Imp imp) {
        return Stream.of(imp.getBanner() != null ? MediaType.BANNER : null, imp.getVideo() != null ? MediaType.VIDEO : null, imp.getAudio() != null ? MediaType.AUDIO : null, imp.getXNative() != null ? MediaType.NATIVE : null).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(MediaType.class)));
    }

    private static void removeMediaType(Imp.ImpBuilder impBuilder, MediaType mediaType) {
        switch (1.$SwitchMap$org$prebid$server$spring$config$bidder$model$MediaType[mediaType.ordinal()]) {
            case 1: {
                impBuilder.banner(null);
                break;
            }
            case 2: {
                impBuilder.video(null);
                break;
            }
            case 3: {
                impBuilder.audio(null);
                break;
            }
            case 4: {
                impBuilder.xNative(null);
            }
        }
    }
}

