/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeoutResolver {
    private final long minTimeout;
    private final long maxTimeout;
    private final long upstreamResponseTime;

    public TimeoutResolver(long minTimeout, long maxTimeout, long upstreamResponseTime) {
        TimeoutResolver.validateTimeouts((long)minTimeout, (long)maxTimeout);
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
        this.upstreamResponseTime = upstreamResponseTime;
    }

    private static void validateTimeouts(long minTimeout, long maxTimeout) {
        if (minTimeout <= 0L || maxTimeout <= 0L) {
            throw new IllegalArgumentException("Both min and max timeouts should be grater than 0: min=%d, max=%d".formatted(minTimeout, maxTimeout));
        }
        if (maxTimeout < minTimeout) {
            throw new IllegalArgumentException("Max timeout cannot be less than min timeout: min=%d, max=%d".formatted(minTimeout, maxTimeout));
        }
    }

    public long limitToMax(Long timeout) {
        return timeout == null ? this.maxTimeout : Math.min(timeout, this.maxTimeout);
    }

    public long adjustForBidder(long timeout, int adjustFactor, long spentTime) {
        return this.adjustWithFactor(timeout, (double)adjustFactor / 100.0, spentTime);
    }

    public long adjustForRequest(long timeout, long spentTime) {
        return this.adjustWithFactor(timeout, 1.0, spentTime);
    }

    private long adjustWithFactor(long timeout, double adjustFactor, long spentTime) {
        return this.limitToMin((long)((double)timeout * adjustFactor) - spentTime - this.upstreamResponseTime);
    }

    private long limitToMin(long timeout) {
        return Math.max(timeout, this.minTimeout);
    }
}

