/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Data;
import com.iab.openrtb.request.Dooh;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtAppPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtBidderConfig;
import org.prebid.server.proto.openrtb.ext.request.ExtBidderConfigOrtb;
import org.prebid.server.proto.openrtb.ext.request.ExtDooh;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidBidderConfig;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidData;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.request.Targeting;

/*
 * Exception performing whole class analysis ignored.
 */
public class FpdResolver {
    private static final String USER = "user";
    private static final String SITE = "site";
    private static final String BIDDERS = "bidders";
    private static final String APP = "app";
    private static final String DOOH = "dooh";
    private static final Set<String> KNOWN_FPD_ATTRIBUTES = Set.of("user", "site", "app", "dooh", "bidders");
    private static final String ALLOW_ALL_BIDDERS = "*";
    private static final String EXT = "ext";
    private static final String CONTEXT = "context";
    private static final String DATA = "data";
    private static final Set<String> USER_DATA_ATTR = Collections.singleton("geo");
    private static final Set<String> APP_DATA_ATTR = Set.of("id", "content", "publisher", "privacypolicy");
    private static final Set<String> SITE_DATA_ATTR = Set.of("id", "content", "publisher", "privacypolicy", "mobile");
    private static final Set<String> DOOH_DATA_ATTR = Set.of("id", "content", "publisher", "privacypolicy");
    private static final TypeReference<List<Data>> USER_DATA_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final JacksonMapper jacksonMapper;
    private final JsonMerger jsonMerger;

    public FpdResolver(JacksonMapper jacksonMapper, JsonMerger jsonMerger) {
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
    }

    public User resolveUser(User originUser, ObjectNode fpdUser) {
        if (fpdUser == null) {
            return originUser;
        }
        User resultUser = originUser == null ? User.builder().build() : originUser;
        ExtUser resolvedExtUser = this.resolveUserExt(fpdUser, resultUser);
        return resultUser.toBuilder().keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdUser, (String)"keywords"), (Object)resultUser.getKeywords())).gender((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdUser, (String)"gender"), (Object)resultUser.getGender())).yob((Integer)ObjectUtils.defaultIfNull((Object)FpdResolver.getInteger((ObjectNode)fpdUser, (String)"yob"), (Object)resultUser.getYob())).data((List)ObjectUtils.defaultIfNull((Object)this.getFpdUserData(fpdUser), (Object)resultUser.getData())).ext(resolvedExtUser).build();
    }

    private ExtUser resolveUserExt(ObjectNode fpdUser, User originUser) {
        ExtUser originExtUser = originUser.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdUser.path("ext").path("data"), (JsonNode)(originExtUser != null ? originExtUser.getData() : null));
        return this.updateUserExtDataWithFpdAttr(fpdUser, originExtUser, resolvedData);
    }

    private ExtUser updateUserExtDataWithFpdAttr(ObjectNode fpdUser, ExtUser originExtUser, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        USER_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr((ObjectNode)fpdUser, (ObjectNode)resultData, (String)attribute));
        return originExtUser != null ? originExtUser.toBuilder().data(resultData.isEmpty() ? null : resultData).build() : (resultData.isEmpty() ? null : ExtUser.builder().data(resultData).build());
    }

    private List<Data> getFpdUserData(ObjectNode fpdUser) {
        ArrayNode fpdUserDataNode = (ArrayNode)FpdResolver.getValueFromJsonNode((ObjectNode)fpdUser, (String)"data", (T node) -> (ArrayNode)node, JsonNode::isArray);
        return this.toList((JsonNode)fpdUserDataNode, USER_DATA_TYPE_REFERENCE);
    }

    public App resolveApp(App originApp, ObjectNode fpdApp) {
        if (fpdApp == null) {
            return originApp;
        }
        App resultApp = originApp == null ? App.builder().build() : originApp;
        ExtApp resolvedExtApp = this.resolveAppExt(fpdApp, resultApp);
        return resultApp.toBuilder().name((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdApp, (String)"name"), (Object)resultApp.getName())).bundle((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdApp, (String)"bundle"), (Object)resultApp.getBundle())).storeurl((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdApp, (String)"storeurl"), (Object)resultApp.getStoreurl())).domain((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdApp, (String)"domain"), (Object)resultApp.getDomain())).cat((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdApp, (String)"cat"), (Object)resultApp.getCat())).sectioncat((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdApp, (String)"sectioncat"), (Object)resultApp.getSectioncat())).pagecat((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdApp, (String)"pagecat"), (Object)resultApp.getPagecat())).keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdApp, (String)"keywords"), (Object)resultApp.getKeywords())).ext(resolvedExtApp).build();
    }

    private ExtApp resolveAppExt(ObjectNode fpdApp, App originApp) {
        ExtApp originExtApp = originApp.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdApp.path("ext").path("data"), (JsonNode)(originExtApp != null ? originExtApp.getData() : null));
        return this.updateAppExtDataWithFpdAttr(fpdApp, originExtApp, resolvedData);
    }

    private ExtApp updateAppExtDataWithFpdAttr(ObjectNode fpdApp, ExtApp originExtApp, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        APP_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr((ObjectNode)fpdApp, (ObjectNode)resultData, (String)attribute));
        return originExtApp != null ? ExtApp.of((ExtAppPrebid)originExtApp.getPrebid(), (ObjectNode)(resultData.isEmpty() ? null : resultData)) : (resultData.isEmpty() ? null : ExtApp.of(null, (ObjectNode)resultData));
    }

    public Site resolveSite(Site originSite, ObjectNode fpdSite) {
        if (fpdSite == null) {
            return originSite;
        }
        Site resultSite = originSite == null ? Site.builder().build() : originSite;
        ExtSite resolvedExtSite = this.resolveSiteExt(fpdSite, resultSite);
        return resultSite.toBuilder().name((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdSite, (String)"name"), (Object)resultSite.getName())).domain((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdSite, (String)"domain"), (Object)resultSite.getDomain())).cat((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdSite, (String)"cat"), (Object)resultSite.getCat())).sectioncat((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdSite, (String)"sectioncat"), (Object)resultSite.getSectioncat())).pagecat((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdSite, (String)"pagecat"), (Object)resultSite.getPagecat())).page((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdSite, (String)"page"), (Object)resultSite.getPage())).keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdSite, (String)"keywords"), (Object)resultSite.getKeywords())).ref((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdSite, (String)"ref"), (Object)resultSite.getRef())).search((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdSite, (String)"search"), (Object)resultSite.getSearch())).ext(resolvedExtSite).build();
    }

    private ExtSite resolveSiteExt(ObjectNode fpdSite, Site originSite) {
        ExtSite originExtSite = originSite.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdSite.path("ext").path("data"), (JsonNode)(originExtSite != null ? originExtSite.getData() : null));
        return this.updateSiteExtDataWithFpdAttr(fpdSite, originExtSite, resolvedData);
    }

    private ExtSite updateSiteExtDataWithFpdAttr(ObjectNode fpdSite, ExtSite originExtSite, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        SITE_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr((ObjectNode)fpdSite, (ObjectNode)resultData, (String)attribute));
        return originExtSite != null ? ExtSite.of((Integer)originExtSite.getAmp(), (ObjectNode)(resultData.isEmpty() ? null : resultData)) : (resultData.isEmpty() ? null : ExtSite.of(null, (ObjectNode)resultData));
    }

    public Dooh resolveDooh(Dooh originDooh, ObjectNode fpdDooh) {
        if (fpdDooh == null) {
            return originDooh;
        }
        Dooh resultDooh = originDooh == null ? Dooh.builder().build() : originDooh;
        ExtDooh resolvedExtDooh = this.resolveDoohExt(fpdDooh, resultDooh);
        return resultDooh.toBuilder().name((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdDooh, (String)"name"), (Object)resultDooh.getName())).venuetype((List)ObjectUtils.defaultIfNull((Object)FpdResolver.getStrings((JsonNode)fpdDooh, (String)"venuetype"), (Object)resultDooh.getVenuetype())).venuetypetax((Integer)ObjectUtils.defaultIfNull((Object)FpdResolver.getInteger((ObjectNode)fpdDooh, (String)"venuetypetax"), (Object)resultDooh.getVenuetypetax())).domain((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdDooh, (String)"domain"), (Object)resultDooh.getDomain())).keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString((ObjectNode)fpdDooh, (String)"keywords"), (Object)resultDooh.getKeywords())).ext(resolvedExtDooh).build();
    }

    private ExtDooh resolveDoohExt(ObjectNode fpdDooh, Dooh originDooh) {
        ExtDooh originExtDooh = originDooh.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdDooh.path("ext").path("data"), (JsonNode)(originExtDooh != null ? originExtDooh.getData() : null));
        return this.updateDoohExtDataWithFpdAttr(fpdDooh, originExtDooh, resolvedData);
    }

    private ExtDooh updateDoohExtDataWithFpdAttr(ObjectNode fpdDooh, ExtDooh originExtDooh, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        DOOH_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr((ObjectNode)fpdDooh, (ObjectNode)resultData, (String)attribute));
        return originExtDooh != null ? ExtDooh.of((ObjectNode)(resultData.isEmpty() ? null : resultData)) : (resultData.isEmpty() ? null : ExtDooh.of((ObjectNode)resultData));
    }

    public ObjectNode resolveImpExt(ObjectNode impExt, ObjectNode targeting) {
        if (targeting == null) {
            return impExt;
        }
        KNOWN_FPD_ATTRIBUTES.forEach(arg_0 -> ((ObjectNode)targeting).remove(arg_0));
        if (!targeting.fieldNames().hasNext()) {
            return impExt;
        }
        if (impExt == null) {
            return (ObjectNode)this.jacksonMapper.mapper().createObjectNode().set("data", (JsonNode)targeting);
        }
        JsonNode extImpData = impExt.get("data");
        ObjectNode resolvedData = extImpData != null ? (ObjectNode)this.jsonMerger.merge((JsonNode)targeting, extImpData) : targeting;
        return (ObjectNode)impExt.set("data", (JsonNode)resolvedData);
    }

    public ObjectNode resolveImpExt(ObjectNode impExt, boolean useFirstPartyData) {
        this.removeOrReplace(impExt, "context", this.sanitizeImpExtContext(impExt, useFirstPartyData));
        this.removeOrReplace(impExt, "data", this.sanitizeImpExtData(impExt, useFirstPartyData));
        return impExt;
    }

    private JsonNode sanitizeImpExtContext(ObjectNode originalImpExt, boolean useFirstPartyData) {
        if (!originalImpExt.hasNonNull("context")) {
            return null;
        }
        JsonNode updatedContextNode = originalImpExt.get("context").deepCopy();
        if (!useFirstPartyData && updatedContextNode.hasNonNull("data")) {
            ((ObjectNode)updatedContextNode).remove("data");
        }
        return updatedContextNode.isObject() && updatedContextNode.isEmpty() ? null : updatedContextNode;
    }

    private JsonNode sanitizeImpExtData(ObjectNode impExt, boolean useFirstPartyData) {
        JsonNode mergedDataNode;
        boolean contextDataIsObject;
        if (!useFirstPartyData) {
            return null;
        }
        JsonNode contextNode = impExt.hasNonNull("context") ? impExt.get("context") : null;
        JsonNode contextDataNode = contextNode != null && contextNode.hasNonNull("data") ? contextNode.get("data") : null;
        JsonNode dataNode = impExt.get("data");
        boolean dataIsNullOrObject = dataNode == null || dataNode.isObject();
        boolean bl = contextDataIsObject = contextDataNode != null && !contextDataNode.isNull() && contextDataNode.isObject();
        JsonNode jsonNode = dataIsNullOrObject && contextDataIsObject ? (dataNode != null ? this.jsonMerger.merge(contextDataNode, dataNode) : contextDataNode) : (mergedDataNode = dataNode);
        if (mergedDataNode != null && !mergedDataNode.isNull()) {
            return mergedDataNode;
        }
        return null;
    }

    private void removeOrReplace(ObjectNode impExt, String field, JsonNode jsonNode) {
        if (jsonNode == null) {
            impExt.remove(field);
        } else {
            impExt.set(field, jsonNode);
        }
    }

    public ExtRequest resolveBidRequestExt(ExtRequest extRequest, Targeting targeting) {
        if (targeting == null) {
            return extRequest;
        }
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ExtRequestPrebidData extRequestPrebidData = extRequestPrebid != null ? extRequestPrebid.getData() : null;
        ExtRequestPrebidData resolvedExtRequestPrebidData = this.resolveExtRequestPrebidData(extRequestPrebidData, targeting.getBidders());
        List resolvedBidderConfig = this.createAllowedAllBidderConfig(targeting);
        if (resolvedExtRequestPrebidData != null || resolvedBidderConfig != null) {
            ExtRequestPrebid.ExtRequestPrebidBuilder prebidBuilder = extRequestPrebid != null ? extRequestPrebid.toBuilder() : ExtRequestPrebid.builder();
            return ExtRequest.of((ExtRequestPrebid)prebidBuilder.data(resolvedExtRequestPrebidData != null ? resolvedExtRequestPrebidData : extRequestPrebidData).bidderconfig(resolvedBidderConfig).build());
        }
        return extRequest;
    }

    private ExtRequestPrebidData resolveExtRequestPrebidData(ExtRequestPrebidData data, List<String> fpdBidders) {
        if (CollectionUtils.isEmpty(fpdBidders)) {
            return null;
        }
        List originBidders = data != null ? data.getBidders() : Collections.emptyList();
        return CollectionUtils.isEmpty((Collection)originBidders) ? ExtRequestPrebidData.of(fpdBidders, null) : ExtRequestPrebidData.of((List)this.mergeBidders(fpdBidders, originBidders), null);
    }

    private List<String> mergeBidders(List<String> fpdBidders, List<String> originBidders) {
        TreeSet<String> resolvedBidders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        resolvedBidders.addAll(originBidders);
        resolvedBidders.addAll(fpdBidders);
        return new ArrayList<String>(resolvedBidders);
    }

    private List<ExtRequestPrebidBidderConfig> createAllowedAllBidderConfig(Targeting targeting) {
        ObjectNode userNode = targeting.getUser();
        ObjectNode siteNode = targeting.getSite();
        if (userNode == null && siteNode == null) {
            return null;
        }
        List<String> bidders = Collections.singletonList("*");
        return Collections.singletonList(ExtRequestPrebidBidderConfig.of(bidders, (ExtBidderConfig)ExtBidderConfig.of(null, (ExtBidderConfigOrtb)ExtBidderConfigOrtb.of((ObjectNode)siteNode, null, null, (ObjectNode)userNode))));
    }

    private ObjectNode mergeExtData(JsonNode fpdData, JsonNode originData) {
        if (fpdData.isMissingNode() || !fpdData.isObject()) {
            return originData != null && originData.isObject() ? ((ObjectNode)originData).deepCopy() : null;
        }
        if (originData != null && originData.isObject()) {
            return (ObjectNode)this.jsonMerger.merge(fpdData, originData);
        }
        return fpdData.isObject() ? (ObjectNode)fpdData : null;
    }

    private static void setAttr(ObjectNode source, ObjectNode dest, String fieldName) {
        JsonNode field = source.get(fieldName);
        if (field != null) {
            dest.set(fieldName, field);
        }
    }

    private static List<String> getStrings(JsonNode firstItem, String fieldName) {
        JsonNode valueNode = firstItem.get(fieldName);
        ArrayNode arrayNode = valueNode != null && valueNode.isArray() ? (ArrayNode)valueNode : null;
        return arrayNode != null && FpdResolver.isTextualArray((ArrayNode)arrayNode) ? StreamSupport.stream(arrayNode.spliterator(), false).map(JsonNode::asText).toList() : null;
    }

    private static boolean isTextualArray(ArrayNode arrayNode) {
        return StreamSupport.stream(arrayNode.spliterator(), false).allMatch(JsonNode::isTextual);
    }

    private static String getString(ObjectNode firstItem, String fieldName) {
        return (String)FpdResolver.getValueFromJsonNode((ObjectNode)firstItem, (String)fieldName, JsonNode::asText, JsonNode::isTextual);
    }

    private static Integer getInteger(ObjectNode firstItem, String fieldName) {
        return (Integer)FpdResolver.getValueFromJsonNode((ObjectNode)firstItem, (String)fieldName, JsonNode::asInt, JsonNode::isInt);
    }

    private <T> List<T> toList(JsonNode node, TypeReference<List<T>> listTypeReference) {
        try {
            return (List)this.jacksonMapper.mapper().convertValue((Object)node, listTypeReference);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> T getValueFromJsonNode(ObjectNode firstItem, String fieldName, Function<JsonNode, T> nodeConverter, Predicate<JsonNode> isCorrectType) {
        JsonNode valueNode = firstItem.get(fieldName);
        return valueNode != null && isCorrectType.test(valueNode) ? (T)nodeConverter.apply(valueNode) : null;
    }
}

