/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.reporter.pubstack;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.prebid.server.analytics.AnalyticsReporter;
import org.prebid.server.analytics.model.AmpEvent;
import org.prebid.server.analytics.model.AuctionEvent;
import org.prebid.server.analytics.model.CookieSyncEvent;
import org.prebid.server.analytics.model.NotificationEvent;
import org.prebid.server.analytics.model.SetuidEvent;
import org.prebid.server.analytics.model.VideoEvent;
import org.prebid.server.analytics.reporter.pubstack.PubstackEventHandler;
import org.prebid.server.analytics.reporter.pubstack.model.EventType;
import org.prebid.server.analytics.reporter.pubstack.model.PubstackAnalyticsProperties;
import org.prebid.server.analytics.reporter.pubstack.model.PubstackConfig;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.Initializable;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class PubstackAnalyticsReporter
implements AnalyticsReporter,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(PubstackAnalyticsReporter.class);
    private static final String EVENT_REPORT_ENDPOINT_PATH = "/intake";
    private static final String CONFIG_URL_SUFFIX = "/bootstrap?scopeId=";
    private final long configurationRefreshDelay;
    private final long timeout;
    private final HttpClient httpClient;
    private final JacksonMapper jacksonMapper;
    private final Vertx vertx;
    private final Map<EventType, PubstackEventHandler> eventHandlers;
    private PubstackConfig pubstackConfig;

    public PubstackAnalyticsReporter(PubstackAnalyticsProperties pubstackAnalyticsProperties, HttpClient httpClient, JacksonMapper jacksonMapper, Vertx vertx) {
        this.configurationRefreshDelay = Objects.requireNonNull(pubstackAnalyticsProperties.getConfigurationRefreshDelayMs());
        this.timeout = Objects.requireNonNull(pubstackAnalyticsProperties.getTimeoutMs());
        this.httpClient = Objects.requireNonNull(httpClient);
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
        this.vertx = Objects.requireNonNull(vertx);
        this.eventHandlers = PubstackAnalyticsReporter.createEventHandlers((PubstackAnalyticsProperties)pubstackAnalyticsProperties, (HttpClient)httpClient, (JacksonMapper)jacksonMapper, (Vertx)vertx);
        this.pubstackConfig = PubstackConfig.of((String)pubstackAnalyticsProperties.getScopeId(), (String)pubstackAnalyticsProperties.getEndpoint(), Collections.emptyMap());
    }

    private static Map<EventType, PubstackEventHandler> createEventHandlers(PubstackAnalyticsProperties pubstackAnalyticsProperties, HttpClient httpClient, JacksonMapper jacksonMapper, Vertx vertx) {
        return Arrays.stream(EventType.values()).collect(Collectors.toMap(Function.identity(), eventType -> new PubstackEventHandler(pubstackAnalyticsProperties, false, PubstackAnalyticsReporter.buildEventEndpointUrl((String)pubstackAnalyticsProperties.getEndpoint(), (EventType)eventType), jacksonMapper, httpClient, vertx)));
    }

    private static String buildEventEndpointUrl(String endpoint, EventType eventType) {
        return HttpUtil.validateUrl((String)(endpoint + "/intake" + eventType.name()));
    }

    public <T> Future<Void> processEvent(T event) {
        Object eventType = event instanceof AmpEvent ? EventType.amp : (event instanceof AuctionEvent ? EventType.auction : (event instanceof CookieSyncEvent ? EventType.cookiesync : (event instanceof NotificationEvent ? EventType.notification : (event instanceof SetuidEvent ? EventType.setuid : (event instanceof VideoEvent ? EventType.video : null)))));
        if (eventType != null) {
            ((PubstackEventHandler)this.eventHandlers.get(eventType)).handle(event);
        }
        return Future.succeededFuture();
    }

    public int vendorId() {
        return 0;
    }

    public String name() {
        return "pubstack";
    }

    public void initialize() {
        this.vertx.setPeriodic(this.configurationRefreshDelay, id -> this.fetchRemoteConfig());
        this.fetchRemoteConfig();
    }

    void shutdown() {
        this.eventHandlers.values().forEach(PubstackEventHandler::reportEvents);
    }

    private void fetchRemoteConfig() {
        logger.info((Object)"[pubstack] Updating config: {0}", new Object[]{this.pubstackConfig});
        this.httpClient.get(PubstackAnalyticsReporter.makeEventEndpointUrl((String)this.pubstackConfig.getEndpoint(), (String)this.pubstackConfig.getScopeId()), this.timeout).map(arg_0 -> this.processRemoteConfigurationResponse(arg_0)).onComplete(arg_0 -> this.updateConfigsOnChange(arg_0));
    }

    private PubstackConfig processRemoteConfigurationResponse(HttpClientResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("[pubstack] Failed to fetch config, reason: HTTP status code " + statusCode);
        }
        String body = response.getBody();
        try {
            return (PubstackConfig)this.jacksonMapper.decodeValue(body, PubstackConfig.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("[pubstack] Failed to fetch config, reason: failed to parse response: " + body, (Throwable)e);
        }
    }

    private void updateConfigsOnChange(AsyncResult<PubstackConfig> asyncConfigResult) {
        if (asyncConfigResult.failed()) {
            logger.error((Object)"[pubstask] Fail to fetch remote configuration: {0}", new Object[]{asyncConfigResult.cause().getMessage()});
        } else if (!Objects.equals(this.pubstackConfig, asyncConfigResult.result())) {
            PubstackConfig pubstackConfig = (PubstackConfig)asyncConfigResult.result();
            this.eventHandlers.values().forEach(PubstackEventHandler::reportEvents);
            this.pubstackConfig = pubstackConfig;
            this.updateHandlers(pubstackConfig);
        }
    }

    private void updateHandlers(PubstackConfig pubstackConfig) {
        Map handlersEnabled = MapUtils.emptyIfNull((Map)pubstackConfig.getFeatures());
        this.eventHandlers.forEach((eventType, eventHandler) -> eventHandler.updateConfig(BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)handlersEnabled.get(eventType)), (boolean)false), this.makeEventHandlerEndpoint(pubstackConfig.getEndpoint(), eventType), pubstackConfig.getScopeId()));
    }

    private static String makeEventEndpointUrl(String endpoint, String scopeId) {
        try {
            return HttpUtil.validateUrl((String)(endpoint + "/bootstrap?scopeId=" + scopeId));
        }
        catch (IllegalArgumentException e) {
            String message = "[pubstack] Failed to create remote config server url for endpoint: " + endpoint;
            logger.error((Object)message);
            throw new PreBidException(message);
        }
    }

    private String makeEventHandlerEndpoint(String endpoint, EventType eventType) {
        try {
            return HttpUtil.validateUrl((String)(endpoint + "/intake/" + eventType.name()));
        }
        catch (IllegalArgumentException e) {
            String message = "[pubstack] Failed to create event report url for endpoint: " + endpoint;
            logger.error((Object)message);
            throw new PreBidException(message);
        }
    }
}

