/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.debug.USNatModuleLogEntry;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.Gpc;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.KnownChildSensitiveDataConsent;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.MspaServiceProviderMode;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.PersonalDataConsents;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SaleOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SaleOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.TargetedAdvertisingOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.TargetedAdvertisingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.USNatField;
import org.prebid.server.activity.infrastructure.rule.Rule;

/*
 * Exception performing whole class analysis ignored.
 */
public class USNatSyncUser
implements PrivacyModule,
Loggable {
    private final USNatGppReader gppReader;
    private final Rule.Result result;

    public USNatSyncUser(USNatGppReader gppReader) {
        this.gppReader = gppReader;
        this.result = USNatSyncUser.disallow((USNatGppReader)gppReader) ? Rule.Result.DISALLOW : Rule.Result.ALLOW;
    }

    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.result;
    }

    public static boolean disallow(USNatGppReader gppReader) {
        return USNatSyncUser.equals((Object)gppReader.getMspaServiceProviderMode(), (USNatField)MspaServiceProviderMode.YES) || USNatSyncUser.equals((Object)gppReader.getGpc(), (USNatField)Gpc.TRUE) || USNatSyncUser.checkSale((USNatGppReader)gppReader) || USNatSyncUser.checkSharing((USNatGppReader)gppReader) || USNatSyncUser.checkTargetedAdvertising((USNatGppReader)gppReader) || USNatSyncUser.checkKnownChildSensitiveDataConsents((USNatGppReader)gppReader) || USNatSyncUser.equals((Object)gppReader.getPersonalDataConsents(), (USNatField)PersonalDataConsents.CONSENT);
    }

    private static boolean checkSale(USNatGppReader gppReader) {
        Integer saleOptOut = gppReader.getSaleOptOut();
        Integer saleOptOutNotice = gppReader.getSaleOptOutNotice();
        return USNatSyncUser.equals((Object)saleOptOut, (USNatField)SaleOptOut.OPTED_OUT) || USNatSyncUser.equals((Object)saleOptOutNotice, (USNatField)SaleOptOutNotice.NO) || USNatSyncUser.equals((Object)saleOptOutNotice, (USNatField)SaleOptOutNotice.NOT_APPLICABLE) && USNatSyncUser.equals((Object)saleOptOut, (USNatField)SaleOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkSharing(USNatGppReader gppReader) {
        Integer sharingNotice = gppReader.getSharingNotice();
        Integer sharingOptOut = gppReader.getSharingOptOut();
        Integer sharingOptOutNotice = gppReader.getSharingOptOutNotice();
        return USNatSyncUser.equals((Object)sharingNotice, (USNatField)SharingNotice.NO) || USNatSyncUser.equals((Object)sharingOptOut, (USNatField)SharingOptOut.OPTED_OUT) || USNatSyncUser.equals((Object)sharingOptOutNotice, (USNatField)SharingOptOutNotice.NO) || USNatSyncUser.equals((Object)sharingNotice, (USNatField)SharingNotice.NOT_APPLICABLE) && USNatSyncUser.equals((Object)sharingOptOut, (USNatField)SharingOptOut.DID_NOT_OPT_OUT) || USNatSyncUser.equals((Object)sharingOptOutNotice, (USNatField)SharingOptOutNotice.NOT_APPLICABLE) && USNatSyncUser.equals((Object)sharingOptOut, (USNatField)SharingOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkTargetedAdvertising(USNatGppReader gppReader) {
        Integer targetedAdvertisingOptOut = gppReader.getTargetedAdvertisingOptOut();
        Integer targetedAdvertisingOptOutNotice = gppReader.getTargetedAdvertisingOptOutNotice();
        return USNatSyncUser.equals((Object)targetedAdvertisingOptOut, (USNatField)TargetedAdvertisingOptOut.OPTED_OUT) || USNatSyncUser.equals((Object)targetedAdvertisingOptOutNotice, (USNatField)TargetedAdvertisingOptOutNotice.NO) || USNatSyncUser.equals((Object)targetedAdvertisingOptOutNotice, (USNatField)TargetedAdvertisingOptOutNotice.NOT_APPLICABLE) && USNatSyncUser.equals((Object)targetedAdvertisingOptOut, (USNatField)TargetedAdvertisingOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkKnownChildSensitiveDataConsents(USNatGppReader gppReader) {
        List knownChildSensitiveDataConsents = gppReader.getKnownChildSensitiveDataConsents();
        return USNatSyncUser.equalsAtIndex((USNatField)KnownChildSensitiveDataConsent.NO_CONSENT, (List)knownChildSensitiveDataConsents, (int)0) || USNatSyncUser.equalsAtIndex((USNatField)KnownChildSensitiveDataConsent.NO_CONSENT, (List)knownChildSensitiveDataConsents, (int)1) || USNatSyncUser.equalsAtIndex((USNatField)KnownChildSensitiveDataConsent.CONSENT, (List)knownChildSensitiveDataConsents, (int)1);
    }

    private static <T> boolean equalsAtIndex(USNatField<T> expectedValue, List<T> list, int index) {
        return list != null && list.size() > index && USNatSyncUser.equals(list.get(index), expectedValue);
    }

    private static <T> boolean equals(T providedValue, USNatField<T> expectedValue) {
        return Objects.equals(providedValue, expectedValue.value());
    }

    public JsonNode asLogEntry(ObjectMapper mapper) {
        return USNatModuleLogEntry.from((PrivacyModule)this, (USNatGppReader)this.gppReader, (Rule.Result)this.result);
    }
}

