/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.payload.impl;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GeoActivityInvocationPayload;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.privacy.gdpr.model.TcfContext;

public final class TcfContextActivityInvocationPayload
implements GeoActivityInvocationPayload {
    private final ActivityInvocationPayload componentInfo;
    private final TcfContext tcfContext;

    public String country() {
        return Optional.ofNullable(this.tcfContext).map(TcfContext::getGeoInfo).map(GeoInfo::getCountry).orElse(null);
    }

    public String region() {
        return Optional.ofNullable(this.tcfContext).map(TcfContext::getGeoInfo).map(GeoInfo::getRegion).orElse(null);
    }

    @ConstructorProperties(value={"componentInfo", "tcfContext"})
    private TcfContextActivityInvocationPayload(ActivityInvocationPayload componentInfo, TcfContext tcfContext) {
        this.componentInfo = componentInfo;
        this.tcfContext = tcfContext;
    }

    public static TcfContextActivityInvocationPayload of(ActivityInvocationPayload componentInfo, TcfContext tcfContext) {
        return new TcfContextActivityInvocationPayload(componentInfo, tcfContext);
    }

    public ActivityInvocationPayload componentInfo() {
        return this.componentInfo;
    }

    public TcfContext tcfContext() {
        return this.tcfContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcfContextActivityInvocationPayload)) {
            return false;
        }
        TcfContextActivityInvocationPayload other = (TcfContextActivityInvocationPayload)o;
        ActivityInvocationPayload this$componentInfo = this.componentInfo();
        ActivityInvocationPayload other$componentInfo = other.componentInfo();
        if (this$componentInfo == null ? other$componentInfo != null : !this$componentInfo.equals(other$componentInfo)) {
            return false;
        }
        TcfContext this$tcfContext = this.tcfContext();
        TcfContext other$tcfContext = other.tcfContext();
        return !(this$tcfContext == null ? other$tcfContext != null : !this$tcfContext.equals(other$tcfContext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActivityInvocationPayload $componentInfo = this.componentInfo();
        result = result * 59 + ($componentInfo == null ? 43 : $componentInfo.hashCode());
        TcfContext $tcfContext = this.tcfContext();
        result = result * 59 + ($tcfContext == null ? 43 : $tcfContext.hashCode());
        return result;
    }

    public String toString() {
        return "TcfContextActivityInvocationPayload(componentInfo=" + this.componentInfo() + ", tcfContext=" + this.tcfContext() + ")";
    }

    public ComponentType componentType() {
        return this.componentInfo().componentType();
    }

    public String componentName() {
        return this.componentInfo().componentName();
    }
}

