/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vast;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.cache.proto.request.PutObject;
import org.prebid.server.events.EventsContext;
import org.prebid.server.events.EventsService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;

public class VastModifier {
    private static final String IN_LINE_TAG = "<InLine>";
    private static final String IN_LINE_CLOSE_TAG = "</InLine>";
    private static final String WRAPPER_TAG = "<Wrapper>";
    private static final String WRAPPER_CLOSE_TAG = "</Wrapper>";
    private static final String IMPRESSION_CLOSE_TAG = "</Impression>";
    private final BidderCatalog bidderCatalog;
    private final EventsService eventsService;
    private final Metrics metrics;

    public VastModifier(BidderCatalog bidderCatalog, EventsService eventsService, Metrics metrics) {
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.eventsService = Objects.requireNonNull(eventsService);
        this.metrics = Objects.requireNonNull(metrics);
    }

    public JsonNode modifyVastXml(Boolean isEventsEnabled, Set<String> allowedBidders, PutObject putObject, String accountId, String integration) {
        boolean isValueValid;
        JsonNode value = putObject.getValue();
        String bidder = putObject.getBidder();
        boolean bl = isValueValid = value != null && !value.isNull();
        if (BooleanUtils.isTrue((Boolean)isEventsEnabled) && allowedBidders.contains(bidder) && isValueValid) {
            EventsContext eventsContext = EventsContext.builder().auctionId(putObject.getAid()).auctionTimestamp(putObject.getTimestamp()).integration(integration).build();
            String vastUrlTracking = this.eventsService.vastUrlTracking(putObject.getBidid(), bidder, accountId, null, eventsContext);
            try {
                return new TextNode(this.appendTrackingUrlToVastXml(value.asText(), vastUrlTracking, bidder));
            }
            catch (PreBidException e) {
                this.metrics.updateAdapterRequestErrorMetric(bidder, MetricName.badserverresponse);
            }
        }
        return value;
    }

    public String createBidVastXml(String bidder, String bidAdm, String bidNurl, String eventBidId, String accountId, EventsContext eventsContext, List<String> debugWarnings, String lineItemId) {
        if (!this.bidderCatalog.isModifyingVastXmlAllowed(bidder)) {
            return bidAdm;
        }
        String vastXml = VastModifier.resolveVastXmlFrom(bidAdm, bidNurl);
        if (!eventsContext.isEnabledForAccount()) {
            return vastXml;
        }
        String vastUrl = this.eventsService.vastUrlTracking(eventBidId, bidder, accountId, lineItemId, eventsContext);
        try {
            return this.appendTrackingUrlToVastXml(vastXml, vastUrl, bidder);
        }
        catch (PreBidException e) {
            debugWarnings.add(e.getMessage());
            this.metrics.updateAdapterRequestErrorMetric(bidder, MetricName.badserverresponse);
            return vastXml;
        }
    }

    private static String resolveVastXmlFrom(String bidAdm, String bidNurl) {
        return StringUtils.isEmpty((CharSequence)bidAdm) && bidNurl != null ? "<VAST version=\"3.0\"><Ad><Wrapper><AdSystem>prebid.org wrapper</AdSystem><VASTAdTagURI><![CDATA[%s]]></VASTAdTagURI><Creatives></Creatives></Wrapper></Ad></VAST>".formatted(bidNurl) : bidAdm;
    }

    private String appendTrackingUrlToVastXml(String vastXml, String vastUrlTracking, String bidder) {
        int inLineTagIndex = StringUtils.indexOfIgnoreCase((CharSequence)vastXml, (CharSequence)IN_LINE_TAG);
        int wrapperTagIndex = StringUtils.indexOfIgnoreCase((CharSequence)vastXml, (CharSequence)WRAPPER_TAG);
        if (inLineTagIndex != -1) {
            return VastModifier.appendTrackingUrl(vastXml, vastUrlTracking, IN_LINE_CLOSE_TAG);
        }
        if (wrapperTagIndex != -1) {
            return VastModifier.appendTrackingUrl(vastXml, vastUrlTracking, WRAPPER_CLOSE_TAG);
        }
        throw new PreBidException("VastXml does not contain neither InLine nor Wrapper for %s response".formatted(bidder));
    }

    private static String appendTrackingUrl(String vastXml, String vastUrlTracking, String elementCloseTag) {
        if (vastXml.contains(IMPRESSION_CLOSE_TAG)) {
            return VastModifier.insertAfterExistingImpressionTag(vastXml, vastUrlTracking);
        }
        return VastModifier.insertBeforeElementCloseTag(vastXml, vastUrlTracking, elementCloseTag);
    }

    private static String insertAfterExistingImpressionTag(String vastXml, String vastUrlTracking) {
        String impressionTag = "<Impression><![CDATA[" + vastUrlTracking + "]]></Impression>";
        int replacementStart = vastXml.lastIndexOf(IMPRESSION_CLOSE_TAG);
        return vastXml.substring(0, replacementStart) + IMPRESSION_CLOSE_TAG + impressionTag + vastXml.substring(replacementStart + IMPRESSION_CLOSE_TAG.length());
    }

    private static String insertBeforeElementCloseTag(String vastXml, String vastUrlTracking, String elementCloseTag) {
        int indexOfCloseTag = StringUtils.indexOfIgnoreCase((CharSequence)vastXml, (CharSequence)elementCloseTag);
        if (indexOfCloseTag == -1) {
            return vastXml;
        }
        String caseSpecificCloseTag = vastXml.substring(indexOfCloseTag, indexOfCloseTag + elementCloseTag.length());
        String impressionTag = "<Impression><![CDATA[" + vastUrlTracking + "]]></Impression>";
        return vastXml.replace(caseSpecificCloseTag, impressionTag + caseSpecificCloseTag);
    }
}

