/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.validation;

import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.request.video.BidRequestVideo;
import com.iab.openrtb.request.video.Pod;
import com.iab.openrtb.request.video.PodError;
import com.iab.openrtb.request.video.Podconfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.WithPodErrors;
import org.prebid.server.exception.InvalidRequestException;

public class VideoRequestValidator {
    public void validateStoredBidRequest(BidRequestVideo bidRequestVideo, boolean enforceStoredRequest, List<String> blacklistedAccounts) {
        if (enforceStoredRequest && StringUtils.isBlank((CharSequence)bidRequestVideo.getStoredrequestid())) {
            throw new InvalidRequestException("request missing required field: storedrequestid");
        }
        Podconfig podconfig = bidRequestVideo.getPodconfig();
        if (podconfig == null) {
            throw new InvalidRequestException("request missing required field: PodConfig");
        }
        List<Integer> durationRangeSec = podconfig.getDurationRangeSec();
        if (CollectionUtils.isEmpty(durationRangeSec) || VideoRequestValidator.isZeroOrNegativeDuration(durationRangeSec)) {
            throw new InvalidRequestException("duration array require only positive numbers");
        }
        List<Pod> pods = podconfig.getPods();
        if (CollectionUtils.sizeIsEmpty(pods)) {
            throw new InvalidRequestException("request missing required field: PodConfig.Pods");
        }
        this.validateSiteAndApp(bidRequestVideo.getSite(), bidRequestVideo.getApp(), blacklistedAccounts);
        VideoRequestValidator.validateVideo(bidRequestVideo.getVideo());
    }

    private static boolean isZeroOrNegativeDuration(List<Integer> durationRangeSec) {
        return durationRangeSec.stream().anyMatch(duration -> duration <= 0);
    }

    private void validateSiteAndApp(Site site, App app, List<String> blacklistedAccounts) {
        if (app == null && site == null) {
            throw new InvalidRequestException("request missing required field: site or app");
        }
        if (app != null && site != null) {
            throw new InvalidRequestException("request.site or request.app must be defined, but not both");
        }
        if (site != null && StringUtils.isBlank((CharSequence)site.getId()) && StringUtils.isBlank((CharSequence)site.getPage())) {
            throw new InvalidRequestException("request.site missing required field: id or page");
        }
        if (app != null) {
            String appId = app.getId();
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                if (blacklistedAccounts.contains(appId)) {
                    throw new InvalidRequestException("Prebid-server does not process requests from App ID: " + appId);
                }
            } else if (StringUtils.isBlank((CharSequence)app.getBundle())) {
                throw new InvalidRequestException("request.app missing required field: id or bundle");
            }
        }
    }

    private static void validateVideo(Video video) {
        if (video == null) {
            throw new InvalidRequestException("request missing required field: Video");
        }
        List<String> mimes = video.getMimes();
        if (CollectionUtils.isEmpty(mimes)) {
            throw new InvalidRequestException("request missing required field: Video.Mimes");
        }
        List<String> notBlankMimes = mimes.stream().filter(StringUtils::isNotBlank).toList();
        if (CollectionUtils.isEmpty(notBlankMimes)) {
            throw new InvalidRequestException("request missing required field: Video.Mimes, mime types contains empty strings only");
        }
        if (CollectionUtils.isEmpty(video.getProtocols())) {
            throw new InvalidRequestException("request missing required field: Video.Protocols");
        }
    }

    public WithPodErrors<List<Pod>> validPods(Podconfig podconfig, Set<String> storedPodConfigIds) {
        List<Pod> pods = podconfig.getPods();
        List<PodError> podErrors = VideoRequestValidator.validateEachPod(pods);
        List<Integer> errorPodIds = podErrors.stream().map(PodError::getPodId).toList();
        ArrayList<Pod> validPods = new ArrayList<Pod>();
        for (int i = 0; i < pods.size(); ++i) {
            Pod pod = pods.get(i);
            Integer podId = pod.getPodId();
            String configId = pod.getConfigId();
            if (errorPodIds.contains(podId)) continue;
            if (storedPodConfigIds.contains(configId)) {
                validPods.add(pod);
                continue;
            }
            podErrors.add(PodError.of(podId, i, Collections.singletonList("unable to load Pod id: " + podId)));
        }
        return WithPodErrors.of(validPods, podErrors);
    }

    private static List<PodError> validateEachPod(List<Pod> pods) {
        ArrayList<PodError> podErrorsResult = new ArrayList<PodError>();
        HashMap<Integer, Boolean> podIdToFlag = new HashMap<Integer, Boolean>();
        for (int i = 0; i < pods.size(); ++i) {
            Integer adpodDurationSec;
            ArrayList<String> podErrors = new ArrayList<String>();
            Pod pod = pods.get(i);
            Integer podId = pod.getPodId();
            if (BooleanUtils.isTrue((Boolean)((Boolean)podIdToFlag.get(podId)))) {
                podErrors.add("request duplicated required field: PodConfig.Pods.PodId, Pod id: " + podId);
            } else {
                podIdToFlag.put(podId, true);
            }
            if (podId == null || podId <= 0) {
                podErrors.add("request missing required field: PodConfig.Pods.PodId, Pod index: " + i);
            }
            if ((adpodDurationSec = pod.getAdpodDurationSec()) != null) {
                if (adpodDurationSec == 0) {
                    podErrors.add("request missing or incorrect required field: PodConfig.Pods.AdPodDurationSec, Pod index: " + i);
                }
                if (adpodDurationSec < 0) {
                    podErrors.add("request incorrect required field: PodConfig.Pods.AdPodDurationSec is negative, Pod index: " + i);
                }
            } else {
                podErrors.add("request missing or incorrect required field: PodConfig.Pods.AdPodDurationSec, Pod index: " + i);
            }
            if (StringUtils.isBlank((CharSequence)pod.getConfigId())) {
                podErrors.add("request missing or incorrect required field: PodConfig.Pods.ConfigId, Pod index: " + i);
            }
            if (podErrors.isEmpty()) continue;
            podErrorsResult.add(PodError.of(podId, i, podErrors));
        }
        return podErrorsResult;
    }
}

