/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Pmp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtDeal;
import org.prebid.server.proto.openrtb.ext.request.ExtDealLine;

public class LineItemUtil {
    private static final Logger logger = LoggerFactory.getLogger(LineItemUtil.class);

    private LineItemUtil() {
    }

    public static String lineItemIdFrom(Bid bid, List<Imp> imps, JacksonMapper mapper) {
        if (StringUtils.isEmpty((CharSequence)bid.getDealid())) {
            return null;
        }
        ExtDealLine extDealLine = LineItemUtil.extDealLineFrom(bid, imps, mapper);
        return extDealLine != null ? extDealLine.getLineItemId() : null;
    }

    private static ExtDealLine extDealLineFrom(Bid bid, List<Imp> imps, JacksonMapper mapper) {
        Imp correspondingImp = imps.stream().filter(imp -> Objects.equals(imp.getId(), bid.getImpid())).findFirst().orElse(null);
        return correspondingImp != null ? LineItemUtil.extDealLineFrom(bid, correspondingImp, mapper) : null;
    }

    public static ExtDealLine extDealLineFrom(Bid bid, Imp imp, JacksonMapper mapper) {
        if (StringUtils.isEmpty((CharSequence)bid.getDealid())) {
            return null;
        }
        Pmp pmp = imp.getPmp();
        List<Deal> deals = pmp != null ? pmp.getDeals() : null;
        return CollectionUtils.isEmpty(deals) ? null : (ExtDealLine)deals.stream().filter(Objects::nonNull).filter(deal -> Objects.equals(deal.getId(), bid.getDealid())).map(Deal::getExt).filter(Objects::nonNull).map(ext -> LineItemUtil.dealExt((JsonNode)ext, mapper)).filter(Objects::nonNull).map(ExtDeal::getLine).findFirst().orElse(null);
    }

    private static ExtDeal dealExt(JsonNode ext, JacksonMapper mapper) {
        try {
            return (ExtDeal)mapper.mapper().treeToValue((TreeNode)ext, ExtDeal.class);
        }
        catch (JsonProcessingException e) {
            logger.warn((Object)"Error decoding deal.ext: {0}", (Throwable)e, new Object[]{e.getMessage()});
            return null;
        }
    }
}

