/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;

public final class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    public static final String APPLICATION_JSON_CONTENT_TYPE = HttpHeaderValues.APPLICATION_JSON + ";" + HttpHeaderValues.CHARSET + "=" + StandardCharsets.UTF_8.toString().toLowerCase();
    public static final CharSequence X_FORWARDED_FOR_HEADER = HttpHeaders.createOptimized((String)"X-Forwarded-For");
    public static final CharSequence X_REAL_IP_HEADER = HttpHeaders.createOptimized((String)"X-Real-Ip");
    public static final CharSequence DNT_HEADER = HttpHeaders.createOptimized((String)"DNT");
    public static final CharSequence X_REQUEST_AGENT_HEADER = HttpHeaders.createOptimized((String)"X-Request-Agent");
    public static final CharSequence ORIGIN_HEADER = HttpHeaders.createOptimized((String)"Origin");
    public static final CharSequence ACCEPT_HEADER = HttpHeaders.createOptimized((String)"Accept");
    public static final CharSequence SEC_GPC_HEADER = HttpHeaders.createOptimized((String)"Sec-GPC");
    public static final CharSequence CONTENT_TYPE_HEADER = HttpHeaders.createOptimized((String)"Content-Type");
    public static final CharSequence X_REQUESTED_WITH_HEADER = HttpHeaders.createOptimized((String)"X-Requested-With");
    public static final CharSequence REFERER_HEADER = HttpHeaders.createOptimized((String)"Referer");
    public static final CharSequence USER_AGENT_HEADER = HttpHeaders.createOptimized((String)"User-Agent");
    public static final CharSequence COOKIE_HEADER = HttpHeaders.createOptimized((String)"Cookie");
    public static final CharSequence ACCEPT_LANGUAGE_HEADER = HttpHeaders.createOptimized((String)"Accept-Language");
    public static final CharSequence SET_COOKIE_HEADER = HttpHeaders.createOptimized((String)"Set-Cookie");
    public static final CharSequence AUTHORIZATION_HEADER = HttpHeaders.createOptimized((String)"Authorization");
    public static final CharSequence DATE_HEADER = HttpHeaders.createOptimized((String)"Date");
    public static final CharSequence CACHE_CONTROL_HEADER = HttpHeaders.createOptimized((String)"Cache-Control");
    public static final CharSequence EXPIRES_HEADER = HttpHeaders.createOptimized((String)"Expires");
    public static final CharSequence PRAGMA_HEADER = HttpHeaders.createOptimized((String)"Pragma");
    public static final CharSequence LOCATION_HEADER = HttpHeaders.createOptimized((String)"Location");
    public static final CharSequence CONNECTION_HEADER = HttpHeaders.createOptimized((String)"Connection");
    public static final CharSequence ACCEPT_ENCODING_HEADER = HttpHeaders.createOptimized((String)"Accept-Encoding");
    public static final CharSequence CONTENT_ENCODING_HEADER = HttpHeaders.createOptimized((String)"Content-Encoding");
    public static final CharSequence X_OPENRTB_VERSION_HEADER = HttpHeaders.createOptimized((String)"x-openrtb-version");
    public static final CharSequence X_PREBID_HEADER = HttpHeaders.createOptimized((String)"x-prebid");
    private static final Set<String> SENSITIVE_HEADERS = Set.of(AUTHORIZATION_HEADER.toString());
    public static final CharSequence PG_TRX_ID = HttpHeaders.createOptimized((String)"pg-trx-id");
    public static final CharSequence PG_IGNORE_PACING = HttpHeaders.createOptimized((String)"X-Prebid-PG-ignore-pacing");
    private static final String BASIC_AUTH_PATTERN = "Basic %s";

    private HttpUtil() {
    }

    public static String validateUrl(String url) {
        try {
            return new URL(url).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL supplied is not valid: " + url, e);
        }
    }

    public static String encodeUrl(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static String decodeUrl(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public static MultiMap headers() {
        return MultiMap.caseInsensitiveMultiMap().add(CONTENT_TYPE_HEADER, (CharSequence)APPLICATION_JSON_CONTENT_TYPE).add(ACCEPT_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
    }

    public static void addHeaderIfValueIsNotEmpty(MultiMap headers, CharSequence headerName, CharSequence headerValue) {
        if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
            headers.add(headerName, headerValue);
        }
    }

    public static ZonedDateTime getDateFromHeader(MultiMap headers, String header) {
        return HttpUtil.getDateFromHeader(arg_0 -> ((MultiMap)headers).get(arg_0), header);
    }

    public static ZonedDateTime getDateFromHeader(CaseInsensitiveMultiMap headers, String header) {
        return HttpUtil.getDateFromHeader(headers::get, header);
    }

    private static ZonedDateTime getDateFromHeader(Function<String, String> headerGetter, String header) {
        String isoTimeStamp = headerGetter.apply(header);
        if (isoTimeStamp == null) {
            return null;
        }
        try {
            return ZonedDateTime.parse(isoTimeStamp);
        }
        catch (Exception e) {
            throw new PreBidException("%s header is not compatible to ISO-8601 format: %s".formatted(header, isoTimeStamp));
        }
    }

    public static String getHostFromUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Map<String, String> cookiesAsMap(HttpRequestContext httpRequest) {
        String cookieHeader = httpRequest.getHeaders().get(HttpHeaders.COOKIE);
        if (cookieHeader == null) {
            return Collections.emptyMap();
        }
        return ServerCookieDecoder.STRICT.decode(cookieHeader).stream().collect(Collectors.toMap(Cookie::name, Cookie::value));
    }

    public static Map<String, String> cookiesAsMap(RoutingContext routingContext) {
        return routingContext.cookieMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((io.vertx.core.http.Cookie)entry.getValue()).getValue()));
    }

    public static String createCookiesHeader(RoutingContext routingContext) {
        return routingContext.cookieMap().entrySet().stream().map(entry -> io.vertx.core.http.Cookie.cookie((String)((String)entry.getKey()), (String)((io.vertx.core.http.Cookie)entry.getValue()).getValue())).map(io.vertx.core.http.Cookie::encode).collect(Collectors.joining("; "));
    }

    public static boolean executeSafely(RoutingContext routingContext, Endpoint endpoint, Consumer<HttpServerResponse> responseConsumer) {
        return HttpUtil.executeSafely(routingContext, endpoint.value(), responseConsumer);
    }

    public static boolean executeSafely(RoutingContext routingContext, String endpoint, Consumer<HttpServerResponse> responseConsumer) {
        HttpServerResponse response = routingContext.response();
        if (response.closed()) {
            conditionalLogger.warn("Client already closed connection, response to %s will be skipped".formatted(endpoint), 0.01);
            return false;
        }
        try {
            responseConsumer.accept(response);
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to send {0} response: {1}", new Object[]{endpoint, e.getMessage()});
            return false;
        }
    }

    public static String makeBasicAuthHeaderValue(String username, String password) {
        return BASIC_AUTH_PATTERN.formatted(Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
    }

    public static Map<String, List<String>> toDebugHeaders(MultiMap headers) {
        return headers != null ? headers.entries().stream().filter(entry -> !HttpUtil.isSensitiveHeader((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) ? Arrays.stream(((String)entry.getValue()).split(",")).map(String::trim).toList() : Collections.singletonList((String)entry.getValue()))) : null;
    }

    private static boolean isSensitiveHeader(String header) {
        return SENSITIVE_HEADERS.stream().anyMatch(header::equalsIgnoreCase);
    }
}

