/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder.util;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.bidder.UsersyncMethodType;
import org.prebid.server.bidder.Usersyncer;
import org.prebid.server.spring.config.bidder.model.usersync.CookieFamilySource;
import org.prebid.server.spring.config.bidder.model.usersync.UsersyncConfigurationProperties;
import org.prebid.server.spring.config.bidder.model.usersync.UsersyncMethodConfigurationProperties;
import org.prebid.server.util.HttpUtil;

public class UsersyncerCreator {
    private UsersyncerCreator() {
    }

    public static BiFunction<UsersyncConfigurationProperties, CookieFamilySource, Usersyncer> create(String externalUrl) {
        return (usersyncConfig, cookieFamilySource) -> UsersyncerCreator.createAndValidate(usersyncConfig, cookieFamilySource, externalUrl);
    }

    private static Usersyncer createAndValidate(UsersyncConfigurationProperties usersync, CookieFamilySource cookieFamilySource, String externalUrl) {
        String cookieFamilyName = usersync.getCookieFamilyName();
        return Usersyncer.of(usersync.getEnabled(), cookieFamilyName, cookieFamilySource, UsersyncerCreator.toMethod(UsersyncMethodType.IFRAME, usersync.getIframe(), cookieFamilyName, externalUrl), UsersyncerCreator.toMethod(UsersyncMethodType.REDIRECT, usersync.getRedirect(), cookieFamilyName, externalUrl));
    }

    private static UsersyncMethod toMethod(UsersyncMethodType type, UsersyncMethodConfigurationProperties properties, String cookieFamilyName, String externalUrl) {
        if (properties == null) {
            return null;
        }
        return UsersyncMethod.builder().type(type).usersyncUrl(Objects.requireNonNull(properties.getUrl())).redirectUrl(UsersyncerCreator.toRedirectUrl(cookieFamilyName, externalUrl, properties.getUidMacro())).supportCORS(properties.getSupportCors()).formatOverride(properties.getFormatOverride()).build();
    }

    private static String toRedirectUrl(String cookieFamilyName, String externalUri, String uidMacro) {
        return "%s/setuid?bidder=%s&gdpr={{gdpr}}&gdpr_consent={{gdpr_consent}}&us_privacy={{us_privacy}}&gpp={{gpp}}&gpp_sid={{gpp_sid}}&uid=%s".formatted(HttpUtil.validateUrl(externalUri), cookieFamilyName, StringUtils.defaultString((String)uidMacro));
    }
}

