/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.tripleliftnative.TripleliftNativeBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/bidder-config/tripleliftnative.yaml"}, factory=YamlPropertySourceFactory.class)
public class TripleliftNativeConfiguration {
    private static final String BIDDER_NAME = "triplelift_native";

    @Bean(value={"tripleliftNativeConfigurationProperties"})
    @ConfigurationProperties(value="adapters.tripleliftnative")
    TripleliftNativeConfigurationProperties configurationProperties() {
        return new TripleliftNativeConfigurationProperties();
    }

    @Bean
    BidderDeps tripleliftNativeBidderDeps(TripleliftNativeConfigurationProperties tripleliftNativeConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(tripleliftNativeConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new TripleliftNativeBidder(config.getEndpoint(), tripleliftNativeConfigurationProperties.getWhitelist(), mapper)).assemble();
    }

    @Validated
    public static class TripleliftNativeConfigurationProperties
    extends BidderConfigurationProperties {
        @NotNull
        private List<String> whitelist;

        @NotNull
        public List<String> getWhitelist() {
            return this.whitelist;
        }

        public void setWhitelist(@NotNull List<String> whitelist) {
            this.whitelist = whitelist;
        }

        @Override
        public String toString() {
            return "TripleliftNativeConfiguration.TripleliftNativeConfigurationProperties(whitelist=" + this.getWhitelist() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TripleliftNativeConfigurationProperties)) {
                return false;
            }
            TripleliftNativeConfigurationProperties other = (TripleliftNativeConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<String> this$whitelist = this.getWhitelist();
            List<String> other$whitelist = other.getWhitelist();
            return !(this$whitelist == null ? other$whitelist != null : !((Object)this$whitelist).equals(other$whitelist));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TripleliftNativeConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<String> $whitelist = this.getWhitelist();
            result = result * 59 + ($whitelist == null ? 43 : ((Object)$whitelist).hashCode());
            return result;
        }

        public TripleliftNativeConfigurationProperties() {
        }

        @ConstructorProperties(value={"whitelist"})
        public TripleliftNativeConfigurationProperties(@NotNull List<String> whitelist) {
            this.whitelist = whitelist;
        }
    }
}

