/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.taboola.TaboolaBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/taboola.yaml"}, factory=YamlPropertySourceFactory.class)
public class TaboolaConfiguration {
    private static final String BIDDER_NAME = "taboola";

    @Bean(value={"taboolaConfigurationProperties"})
    @ConfigurationProperties(value="adapters.taboola")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps taboolaBidderDeps(BidderConfigurationProperties taboolaConfigurationProperties, @Value(value="${gdpr.host-vendor-id:#{null}}") Integer hostVendorId, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(taboolaConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new TaboolaBidder(config.getEndpoint(), hostVendorId, mapper)).assemble();
    }
}

