/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.rubicon.RubiconBidder;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.floors.PriceFloorResolver;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/bidder-config/rubicon.yaml"}, factory=YamlPropertySourceFactory.class)
public class RubiconConfiguration {
    private static final String BIDDER_NAME = "rubicon";

    @Bean(value={"rubiconConfigurationProperties"})
    @ConfigurationProperties(value="adapters.rubicon")
    RubiconConfigurationProperties configurationProperties() {
        return new RubiconConfigurationProperties();
    }

    @Bean
    BidderDeps rubiconBidderDeps(RubiconConfigurationProperties rubiconConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, CurrencyConversionService currencyConversionService, PriceFloorResolver floorResolver, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(rubiconConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new RubiconBidder(config.getEndpoint(), config.getXapi().getUsername(), config.getXapi().getPassword(), config.getMetaInfo().getSupportedVendors(), config.getGenerateBidId(), currencyConversionService, floorResolver, mapper)).assemble();
    }

    @Validated
    private static class RubiconConfigurationProperties
    extends BidderConfigurationProperties {
        @Valid
        @NotNull
        private XAPI xapi = new XAPI();
        @NotNull
        private Boolean generateBidId;

        @NotNull
        public XAPI getXapi() {
            return this.xapi;
        }

        @NotNull
        public Boolean getGenerateBidId() {
            return this.generateBidId;
        }

        public void setXapi(@NotNull XAPI xapi) {
            this.xapi = xapi;
        }

        public void setGenerateBidId(@NotNull Boolean generateBidId) {
            this.generateBidId = generateBidId;
        }

        @Override
        public String toString() {
            return "RubiconConfiguration.RubiconConfigurationProperties(xapi=" + this.getXapi() + ", generateBidId=" + this.getGenerateBidId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RubiconConfigurationProperties)) {
                return false;
            }
            RubiconConfigurationProperties other = (RubiconConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$generateBidId = this.getGenerateBidId();
            Boolean other$generateBidId = other.getGenerateBidId();
            if (this$generateBidId == null ? other$generateBidId != null : !((Object)this$generateBidId).equals(other$generateBidId)) {
                return false;
            }
            XAPI this$xapi = this.getXapi();
            XAPI other$xapi = other.getXapi();
            return !(this$xapi == null ? other$xapi != null : !((Object)this$xapi).equals(other$xapi));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof RubiconConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $generateBidId = this.getGenerateBidId();
            result = result * 59 + ($generateBidId == null ? 43 : ((Object)$generateBidId).hashCode());
            XAPI $xapi = this.getXapi();
            result = result * 59 + ($xapi == null ? 43 : ((Object)$xapi).hashCode());
            return result;
        }
    }

    private static class XAPI {
        @NotNull
        private String username;
        @NotNull
        private String password;

        @NotNull
        public String getUsername() {
            return this.username;
        }

        @NotNull
        public String getPassword() {
            return this.password;
        }

        public void setUsername(@NotNull String username) {
            this.username = username;
        }

        public void setPassword(@NotNull String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XAPI)) {
                return false;
            }
            XAPI other = (XAPI)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XAPI;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "RubiconConfiguration.XAPI(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }
}

