/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.conversant.ConversantBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/bidder-config/conversant.yaml"}, factory=YamlPropertySourceFactory.class)
public class ConversantConfiguration {
    private static final String BIDDER_NAME = "conversant";

    @Bean(value={"conversantConfigurationProperties"})
    @ConfigurationProperties(value="adapters.conversant")
    ConversantConfigurationProperties configurationProperties() {
        return new ConversantConfigurationProperties();
    }

    @Bean
    BidderDeps conversantBidderDeps(ConversantConfigurationProperties conversantConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(conversantConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new ConversantBidder(config.getEndpoint(), conversantConfigurationProperties.getGenerateBidId(), mapper)).assemble();
    }

    @Validated
    private static class ConversantConfigurationProperties
    extends BidderConfigurationProperties {
        @NotNull
        private Boolean generateBidId;

        @NotNull
        public Boolean getGenerateBidId() {
            return this.generateBidId;
        }

        public void setGenerateBidId(@NotNull Boolean generateBidId) {
            this.generateBidId = generateBidId;
        }

        @Override
        public String toString() {
            return "ConversantConfiguration.ConversantConfigurationProperties(generateBidId=" + this.getGenerateBidId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversantConfigurationProperties)) {
                return false;
            }
            ConversantConfigurationProperties other = (ConversantConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$generateBidId = this.getGenerateBidId();
            Boolean other$generateBidId = other.getGenerateBidId();
            return !(this$generateBidId == null ? other$generateBidId != null : !((Object)this$generateBidId).equals(other$generateBidId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ConversantConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $generateBidId = this.getGenerateBidId();
            result = result * 59 + ($generateBidId == null ? 43 : ((Object)$generateBidId).hashCode());
            return result;
        }
    }
}

