/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.AmpResponsePostProcessor;
import org.prebid.server.auction.ExchangeService;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.VideoResponseFactory;
import org.prebid.server.auction.gpp.CookieSyncGppService;
import org.prebid.server.auction.gpp.SetuidGppService;
import org.prebid.server.auction.requestfactory.AmpRequestFactory;
import org.prebid.server.auction.requestfactory.AuctionRequestFactory;
import org.prebid.server.auction.requestfactory.VideoRequestFactory;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.cache.CacheService;
import org.prebid.server.cookie.CookieSyncService;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.deals.UserService;
import org.prebid.server.deals.events.ApplicationEventService;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.handler.BidderParamHandler;
import org.prebid.server.handler.CookieSyncHandler;
import org.prebid.server.handler.CustomizedAdminEndpoint;
import org.prebid.server.handler.ExceptionHandler;
import org.prebid.server.handler.GetuidsHandler;
import org.prebid.server.handler.NoCacheHandler;
import org.prebid.server.handler.NotificationEventHandler;
import org.prebid.server.handler.OptoutHandler;
import org.prebid.server.handler.SetuidHandler;
import org.prebid.server.handler.StatusHandler;
import org.prebid.server.handler.VtrackHandler;
import org.prebid.server.handler.info.BidderDetailsHandler;
import org.prebid.server.handler.info.BiddersHandler;
import org.prebid.server.handler.info.filters.BaseOnlyBidderInfoFilterStrategy;
import org.prebid.server.handler.info.filters.BidderInfoFilterStrategy;
import org.prebid.server.handler.info.filters.EnabledOnlyBidderInfoFilterStrategy;
import org.prebid.server.handler.openrtb2.AmpHandler;
import org.prebid.server.handler.openrtb2.AuctionHandler;
import org.prebid.server.handler.openrtb2.VideoHandler;
import org.prebid.server.health.HealthChecker;
import org.prebid.server.health.PeriodicHealthChecker;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.HttpInteractionLogger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.optout.GoogleRecaptchaVerifier;
import org.prebid.server.privacy.HostVendorTcfDefinerService;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.validation.BidderParamValidator;
import org.prebid.server.version.PrebidVersionProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class WebConfiguration {
    @Value(value="${logging.sampling-rate:0.01}")
    private double logSamplingRate;
    @Autowired
    private Vertx vertx;

    @Bean
    HttpServerOptions httpServerOptions(@Value(value="#{'${http.max-headers-size:${server.max-headers-size:}}'}") int maxHeaderSize, @Value(value="#{'${http.max-initial-line-length:${server.max-initial-line-length:}}'}") int maxInitialLineLength, @Value(value="#{'${http.ssl:${server.ssl:}}'}") boolean ssl, @Value(value="#{'${http.jks-path:${server.jks-path:}}'}") String jksPath, @Value(value="#{'${http.jks-password:${server.jks-password:}}'}") String jksPassword, @Value(value="#{'${http.idle-timeout:${server.idle-timeout}}'}") int idleTimeout, @Value(value="${server.enable-quickack:#{null}}") Optional<Boolean> enableQuickAck, @Value(value="${server.enable-reuseport:#{null}}") Optional<Boolean> enableReusePort) {
        HttpServerOptions httpServerOptions = new HttpServerOptions().setHandle100ContinueAutomatically(true).setMaxInitialLineLength(maxInitialLineLength).setMaxHeaderSize(maxHeaderSize).setCompressionSupported(true).setDecompressionSupported(true).setIdleTimeout(idleTimeout);
        enableQuickAck.ifPresent(arg_0 -> ((HttpServerOptions)httpServerOptions).setTcpQuickAck(arg_0));
        enableReusePort.ifPresent(arg_0 -> ((HttpServerOptions)httpServerOptions).setReusePort(arg_0));
        if (ssl) {
            JksOptions jksOptions = new JksOptions().setPath(jksPath).setPassword(jksPassword);
            httpServerOptions.setSsl(true).setKeyStoreOptions(jksOptions);
        }
        return httpServerOptions;
    }

    @Bean
    ExceptionHandler exceptionHandler(Metrics metrics) {
        return ExceptionHandler.create(metrics);
    }

    @Bean(value={"router"})
    Router router(BodyHandler bodyHandler, NoCacheHandler noCacheHandler, CorsHandler corsHandler, AuctionHandler openrtbAuctionHandler, AmpHandler openrtbAmpHandler, VideoHandler openrtbVideoHandler, StatusHandler statusHandler, CookieSyncHandler cookieSyncHandler, SetuidHandler setuidHandler, GetuidsHandler getuidsHandler, VtrackHandler vtrackHandler, OptoutHandler optoutHandler, BidderParamHandler bidderParamHandler, BiddersHandler biddersHandler, BidderDetailsHandler bidderDetailsHandler, NotificationEventHandler notificationEventHandler, List<CustomizedAdminEndpoint> customizedAdminEndpoints, StaticHandler staticHandler) {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)bodyHandler);
        router.route().handler((Handler)noCacheHandler);
        router.route().handler((Handler)corsHandler);
        router.post("/openrtb2/auction").handler((Handler)openrtbAuctionHandler);
        router.get("/openrtb2/amp").handler((Handler)openrtbAmpHandler);
        router.post("/openrtb2/video").handler((Handler)openrtbVideoHandler);
        router.get("/status").handler((Handler)statusHandler);
        router.post("/cookie_sync").handler((Handler)cookieSyncHandler);
        router.get("/setuid").handler((Handler)setuidHandler);
        router.get("/getuids").handler((Handler)getuidsHandler);
        router.post("/vtrack").handler((Handler)vtrackHandler);
        router.post("/optout").handler((Handler)optoutHandler);
        router.get("/optout").handler((Handler)optoutHandler);
        router.get("/bidders/params").handler((Handler)bidderParamHandler);
        router.get("/info/bidders").handler((Handler)biddersHandler);
        router.get("/info/bidders/:bidderName").handler((Handler)bidderDetailsHandler);
        router.get("/event").handler((Handler)notificationEventHandler);
        customizedAdminEndpoints.stream().filter(CustomizedAdminEndpoint::isOnApplicationPort).forEach(customizedAdminEndpoint -> customizedAdminEndpoint.router(router));
        router.get("/static/*").handler((Handler)staticHandler);
        router.get("/").handler((Handler)staticHandler);
        return router;
    }

    @Bean
    NoCacheHandler noCacheHandler() {
        return NoCacheHandler.create();
    }

    @Bean
    CorsHandler corsHandler() {
        return CorsHandler.create((String)".*").allowCredentials(true).allowedHeaders(new HashSet<String>(Arrays.asList(HttpUtil.ORIGIN_HEADER.toString(), HttpUtil.ACCEPT_HEADER.toString(), HttpUtil.CONTENT_TYPE_HEADER.toString(), HttpUtil.X_REQUESTED_WITH_HEADER.toString()))).allowedMethods(new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.POST, HttpMethod.HEAD, HttpMethod.OPTIONS)));
    }

    @Bean
    AuctionHandler openrtbAuctionHandler(ExchangeService exchangeService, AuctionRequestFactory auctionRequestFactory, AnalyticsReporterDelegator analyticsReporter, Metrics metrics, Clock clock, HttpInteractionLogger httpInteractionLogger, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        return new AuctionHandler(this.logSamplingRate, auctionRequestFactory, exchangeService, analyticsReporter, metrics, clock, httpInteractionLogger, prebidVersionProvider, mapper);
    }

    @Bean
    AmpHandler openrtbAmpHandler(AmpRequestFactory ampRequestFactory, ExchangeService exchangeService, AnalyticsReporterDelegator analyticsReporter, Metrics metrics, Clock clock, BidderCatalog bidderCatalog, AmpProperties ampProperties, AmpResponsePostProcessor ampResponsePostProcessor, HttpInteractionLogger httpInteractionLogger, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        return new AmpHandler(ampRequestFactory, exchangeService, analyticsReporter, metrics, clock, bidderCatalog, ampProperties.getCustomTargetingSet(), ampResponsePostProcessor, httpInteractionLogger, prebidVersionProvider, mapper, this.logSamplingRate);
    }

    @Bean
    VideoHandler openrtbVideoHandler(VideoRequestFactory videoRequestFactory, VideoResponseFactory videoResponseFactory, ExchangeService exchangeService, CacheService cacheService, AnalyticsReporterDelegator analyticsReporter, Metrics metrics, Clock clock, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        return new VideoHandler(videoRequestFactory, videoResponseFactory, exchangeService, cacheService, analyticsReporter, metrics, clock, prebidVersionProvider, mapper);
    }

    @Bean
    StatusHandler statusHandler(List<HealthChecker> healthCheckers, JacksonMapper mapper) {
        healthCheckers.stream().filter(PeriodicHealthChecker.class::isInstance).map(PeriodicHealthChecker.class::cast).forEach(PeriodicHealthChecker::initialize);
        return new StatusHandler(healthCheckers, mapper);
    }

    @Bean
    CookieSyncHandler cookieSyncHandler(@Value(value="${cookie-sync.default-timeout-ms}") int defaultTimeoutMs, UidsCookieService uidsCookieService, CookieSyncGppService cookieSyncGppProcessor, ActivityInfrastructureCreator activityInfrastructureCreator, ApplicationSettings applicationSettings, CookieSyncService cookieSyncService, PrivacyEnforcementService privacyEnforcementService, AnalyticsReporterDelegator analyticsReporterDelegator, Metrics metrics, TimeoutFactory timeoutFactory, JacksonMapper mapper) {
        return new CookieSyncHandler(defaultTimeoutMs, this.logSamplingRate, uidsCookieService, cookieSyncGppProcessor, activityInfrastructureCreator, cookieSyncService, applicationSettings, privacyEnforcementService, analyticsReporterDelegator, metrics, timeoutFactory, mapper);
    }

    @Bean
    SetuidHandler setuidHandler(@Value(value="${setuid.default-timeout-ms}") int defaultTimeoutMs, UidsCookieService uidsCookieService, ApplicationSettings applicationSettings, BidderCatalog bidderCatalog, PrivacyEnforcementService privacyEnforcementService, SetuidGppService setuidGppService, ActivityInfrastructureCreator activityInfrastructureCreator, HostVendorTcfDefinerService tcfDefinerService, AnalyticsReporterDelegator analyticsReporter, Metrics metrics, TimeoutFactory timeoutFactory) {
        return new SetuidHandler(defaultTimeoutMs, uidsCookieService, applicationSettings, bidderCatalog, privacyEnforcementService, setuidGppService, activityInfrastructureCreator, tcfDefinerService, analyticsReporter, metrics, timeoutFactory);
    }

    @Bean
    GetuidsHandler getuidsHandler(UidsCookieService uidsCookieService, JacksonMapper mapper) {
        return new GetuidsHandler(uidsCookieService, mapper);
    }

    @Bean
    VtrackHandler vtrackHandler(@Value(value="${vtrack.default-timeout-ms}") int defaultTimeoutMs, @Value(value="${vtrack.allow-unknown-bidder}") boolean allowUnknownBidder, @Value(value="${vtrack.modify-vast-for-unknown-bidder}") boolean modifyVastForUnknownBidder, ApplicationSettings applicationSettings, BidderCatalog bidderCatalog, CacheService cacheService, TimeoutFactory timeoutFactory, JacksonMapper mapper) {
        return new VtrackHandler(defaultTimeoutMs, allowUnknownBidder, modifyVastForUnknownBidder, applicationSettings, bidderCatalog, cacheService, timeoutFactory, mapper);
    }

    @Bean
    OptoutHandler optoutHandler(@Value(value="${external-url}") String externalUrl, @Value(value="${host-cookie.opt-out-url}") String optoutUrl, @Value(value="${host-cookie.opt-in-url}") String optinUrl, GoogleRecaptchaVerifier googleRecaptchaVerifier, UidsCookieService uidsCookieService) {
        return new OptoutHandler(googleRecaptchaVerifier, uidsCookieService, OptoutHandler.getOptoutRedirectUrl(externalUrl), HttpUtil.validateUrl(optoutUrl), HttpUtil.validateUrl(optinUrl));
    }

    @Bean
    BidderParamHandler bidderParamHandler(BidderParamValidator bidderParamValidator) {
        return new BidderParamHandler(bidderParamValidator);
    }

    @Bean
    BidderInfoFilterStrategy enabledOnlyBidderInfoFilterStrategy(BidderCatalog bidderCatalog) {
        return new EnabledOnlyBidderInfoFilterStrategy(bidderCatalog);
    }

    @Bean
    BidderInfoFilterStrategy baseOnlyBidderInfoFilterStrategy(BidderCatalog bidderCatalog) {
        return new BaseOnlyBidderInfoFilterStrategy(bidderCatalog);
    }

    @Bean
    BiddersHandler biddersHandler(BidderCatalog bidderCatalog, List<BidderInfoFilterStrategy> filterStrategies, JacksonMapper mapper) {
        return new BiddersHandler(bidderCatalog, filterStrategies, mapper);
    }

    @Bean
    BidderDetailsHandler bidderDetailsHandler(BidderCatalog bidderCatalog, JacksonMapper mapper) {
        return new BidderDetailsHandler(bidderCatalog, mapper);
    }

    @Bean
    NotificationEventHandler notificationEventHandler(UidsCookieService uidsCookieService, @Autowired(required=false) ApplicationEventService applicationEventService, @Autowired(required=false) UserService userService, ActivityInfrastructureCreator activityInfrastructureCreator, AnalyticsReporterDelegator analyticsReporterDelegator, TimeoutFactory timeoutFactory, ApplicationSettings applicationSettings, @Value(value="${event.default-timeout-ms}") long defaultTimeoutMillis, @Value(value="${deals.enabled}") boolean dealsEnabled) {
        return new NotificationEventHandler(uidsCookieService, applicationEventService, userService, activityInfrastructureCreator, analyticsReporterDelegator, timeoutFactory, applicationSettings, defaultTimeoutMillis, dealsEnabled);
    }

    @Bean
    StaticHandler staticHandler() {
        return StaticHandler.create((String)"static").setCachingEnabled(false);
    }

    @Component
    @ConfigurationProperties(prefix="amp")
    private static class AmpProperties {
        private List<String> customTargeting = new ArrayList<String>();

        Set<String> getCustomTargetingSet() {
            return new HashSet<String>(this.customTargeting);
        }

        public List<String> getCustomTargeting() {
            return this.customTargeting;
        }

        public void setCustomTargeting(List<String> customTargeting) {
            this.customTargeting = customTargeting;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmpProperties)) {
                return false;
            }
            AmpProperties other = (AmpProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$customTargeting = this.getCustomTargeting();
            List<String> other$customTargeting = other.getCustomTargeting();
            return !(this$customTargeting == null ? other$customTargeting != null : !((Object)this$customTargeting).equals(other$customTargeting));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AmpProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $customTargeting = this.getCustomTargeting();
            result = result * 59 + ($customTargeting == null ? 43 : ((Object)$customTargeting).hashCode());
            return result;
        }

        public String toString() {
            return "WebConfiguration.AmpProperties(customTargeting=" + this.getCustomTargeting() + ")";
        }
    }
}

