/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.prebid.server.execution.RemoteFileSyncer;
import org.prebid.server.execution.retry.FixedIntervalRetryPolicy;
import org.prebid.server.geolocation.CircuitBreakerSecuredGeoLocationService;
import org.prebid.server.geolocation.ConfigurationGeoLocationService;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.geolocation.MaxMindGeoLocationService;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.geolocation.model.GeoInfoConfiguration;
import org.prebid.server.metric.Metrics;
import org.prebid.server.spring.config.model.CircuitBreakerProperties;
import org.prebid.server.spring.config.model.HttpClientProperties;
import org.prebid.server.spring.config.model.RemoteFileSyncerProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class GeoLocationConfiguration {

    @Configuration
    static class CountryCodeMapperConfiguration {
        CountryCodeMapperConfiguration() {
        }

        @Bean
        public CountryCodeMapper countryCodeMapper(@Value(value="classpath:country-codes.csv") Resource countryCodes, @Value(value="classpath:mcc-country-codes.csv") Resource mccCountryCodes) throws IOException {
            return new CountryCodeMapper(this.readCsv(countryCodes), this.readCsv(mccCountryCodes));
        }

        private String readCsv(Resource resource) throws IOException {
            InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
            String csv = FileCopyUtils.copyToString((Reader)reader);
            ((Reader)reader).close();
            return csv;
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${geolocation.enabled} == true and '${geolocation.type}' == 'configuration'")
    static class ConfigurationGeoLocationConfiguration {
        ConfigurationGeoLocationConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="geolocation.configurations")
        public List<GeoInfoConfiguration> configurations() {
            return new ArrayList<GeoInfoConfiguration>();
        }

        @Bean
        public GeoLocationService configurationGeoLocationService(List<GeoInfoConfiguration> configs) {
            return new ConfigurationGeoLocationService(configs.stream().filter(config -> config != null && config.getAddressPattern() != null).map(ConfigurationGeoLocationConfiguration::from).toList());
        }

        private static org.prebid.server.geolocation.model.GeoInfoConfiguration from(GeoInfoConfiguration config) {
            GeoInfo geoInfo = config.getGeoInfo();
            return org.prebid.server.geolocation.model.GeoInfoConfiguration.of(config.getAddressPattern(), geoInfo != null ? org.prebid.server.geolocation.model.GeoInfo.builder().vendor("").continent(geoInfo.getContinent()).country(geoInfo.getCountry()).region(geoInfo.getRegion()).city(geoInfo.getCity()).metroGoogle(geoInfo.getMetroGoogle()).metroNielsen(geoInfo.getMetroNielsen()).zip(geoInfo.getZip()).connectionSpeed(geoInfo.getConnectionSpeed()).lat(geoInfo.getLat()).lon(geoInfo.getLon()).timeZone(geoInfo.getTimeZone()).build() : null);
        }

        static class GeoInfoConfiguration {
            String addressPattern;
            GeoInfo geoInfo;

            public String getAddressPattern() {
                return this.addressPattern;
            }

            public GeoInfo getGeoInfo() {
                return this.geoInfo;
            }

            public void setAddressPattern(String addressPattern) {
                this.addressPattern = addressPattern;
            }

            public void setGeoInfo(GeoInfo geoInfo) {
                this.geoInfo = geoInfo;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GeoInfoConfiguration)) {
                    return false;
                }
                GeoInfoConfiguration other = (GeoInfoConfiguration)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$addressPattern = this.getAddressPattern();
                String other$addressPattern = other.getAddressPattern();
                if (this$addressPattern == null ? other$addressPattern != null : !this$addressPattern.equals(other$addressPattern)) {
                    return false;
                }
                GeoInfo this$geoInfo = this.getGeoInfo();
                GeoInfo other$geoInfo = other.getGeoInfo();
                return !(this$geoInfo == null ? other$geoInfo != null : !((Object)this$geoInfo).equals(other$geoInfo));
            }

            protected boolean canEqual(Object other) {
                return other instanceof GeoInfoConfiguration;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $addressPattern = this.getAddressPattern();
                result = result * 59 + ($addressPattern == null ? 43 : $addressPattern.hashCode());
                GeoInfo $geoInfo = this.getGeoInfo();
                result = result * 59 + ($geoInfo == null ? 43 : ((Object)$geoInfo).hashCode());
                return result;
            }

            public String toString() {
                return "GeoLocationConfiguration.ConfigurationGeoLocationConfiguration.GeoInfoConfiguration(addressPattern=" + this.getAddressPattern() + ", geoInfo=" + this.getGeoInfo() + ")";
            }
        }

        static class GeoInfo {
            String continent;
            String country;
            String region;
            Integer regionCode;
            String city;
            String metroGoogle;
            Integer metroNielsen;
            String zip;
            String connectionSpeed;
            Float lat;
            Float lon;
            ZoneId timeZone;

            public String getContinent() {
                return this.continent;
            }

            public String getCountry() {
                return this.country;
            }

            public String getRegion() {
                return this.region;
            }

            public Integer getRegionCode() {
                return this.regionCode;
            }

            public String getCity() {
                return this.city;
            }

            public String getMetroGoogle() {
                return this.metroGoogle;
            }

            public Integer getMetroNielsen() {
                return this.metroNielsen;
            }

            public String getZip() {
                return this.zip;
            }

            public String getConnectionSpeed() {
                return this.connectionSpeed;
            }

            public Float getLat() {
                return this.lat;
            }

            public Float getLon() {
                return this.lon;
            }

            public ZoneId getTimeZone() {
                return this.timeZone;
            }

            public void setContinent(String continent) {
                this.continent = continent;
            }

            public void setCountry(String country) {
                this.country = country;
            }

            public void setRegion(String region) {
                this.region = region;
            }

            public void setRegionCode(Integer regionCode) {
                this.regionCode = regionCode;
            }

            public void setCity(String city) {
                this.city = city;
            }

            public void setMetroGoogle(String metroGoogle) {
                this.metroGoogle = metroGoogle;
            }

            public void setMetroNielsen(Integer metroNielsen) {
                this.metroNielsen = metroNielsen;
            }

            public void setZip(String zip) {
                this.zip = zip;
            }

            public void setConnectionSpeed(String connectionSpeed) {
                this.connectionSpeed = connectionSpeed;
            }

            public void setLat(Float lat) {
                this.lat = lat;
            }

            public void setLon(Float lon) {
                this.lon = lon;
            }

            public void setTimeZone(ZoneId timeZone) {
                this.timeZone = timeZone;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GeoInfo)) {
                    return false;
                }
                GeoInfo other = (GeoInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$regionCode = this.getRegionCode();
                Integer other$regionCode = other.getRegionCode();
                if (this$regionCode == null ? other$regionCode != null : !((Object)this$regionCode).equals(other$regionCode)) {
                    return false;
                }
                Integer this$metroNielsen = this.getMetroNielsen();
                Integer other$metroNielsen = other.getMetroNielsen();
                if (this$metroNielsen == null ? other$metroNielsen != null : !((Object)this$metroNielsen).equals(other$metroNielsen)) {
                    return false;
                }
                Float this$lat = this.getLat();
                Float other$lat = other.getLat();
                if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
                    return false;
                }
                Float this$lon = this.getLon();
                Float other$lon = other.getLon();
                if (this$lon == null ? other$lon != null : !((Object)this$lon).equals(other$lon)) {
                    return false;
                }
                String this$continent = this.getContinent();
                String other$continent = other.getContinent();
                if (this$continent == null ? other$continent != null : !this$continent.equals(other$continent)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$region = this.getRegion();
                String other$region = other.getRegion();
                if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$metroGoogle = this.getMetroGoogle();
                String other$metroGoogle = other.getMetroGoogle();
                if (this$metroGoogle == null ? other$metroGoogle != null : !this$metroGoogle.equals(other$metroGoogle)) {
                    return false;
                }
                String this$zip = this.getZip();
                String other$zip = other.getZip();
                if (this$zip == null ? other$zip != null : !this$zip.equals(other$zip)) {
                    return false;
                }
                String this$connectionSpeed = this.getConnectionSpeed();
                String other$connectionSpeed = other.getConnectionSpeed();
                if (this$connectionSpeed == null ? other$connectionSpeed != null : !this$connectionSpeed.equals(other$connectionSpeed)) {
                    return false;
                }
                ZoneId this$timeZone = this.getTimeZone();
                ZoneId other$timeZone = other.getTimeZone();
                return !(this$timeZone == null ? other$timeZone != null : !((Object)this$timeZone).equals(other$timeZone));
            }

            protected boolean canEqual(Object other) {
                return other instanceof GeoInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $regionCode = this.getRegionCode();
                result = result * 59 + ($regionCode == null ? 43 : ((Object)$regionCode).hashCode());
                Integer $metroNielsen = this.getMetroNielsen();
                result = result * 59 + ($metroNielsen == null ? 43 : ((Object)$metroNielsen).hashCode());
                Float $lat = this.getLat();
                result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
                Float $lon = this.getLon();
                result = result * 59 + ($lon == null ? 43 : ((Object)$lon).hashCode());
                String $continent = this.getContinent();
                result = result * 59 + ($continent == null ? 43 : $continent.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $region = this.getRegion();
                result = result * 59 + ($region == null ? 43 : $region.hashCode());
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $metroGoogle = this.getMetroGoogle();
                result = result * 59 + ($metroGoogle == null ? 43 : $metroGoogle.hashCode());
                String $zip = this.getZip();
                result = result * 59 + ($zip == null ? 43 : $zip.hashCode());
                String $connectionSpeed = this.getConnectionSpeed();
                result = result * 59 + ($connectionSpeed == null ? 43 : $connectionSpeed.hashCode());
                ZoneId $timeZone = this.getTimeZone();
                result = result * 59 + ($timeZone == null ? 43 : ((Object)$timeZone).hashCode());
                return result;
            }

            public String toString() {
                return "GeoLocationConfiguration.ConfigurationGeoLocationConfiguration.GeoInfo(continent=" + this.getContinent() + ", country=" + this.getCountry() + ", region=" + this.getRegion() + ", regionCode=" + this.getRegionCode() + ", city=" + this.getCity() + ", metroGoogle=" + this.getMetroGoogle() + ", metroNielsen=" + this.getMetroNielsen() + ", zip=" + this.getZip() + ", connectionSpeed=" + this.getConnectionSpeed() + ", lat=" + this.getLat() + ", lon=" + this.getLon() + ", timeZone=" + this.getTimeZone() + ")";
            }
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${geolocation.enabled} == true and '${geolocation.type}' == 'maxmind'")
    static class MaxMindGeoLocationConfiguration {
        MaxMindGeoLocationConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="geolocation.circuit-breaker", name={"enabled"}, havingValue="true")
        @ConfigurationProperties(prefix="geolocation.circuit-breaker")
        CircuitBreakerProperties maxMindCircuitBreakerProperties() {
            return new CircuitBreakerProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="geolocation.maxmind.remote-file-syncer")
        RemoteFileSyncerProperties maxMindRemoteFileSyncerProperties() {
            return new RemoteFileSyncerProperties();
        }

        @Bean
        @ConditionalOnProperty(prefix="geolocation.circuit-breaker", name={"enabled"}, havingValue="false", matchIfMissing=true)
        GeoLocationService basicGeoLocationService(RemoteFileSyncerProperties fileSyncerProperties, Vertx vertx) {
            return this.createGeoLocationService(fileSyncerProperties, vertx);
        }

        @Bean
        @ConditionalOnProperty(prefix="geolocation.circuit-breaker", name={"enabled"}, havingValue="true")
        CircuitBreakerSecuredGeoLocationService circuitBreakerSecuredGeoLocationService(Vertx vertx, Metrics metrics, RemoteFileSyncerProperties fileSyncerProperties, @Qualifier(value="maxMindCircuitBreakerProperties") CircuitBreakerProperties circuitBreakerProperties, Clock clock) {
            return new CircuitBreakerSecuredGeoLocationService(vertx, this.createGeoLocationService(fileSyncerProperties, vertx), metrics, circuitBreakerProperties.getOpeningThreshold(), circuitBreakerProperties.getOpeningIntervalMs(), circuitBreakerProperties.getClosingIntervalMs(), clock);
        }

        private GeoLocationService createGeoLocationService(RemoteFileSyncerProperties properties, Vertx vertx) {
            HttpClientProperties httpClientProperties = properties.getHttpClient();
            HttpClientOptions httpClientOptions = new HttpClientOptions().setConnectTimeout(httpClientProperties.getConnectTimeoutMs().intValue()).setMaxRedirects(httpClientProperties.getMaxRedirects().intValue());
            RemoteFileSyncer remoteFileSyncer = new RemoteFileSyncer(properties.getDownloadUrl(), properties.getSaveFilepath(), properties.getTmpFilepath(), FixedIntervalRetryPolicy.limited(properties.getRetryIntervalMs(), properties.getRetryCount()), properties.getTimeoutMs(), properties.getUpdateIntervalMs(), vertx.createHttpClient(httpClientOptions), vertx);
            MaxMindGeoLocationService maxMindGeoLocationService = new MaxMindGeoLocationService();
            remoteFileSyncer.sync(maxMindGeoLocationService);
            return maxMindGeoLocationService;
        }
    }
}

