/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.DeliveryStatsService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.PlannerService;
import org.prebid.server.deals.RegisterService;
import org.prebid.server.deals.simulation.DealsSimulationAdminHandler;
import org.prebid.server.handler.AccountCacheInvalidationHandler;
import org.prebid.server.handler.CollectedMetricsHandler;
import org.prebid.server.handler.CurrencyRatesHandler;
import org.prebid.server.handler.CustomizedAdminEndpoint;
import org.prebid.server.handler.DealsStatusHandler;
import org.prebid.server.handler.ForceDealsUpdateHandler;
import org.prebid.server.handler.HttpInteractionLogHandler;
import org.prebid.server.handler.LineItemStatusHandler;
import org.prebid.server.handler.LoggerControlKnobHandler;
import org.prebid.server.handler.SettingsCacheNotificationHandler;
import org.prebid.server.handler.TracerLogHandler;
import org.prebid.server.handler.VersionHandler;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.CriteriaManager;
import org.prebid.server.log.HttpInteractionLogger;
import org.prebid.server.log.LoggerControlKnob;
import org.prebid.server.settings.CachingApplicationSettings;
import org.prebid.server.settings.SettingsCache;
import org.prebid.server.util.VersionInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class AdminEndpointsConfiguration {
    @Bean
    @ConditionalOnExpression(value="${admin-endpoints.version.enabled} == true")
    CustomizedAdminEndpoint versionEndpoint(VersionInfo versionInfo, JacksonMapper mapper, @Value(value="${admin-endpoints.version.path}") String path, @Value(value="${admin-endpoints.version.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.version.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new VersionHandler(versionInfo.getVersion(), versionInfo.getCommitHash(), mapper, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${currency-converter.external-rates.enabled} == true and ${admin-endpoints.currency-rates.enabled} == true")
    CustomizedAdminEndpoint currencyConversionRatesEndpoint(CurrencyConversionService currencyConversionRates, JacksonMapper mapper, @Value(value="${admin-endpoints.currency-rates.path}") String path, @Value(value="${admin-endpoints.currency-rates.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.currency-rates.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new CurrencyRatesHandler(currencyConversionRates, path, mapper), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${settings.in-memory-cache.notification-endpoints-enabled:false} and ${admin-endpoints.storedrequest.enabled} == true")
    CustomizedAdminEndpoint cacheNotificationEndpoint(SettingsCache settingsCache, JacksonMapper mapper, @Value(value="${admin-endpoints.storedrequest.path}") String path, @Value(value="${admin-endpoints.storedrequest.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.storedrequest.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new SettingsCacheNotificationHandler(settingsCache, mapper, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${settings.in-memory-cache.notification-endpoints-enabled:false} and ${admin-endpoints.storedrequest-amp.enabled} == true")
    CustomizedAdminEndpoint ampCacheNotificationEndpoint(SettingsCache ampSettingsCache, JacksonMapper mapper, @Value(value="${admin-endpoints.storedrequest-amp.path}") String path, @Value(value="${admin-endpoints.storedrequest-amp.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.storedrequest-amp.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new SettingsCacheNotificationHandler(ampSettingsCache, mapper, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${settings.in-memory-cache.notification-endpoints-enabled:false} and ${admin-endpoints.cache-invalidation.enabled} == true")
    CustomizedAdminEndpoint cacheInvalidateNotificationEndpoint(CachingApplicationSettings cachingApplicationSettings, @Value(value="${admin-endpoints.cache-invalidation.path}") String path, @Value(value="${admin-endpoints.cache-invalidation.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.cache-invalidation.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new AccountCacheInvalidationHandler(cachingApplicationSettings, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${admin-endpoints.logging-httpinteraction.enabled} == true")
    CustomizedAdminEndpoint loggingHttpInteractionEndpoint(@Value(value="${logging.http-interaction.max-limit}") int maxLimit, HttpInteractionLogger httpInteractionLogger, @Value(value="${admin-endpoints.logging-httpinteraction.path}") String path, @Value(value="${admin-endpoints.logging-httpinteraction.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.logging-httpinteraction.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new HttpInteractionLogHandler(maxLimit, httpInteractionLogger, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${admin-endpoints.logging-changelevel.enabled} == true")
    CustomizedAdminEndpoint loggingChangeLevelEndpoint(@Value(value="${logging.change-level.max-duration-ms}") long maxDuration, LoggerControlKnob loggerControlKnob, @Value(value="${admin-endpoints.logging-changelevel.path}") String path, @Value(value="${admin-endpoints.logging-changelevel.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.logging-changelevel.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new LoggerControlKnobHandler(maxDuration, loggerControlKnob, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnProperty(prefix="admin-endpoints.tracelog", name={"enabled"}, havingValue="true")
    CustomizedAdminEndpoint tracerLogEndpoint(CriteriaManager criteriaManager, @Value(value="${admin-endpoints.tracelog.path}") String path, @Value(value="${admin-endpoints.tracelog.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.tracelog.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new TracerLogHandler(criteriaManager), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${deals.enabled} == true and ${admin-endpoints.deals-status.enabled} == true")
    CustomizedAdminEndpoint dealsStatusEndpoint(DeliveryProgressService deliveryProgressService, JacksonMapper mapper, @Value(value="${admin-endpoints.deals-status.path}") String path, @Value(value="${admin-endpoints.deals-status.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.deals-status.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new DealsStatusHandler(deliveryProgressService, mapper), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${deals.enabled} == true and ${admin-endpoints.lineitem-status.enabled} == true")
    CustomizedAdminEndpoint lineItemStatusEndpoint(DeliveryProgressService deliveryProgressService, JacksonMapper mapper, @Value(value="${admin-endpoints.lineitem-status.path}") String path, @Value(value="${admin-endpoints.lineitem-status.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.lineitem-status.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new LineItemStatusHandler(deliveryProgressService, mapper, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${deals.enabled} == true and ${admin-endpoints.force-deals-update.enabled} == true")
    CustomizedAdminEndpoint forceDealsUpdateEndpoint(DeliveryStatsService deliveryStatsService, PlannerService plannerService, RegisterService registerService, AlertHttpService alertHttpService, DeliveryProgressService deliveryProgressService, LineItemService lineItemService, @Value(value="${admin-endpoints.force-deals-update.path}") String path, @Value(value="${admin-endpoints.force-deals-update.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.force-deals-update.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new ForceDealsUpdateHandler(deliveryStatsService, plannerService, registerService, alertHttpService, deliveryProgressService, lineItemService, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${deals.enabled} == true and ${deals.simulation.enabled} == true and ${admin-endpoints.e2eadmin.enabled} == true")
    CustomizedAdminEndpoint dealsSimulationAdminEndpoint(DealsSimulationAdminHandler dealsSimulationAdminHandler, @Value(value="${admin-endpoints.e2eadmin.path}") String path, @Value(value="${admin-endpoints.e2eadmin.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.e2eadmin.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, dealsSimulationAdminHandler, isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    @ConditionalOnExpression(value="${admin-endpoints.collected-metrics.enabled} == true")
    CustomizedAdminEndpoint collectedMetricsAdminEndpoint(MetricRegistry metricRegistry, JacksonMapper mapper, @Value(value="${admin-endpoints.collected-metrics.path}") String path, @Value(value="${admin-endpoints.collected-metrics.on-application-port}") boolean isOnApplicationPort, @Value(value="${admin-endpoints.collected-metrics.protected}") boolean isProtected, @Autowired(required=false) Map<String, String> adminEndpointCredentials) {
        return new CustomizedAdminEndpoint(path, new CollectedMetricsHandler(metricRegistry, mapper, path), isOnApplicationPort, isProtected).withCredentials(adminEndpointCredentials);
    }

    @Bean
    Map<String, String> adminEndpointCredentials(@Autowired(required=false) AdminEndpointCredentials adminEndpointCredentials) {
        return (Map)ObjectUtils.defaultIfNull(adminEndpointCredentials.getCredentials(), Collections.emptyMap());
    }

    @Component
    @ConfigurationProperties(prefix="admin-endpoints")
    public static class AdminEndpointCredentials {
        private Map<String, String> credentials;

        public Map<String, String> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Map<String, String> credentials) {
            this.credentials = credentials;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdminEndpointCredentials)) {
                return false;
            }
            AdminEndpointCredentials other = (AdminEndpointCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$credentials = this.getCredentials();
            Map<String, String> other$credentials = other.getCredentials();
            return !(this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdminEndpointCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
            return result;
        }

        public String toString() {
            return "AdminEndpointsConfiguration.AdminEndpointCredentials(credentials=" + this.getCredentials() + ")";
        }
    }
}

