/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.Category;
import org.prebid.server.settings.model.SettingsFile;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredDataType;
import org.prebid.server.settings.model.StoredResponseDataResult;

public class FileApplicationSettings
implements ApplicationSettings {
    private static final TypeReference<Map<String, Category>> CATEGORY_FORMAT_REFERENCE = new TypeReference<Map<String, Category>>(){};
    private static final String JSON_SUFFIX = ".json";
    private final Map<String, Account> accounts;
    private final Map<String, String> storedIdToRequest;
    private final Map<String, String> storedIdToImp;
    private final Map<String, String> storedIdToSeatBid;
    private final Map<String, Map<String, Category>> fileToCategories;

    public FileApplicationSettings(FileSystem fileSystem, String settingsFileName, String storedRequestsDir, String storedImpsDir, String storedResponsesDir, String categoriesDir, JacksonMapper jacksonMapper) {
        SettingsFile settingsFile = FileApplicationSettings.readSettingsFile(Objects.requireNonNull(fileSystem), Objects.requireNonNull(settingsFileName));
        this.accounts = FileApplicationSettings.toMap(settingsFile.getAccounts(), Account::getId, Function.identity());
        this.storedIdToRequest = FileApplicationSettings.readStoredData(fileSystem, Objects.requireNonNull(storedRequestsDir));
        this.storedIdToImp = FileApplicationSettings.readStoredData(fileSystem, Objects.requireNonNull(storedImpsDir));
        this.storedIdToSeatBid = FileApplicationSettings.readStoredData(fileSystem, Objects.requireNonNull(storedResponsesDir));
        this.fileToCategories = FileApplicationSettings.readCategories(fileSystem, Objects.requireNonNull(categoriesDir), jacksonMapper);
    }

    @Override
    public Future<Account> getAccountById(String accountId, Timeout timeout) {
        return FileApplicationSettings.mapValueToFuture(this.accounts, accountId, "Account");
    }

    @Override
    public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return Future.succeededFuture((Object)(CollectionUtils.isEmpty(requestIds) && CollectionUtils.isEmpty(impIds) ? StoredDataResult.of(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList()) : StoredDataResult.of(FileApplicationSettings.existingStoredIdToJson(requestIds, this.storedIdToRequest), FileApplicationSettings.existingStoredIdToJson(impIds, this.storedIdToImp), Stream.of(FileApplicationSettings.errorsForMissedIds(requestIds, this.storedIdToRequest, StoredDataType.request), FileApplicationSettings.errorsForMissedIds(impIds, this.storedIdToImp, StoredDataType.imp)).flatMap(Collection::stream).toList())));
    }

    @Override
    public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.getStoredData(accountId, requestIds, Collections.emptySet(), timeout);
    }

    @Override
    public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.getStoredData(accountId, requestIds, impIds, timeout);
    }

    @Override
    public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
        String filename = StringUtils.isNotBlank((CharSequence)publisher) ? "%s_%s".formatted(primaryAdServer, publisher) : primaryAdServer;
        Map<String, Category> categoryToId = this.fileToCategories.get(filename);
        return categoryToId != null ? Future.succeededFuture(FileApplicationSettings.extractCategoriesIds(categoryToId)) : Future.failedFuture((Throwable)new PreBidException("Categories for filename %s were not found".formatted(filename)));
    }

    private static Map<String, String> extractCategoriesIds(Map<String, Category> categoryToId) {
        return categoryToId.entrySet().stream().filter(catToCategory -> catToCategory.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, catToCategory -> ((Category)catToCategory.getValue()).getId()));
    }

    @Override
    public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
        return Future.succeededFuture((Object)(CollectionUtils.isEmpty(responseIds) ? StoredResponseDataResult.of(Collections.emptyMap(), Collections.emptyList()) : StoredResponseDataResult.of(FileApplicationSettings.existingStoredIdToJson(responseIds, this.storedIdToSeatBid), FileApplicationSettings.errorsForMissedIds(responseIds, this.storedIdToSeatBid, StoredDataType.seatbid))));
    }

    private static <T, K, U> Map<K, U> toMap(List<T> list, Function<T, K> keyMapper, Function<T, U> valueMapper) {
        return list != null ? list.stream().collect(Collectors.toMap(keyMapper, valueMapper)) : Collections.emptyMap();
    }

    private static SettingsFile readSettingsFile(FileSystem fileSystem, String fileName) {
        Buffer buf = fileSystem.readFileBlocking(fileName);
        try {
            return (SettingsFile)new YAMLMapper().readValue(buf.getBytes(), SettingsFile.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't read file settings", e);
        }
    }

    private static Map<String, String> readStoredData(FileSystem fileSystem, String dir) {
        return fileSystem.readDirBlocking(dir).stream().filter(filepath -> filepath.endsWith(JSON_SUFFIX)).collect(Collectors.toMap(filepath -> StringUtils.removeEnd((String)new File((String)filepath).getName(), (String)JSON_SUFFIX), filename -> fileSystem.readFileBlocking(filename).toString()));
    }

    private static Map<String, Map<String, Category>> readCategories(FileSystem fileSystem, String dir, JacksonMapper jacksonMapper) {
        return fileSystem.readDirBlocking(dir).stream().filter(filepath -> filepath.endsWith(JSON_SUFFIX)).collect(Collectors.toMap(filepath -> StringUtils.removeEnd((String)new File((String)filepath).getName(), (String)JSON_SUFFIX), filename -> FileApplicationSettings.parseCategories(filename, fileSystem.readFileBlocking(filename), jacksonMapper)));
    }

    private static Map<String, Category> parseCategories(String fileName, Buffer categoriesBuffer, JacksonMapper jacksonMapper) {
        try {
            return jacksonMapper.decodeValue(categoriesBuffer, CATEGORY_FORMAT_REFERENCE);
        }
        catch (DecodeException e) {
            throw new PreBidException("Failed to decode categories for file " + fileName);
        }
    }

    private static <T> Future<T> mapValueToFuture(Map<String, T> map, String id, String errorPrefix) {
        T value = map.get(id);
        return value != null ? Future.succeededFuture(value) : Future.failedFuture((Throwable)new PreBidException("%s not found: %s".formatted(errorPrefix, id)));
    }

    private static Map<String, String> existingStoredIdToJson(Set<String> requestedIds, Map<String, String> storedIdToJson) {
        return requestedIds.stream().filter(storedIdToJson::containsKey).collect(Collectors.toMap(Function.identity(), storedIdToJson::get));
    }

    private static List<String> errorsForMissedIds(Set<String> ids, Map<String, String> storedIdToJson, StoredDataType type) {
        List<String> missedIds = ids.stream().filter(id -> !storedIdToJson.containsKey(id)).toList();
        return missedIds.isEmpty() ? Collections.emptyList() : missedIds.stream().map(id -> "No stored %s found for id: %s".formatted(new Object[]{type, id})).toList();
    }
}

