/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.protobuf.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.Message;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Asset;
import com.iab.openrtb.request.Audio;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Content;
import com.iab.openrtb.request.Data;
import com.iab.openrtb.request.DataObject;
import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.EventTracker;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.ImageObject;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Metric;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.request.Pmp;
import com.iab.openrtb.request.Producer;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Request;
import com.iab.openrtb.request.Segment;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.TitleObject;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.request.VideoObject;
import com.iabtechlab.openrtb.v2.OpenRtb;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtGeo;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisher;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.protobuf.ProtobufMapper;
import org.prebid.server.protobuf.request.JsonProtobufExtensionMapper;
import org.prebid.server.protobuf.request.ProtobufForwardExtensionMapper;
import org.prebid.server.protobuf.request.RequestExtensionMappersSpecification;

public class ProtobufRequestUtils {
    private ProtobufRequestUtils() {
    }

    public static ProtobufMapper<BidRequest, OpenRtb.BidRequest> bidRequestMapper(RequestExtensionMappersSpecification spec) {
        ProtobufMapper<Banner, OpenRtb.BidRequest.Imp.Banner> bannerMapper = ProtobufRequestUtils.bannerMapper(ProtobufRequestUtils.formatMapper(spec.formatExtMapper()), spec.bannerExtMapper());
        ProtobufMapper<Asset, OpenRtb.NativeRequest.Asset> assetMapper = ProtobufRequestUtils.assetMapper(ProtobufRequestUtils.titleMapper(spec.nativeTitleExtMapper()), ProtobufRequestUtils.nativeImageMapper(spec.nativeImageExtMapper()), ProtobufRequestUtils.nativeVideoMapper(spec.nativeVideoExtMapper()), ProtobufRequestUtils.nativeDataMapper(spec.nativeDataExtMapper()), spec.nativeAssetExtMapper());
        ProtobufMapper<String, OpenRtb.NativeRequest> nativeRequestMapper = ProtobufRequestUtils.nativeRequestMapper(spec.objectMapper(), ProtobufRequestUtils.nativeRequestMapper(assetMapper, ProtobufRequestUtils.eventTrackerMapper(spec.nativeEventTrackerExtMapper()), spec.nativeRequestExtMapper()));
        ProtobufMapper<Imp, OpenRtb.BidRequest.Imp> impMapper = ProtobufRequestUtils.impMapper(ProtobufRequestUtils.metricMapper(spec.metricExtMapper()), bannerMapper, ProtobufRequestUtils.videoMapper(bannerMapper, spec.videoExtMapper()), ProtobufRequestUtils.audioMapper(bannerMapper, spec.audioExtMapper()), ProtobufRequestUtils.nativeMapper(nativeRequestMapper, spec.nativeExtMapper()), ProtobufRequestUtils.pmpMapper(ProtobufRequestUtils.dealMapper(spec.dealExtMapper()), spec.pmpExtMapper()), spec.impExtMapper());
        ProtobufMapper<Data, OpenRtb.BidRequest.Data> dataMapper = ProtobufRequestUtils.dataMapper(ProtobufRequestUtils.segmentMapper(spec.segmentExtMapper()), spec.dataExtMapper());
        ProtobufMapper<Publisher, OpenRtb.BidRequest.Publisher> publisherMapper = ProtobufRequestUtils.publisherMapper(spec.publisherExtMapper());
        ProtobufMapper<Content, OpenRtb.BidRequest.Content> contentMapper = ProtobufRequestUtils.contentMapper(ProtobufRequestUtils.producerMapper(spec.producerExtMapper()), dataMapper, spec.contentExtMapper());
        ProtobufMapper<Geo, OpenRtb.BidRequest.Geo> geoMapper = ProtobufRequestUtils.geoMapper(spec.geoExtMapper());
        return ProtobufRequestUtils.bidRequestMapper(impMapper, ProtobufRequestUtils.siteMapper(publisherMapper, contentMapper, spec.siteExtMapper()), ProtobufRequestUtils.appMapper(publisherMapper, contentMapper, spec.appExtMapper()), ProtobufRequestUtils.deviceMapper(geoMapper, spec.deviceExtMapper()), ProtobufRequestUtils.userMapper(geoMapper, dataMapper, spec.userExtMapper()), ProtobufRequestUtils.sourceMapper(spec.sourceExtMapper()), ProtobufRequestUtils.regsMapper(spec.regsExtMapper()), spec.bidRequestExtMapper());
    }

    public static <ProtobufExtensionType> ProtobufMapper<BidRequest, OpenRtb.BidRequest> bidRequestMapper(ProtobufMapper<Imp, OpenRtb.BidRequest.Imp> impMapper, ProtobufMapper<Site, OpenRtb.BidRequest.Site> siteMapper, ProtobufMapper<App, OpenRtb.BidRequest.App> appMapper, ProtobufMapper<Device, OpenRtb.BidRequest.Device> deviceMapper, ProtobufMapper<User, OpenRtb.BidRequest.User> userMapper, ProtobufMapper<Source, OpenRtb.BidRequest.Source> sourceMapper, ProtobufMapper<Regs, OpenRtb.BidRequest.Regs> regsMapper, ProtobufForwardExtensionMapper<OpenRtb.BidRequest, ExtRequest, ProtobufExtensionType> extMapper) {
        return bidRequest -> {
            OpenRtb.BidRequest.Builder resultBuilder = OpenRtb.BidRequest.newBuilder();
            ProtobufRequestUtils.setNotNull(bidRequest.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(bidRequest.getImp(), impMapper::map), resultBuilder::addAllImp);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getSite(), siteMapper::map), resultBuilder::setSite);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getApp(), appMapper::map), resultBuilder::setApp);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getDevice(), deviceMapper::map), resultBuilder::setDevice);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getUser(), userMapper::map), resultBuilder::setUser);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getTest(), BooleanUtils::toBoolean), resultBuilder::setTest);
            ProtobufRequestUtils.setNotNull(bidRequest.getAt(), resultBuilder::setAt);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getTmax(), Long::intValue), resultBuilder::setTmax);
            ProtobufRequestUtils.setNotNull(bidRequest.getWseat(), resultBuilder::addAllWseat);
            ProtobufRequestUtils.setNotNull(bidRequest.getBseat(), resultBuilder::addAllBseat);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getAllimps(), BooleanUtils::toBoolean), resultBuilder::setAllimps);
            ProtobufRequestUtils.setNotNull(bidRequest.getCur(), resultBuilder::addAllCur);
            ProtobufRequestUtils.setNotNull(bidRequest.getWlang(), resultBuilder::addAllWlang);
            ProtobufRequestUtils.setNotNull(bidRequest.getBcat(), resultBuilder::addAllBcat);
            ProtobufRequestUtils.setNotNull(bidRequest.getBadv(), resultBuilder::addAllBadv);
            ProtobufRequestUtils.setNotNull(bidRequest.getBapp(), resultBuilder::addAllBapp);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getSource(), sourceMapper::map), resultBuilder::setSource);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(bidRequest.getRegs(), regsMapper::map), resultBuilder::setRegs);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, bidRequest.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<VideoObject, OpenRtb.BidRequest.Imp.Video> nativeVideoMapper(JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Video, ProtobufExtensionType> extMapper) {
        return video -> {
            OpenRtb.BidRequest.Imp.Video.Builder resultBuilder = OpenRtb.BidRequest.Imp.Video.newBuilder();
            ProtobufRequestUtils.setNotNull(video.getMimes(), resultBuilder::addAllMimes);
            ProtobufRequestUtils.setNotNull(video.getMinduration(), resultBuilder::setMinduration);
            ProtobufRequestUtils.setNotNull(video.getMaxduration(), resultBuilder::setMaxduration);
            ProtobufRequestUtils.setNotNull(video.getProtocols(), resultBuilder::addAllProtocols);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, video.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Video.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Producer, OpenRtb.BidRequest.Producer> producerMapper(JsonProtobufExtensionMapper<OpenRtb.BidRequest.Producer, ProtobufExtensionType> extMapper) {
        return producer -> {
            OpenRtb.BidRequest.Producer.Builder resultBuilder = OpenRtb.BidRequest.Producer.newBuilder();
            ProtobufRequestUtils.setNotNull(producer.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(producer.getName(), resultBuilder::setName);
            ProtobufRequestUtils.setNotNull(producer.getCat(), resultBuilder::addAllCat);
            ProtobufRequestUtils.setNotNull(producer.getDomain(), resultBuilder::setDomain);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, producer.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Producer.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Pmp, OpenRtb.BidRequest.Imp.Pmp> pmpMapper(ProtobufMapper<Deal, OpenRtb.BidRequest.Imp.Pmp.Deal> dealsMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Pmp, ProtobufExtensionType> extMapper) {
        return pmp -> {
            OpenRtb.BidRequest.Imp.Pmp.Builder resultBuilder = OpenRtb.BidRequest.Imp.Pmp.newBuilder();
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(pmp.getPrivateAuction(), BooleanUtils::toBoolean), resultBuilder::setPrivateAuction);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(pmp.getDeals(), dealsMapper::map), resultBuilder::addAllDeals);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, pmp.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Pmp.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Site, OpenRtb.BidRequest.Site> siteMapper(ProtobufMapper<Publisher, OpenRtb.BidRequest.Publisher> publisherMapper, ProtobufMapper<Content, OpenRtb.BidRequest.Content> contentMapper, ProtobufForwardExtensionMapper<OpenRtb.BidRequest.Site, ExtSite, ProtobufExtensionType> extMapper) {
        return site -> {
            OpenRtb.BidRequest.Site.Builder resultBuilder = OpenRtb.BidRequest.Site.newBuilder();
            ProtobufRequestUtils.setNotNull(site.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(site.getName(), resultBuilder::setName);
            ProtobufRequestUtils.setNotNull(site.getDomain(), resultBuilder::setDomain);
            ProtobufRequestUtils.setNotNull(site.getCat(), resultBuilder::addAllCat);
            ProtobufRequestUtils.setNotNull(site.getSectioncat(), resultBuilder::addAllSectioncat);
            ProtobufRequestUtils.setNotNull(site.getPagecat(), resultBuilder::addAllPagecat);
            ProtobufRequestUtils.setNotNull(site.getPage(), resultBuilder::setPage);
            ProtobufRequestUtils.setNotNull(site.getRef(), resultBuilder::setRef);
            ProtobufRequestUtils.setNotNull(site.getSearch(), resultBuilder::setSearch);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(site.getMobile(), BooleanUtils::toBoolean), resultBuilder::setMobile);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(site.getPrivacypolicy(), BooleanUtils::toBoolean), resultBuilder::setPrivacypolicy);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(site.getPublisher(), publisherMapper::map), resultBuilder::setPublisher);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(site.getContent(), contentMapper::map), resultBuilder::setContent);
            ProtobufRequestUtils.setNotNull(site.getKeywords(), resultBuilder::setKeywords);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, site.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Site.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Geo, OpenRtb.BidRequest.Geo> geoMapper(ProtobufForwardExtensionMapper<OpenRtb.BidRequest.Geo, ExtGeo, ProtobufExtensionType> extMapper) {
        return geo -> {
            OpenRtb.BidRequest.Geo.Builder resultBuilder = OpenRtb.BidRequest.Geo.newBuilder();
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(geo.getLat(), Float::doubleValue), resultBuilder::setLat);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(geo.getLon(), Float::doubleValue), resultBuilder::setLon);
            ProtobufRequestUtils.setNotNull(geo.getType(), resultBuilder::setType);
            ProtobufRequestUtils.setNotNull(geo.getAccuracy(), resultBuilder::setAccuracy);
            ProtobufRequestUtils.setNotNull(geo.getLastfix(), resultBuilder::setLastfix);
            ProtobufRequestUtils.setNotNull(geo.getIpservice(), resultBuilder::setIpservice);
            ProtobufRequestUtils.setNotNull(geo.getCountry(), resultBuilder::setCountry);
            ProtobufRequestUtils.setNotNull(geo.getRegion(), resultBuilder::setRegion);
            ProtobufRequestUtils.setNotNull(geo.getRegionfips104(), resultBuilder::setRegionfips104);
            ProtobufRequestUtils.setNotNull(geo.getMetro(), resultBuilder::setMetro);
            ProtobufRequestUtils.setNotNull(geo.getCity(), resultBuilder::setCity);
            ProtobufRequestUtils.setNotNull(geo.getZip(), resultBuilder::setZip);
            ProtobufRequestUtils.setNotNull(geo.getUtcoffset(), resultBuilder::setUtcoffset);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, geo.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Geo.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Banner, OpenRtb.BidRequest.Imp.Banner> bannerMapper(ProtobufMapper<Format, OpenRtb.BidRequest.Imp.Banner.Format> formatMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Banner, ProtobufExtensionType> extMapper) {
        return banner -> {
            OpenRtb.BidRequest.Imp.Banner.Builder resultBuilder = OpenRtb.BidRequest.Imp.Banner.newBuilder();
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(banner.getFormat(), formatMapper::map), resultBuilder::addAllFormat);
            ProtobufRequestUtils.setNotNull(banner.getW(), resultBuilder::setW);
            ProtobufRequestUtils.setNotNull(banner.getH(), resultBuilder::setH);
            ProtobufRequestUtils.setNotNull(banner.getBtype(), resultBuilder::addAllBtype);
            ProtobufRequestUtils.setNotNull(banner.getBattr(), resultBuilder::addAllBattr);
            ProtobufRequestUtils.setNotNull(banner.getPos(), resultBuilder::setPos);
            ProtobufRequestUtils.setNotNull(banner.getMimes(), resultBuilder::addAllMimes);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(banner.getTopframe(), BooleanUtils::toBoolean), resultBuilder::setTopframe);
            ProtobufRequestUtils.setNotNull(banner.getExpdir(), resultBuilder::addAllExpdir);
            ProtobufRequestUtils.setNotNull(banner.getApi(), resultBuilder::addAllApi);
            ProtobufRequestUtils.setNotNull(banner.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(banner.getVcm(), BooleanUtils::toBoolean), resultBuilder::setVcm);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, banner.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Banner.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<ImageObject, OpenRtb.NativeRequest.Asset.Image> nativeImageMapper(JsonProtobufExtensionMapper<OpenRtb.NativeRequest.Asset.Image, ProtobufExtensionType> extMapper) {
        return imageObject -> {
            OpenRtb.NativeRequest.Asset.Image.Builder resultBuilder = OpenRtb.NativeRequest.Asset.Image.newBuilder();
            ProtobufRequestUtils.setNotNull(imageObject.getType(), resultBuilder::setType);
            ProtobufRequestUtils.setNotNull(imageObject.getW(), resultBuilder::setW);
            ProtobufRequestUtils.setNotNull(imageObject.getWmin(), resultBuilder::setWmin);
            ProtobufRequestUtils.setNotNull(imageObject.getH(), resultBuilder::setH);
            ProtobufRequestUtils.setNotNull(imageObject.getHmin(), resultBuilder::setHmin);
            ProtobufRequestUtils.setNotNull(imageObject.getMimes(), resultBuilder::addAllMimes);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, imageObject.getExt(), (arg_0, arg_1) -> ((OpenRtb.NativeRequest.Asset.Image.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Source, OpenRtb.BidRequest.Source> sourceMapper(ProtobufForwardExtensionMapper<OpenRtb.BidRequest.Source, ExtSource, ProtobufExtensionType> extMapper) {
        return source -> {
            OpenRtb.BidRequest.Source.Builder resultBuilder = OpenRtb.BidRequest.Source.newBuilder();
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(source.getFd(), BooleanUtils::toBoolean), resultBuilder::setFd);
            ProtobufRequestUtils.setNotNull(source.getTid(), resultBuilder::setTid);
            ProtobufRequestUtils.setNotNull(source.getPchain(), resultBuilder::setPchain);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, source.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Source.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Content, OpenRtb.BidRequest.Content> contentMapper(ProtobufMapper<Producer, OpenRtb.BidRequest.Producer> producerMapper, ProtobufMapper<Data, OpenRtb.BidRequest.Data> dataMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Content, ProtobufExtensionType> extMapper) {
        return content -> {
            OpenRtb.BidRequest.Content.Builder resultBuilder = OpenRtb.BidRequest.Content.newBuilder();
            ProtobufRequestUtils.setNotNull(content.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(content.getEpisode(), resultBuilder::setEpisode);
            ProtobufRequestUtils.setNotNull(content.getTitle(), resultBuilder::setTitle);
            ProtobufRequestUtils.setNotNull(content.getSeries(), resultBuilder::setSeries);
            ProtobufRequestUtils.setNotNull(content.getSeason(), resultBuilder::setSeason);
            ProtobufRequestUtils.setNotNull(content.getArtist(), resultBuilder::setArtist);
            ProtobufRequestUtils.setNotNull(content.getGenre(), resultBuilder::setGenre);
            ProtobufRequestUtils.setNotNull(content.getAlbum(), resultBuilder::setAlbum);
            ProtobufRequestUtils.setNotNull(content.getIsrc(), resultBuilder::setIsrc);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(content.getProducer(), producerMapper::map), resultBuilder::setProducer);
            ProtobufRequestUtils.setNotNull(content.getUrl(), resultBuilder::setUrl);
            ProtobufRequestUtils.setNotNull(content.getCat(), resultBuilder::addAllCat);
            ProtobufRequestUtils.setNotNull(content.getProdq(), resultBuilder::setProdq);
            ProtobufRequestUtils.setNotNull(content.getContext(), resultBuilder::setContext);
            ProtobufRequestUtils.setNotNull(content.getContentrating(), resultBuilder::setContentrating);
            ProtobufRequestUtils.setNotNull(content.getUserrating(), resultBuilder::setUserrating);
            ProtobufRequestUtils.setNotNull(content.getQagmediarating(), resultBuilder::setQagmediarating);
            ProtobufRequestUtils.setNotNull(content.getKeywords(), resultBuilder::setKeywords);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(content.getLivestream(), BooleanUtils::toBoolean), resultBuilder::setLivestream);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(content.getSourcerelationship(), BooleanUtils::toBoolean), resultBuilder::setSourcerelationship);
            ProtobufRequestUtils.setNotNull(content.getLen(), resultBuilder::setLen);
            ProtobufRequestUtils.setNotNull(content.getLanguage(), resultBuilder::setLanguage);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(content.getEmbeddable(), BooleanUtils::toBoolean), resultBuilder::setEmbeddable);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(content.getData(), dataMapper::map), resultBuilder::addAllData);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, content.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Content.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Device, OpenRtb.BidRequest.Device> deviceMapper(ProtobufMapper<Geo, OpenRtb.BidRequest.Geo> geoMapper, ProtobufForwardExtensionMapper<OpenRtb.BidRequest.Device, ExtDevice, ProtobufExtensionType> extMapper) {
        return device -> {
            OpenRtb.BidRequest.Device.Builder resultBuilder = OpenRtb.BidRequest.Device.newBuilder();
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(device.getGeo(), geoMapper::map), resultBuilder::setGeo);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(device.getDnt(), BooleanUtils::toBoolean), resultBuilder::setDnt);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(device.getLmt(), BooleanUtils::toBoolean), resultBuilder::setLmt);
            ProtobufRequestUtils.setNotNull(device.getUa(), resultBuilder::setUa);
            ProtobufRequestUtils.setNotNull(device.getIp(), resultBuilder::setIp);
            ProtobufRequestUtils.setNotNull(device.getIpv6(), resultBuilder::setIpv6);
            ProtobufRequestUtils.setNotNull(device.getDevicetype(), resultBuilder::setDevicetype);
            ProtobufRequestUtils.setNotNull(device.getMake(), resultBuilder::setMake);
            ProtobufRequestUtils.setNotNull(device.getModel(), resultBuilder::setModel);
            ProtobufRequestUtils.setNotNull(device.getOs(), resultBuilder::setOs);
            ProtobufRequestUtils.setNotNull(device.getOsv(), resultBuilder::setOsv);
            ProtobufRequestUtils.setNotNull(device.getHwv(), resultBuilder::setHwv);
            ProtobufRequestUtils.setNotNull(device.getH(), resultBuilder::setH);
            ProtobufRequestUtils.setNotNull(device.getW(), resultBuilder::setW);
            ProtobufRequestUtils.setNotNull(device.getPpi(), resultBuilder::setPpi);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(device.getPxratio(), BigDecimal::doubleValue), resultBuilder::setPxratio);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(device.getJs(), BooleanUtils::toBoolean), resultBuilder::setJs);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(device.getGeofetch(), BooleanUtils::toBoolean), resultBuilder::setGeofetch);
            ProtobufRequestUtils.setNotNull(device.getFlashver(), resultBuilder::setFlashver);
            ProtobufRequestUtils.setNotNull(device.getLanguage(), resultBuilder::setLanguage);
            ProtobufRequestUtils.setNotNull(device.getCarrier(), resultBuilder::setCarrier);
            ProtobufRequestUtils.setNotNull(device.getMccmnc(), resultBuilder::setMccmnc);
            ProtobufRequestUtils.setNotNull(device.getConnectiontype(), resultBuilder::setConnectiontype);
            ProtobufRequestUtils.setNotNull(device.getIfa(), resultBuilder::setIfa);
            ProtobufRequestUtils.setNotNull(device.getDidsha1(), resultBuilder::setDidsha1);
            ProtobufRequestUtils.setNotNull(device.getDidmd5(), resultBuilder::setDidmd5);
            ProtobufRequestUtils.setNotNull(device.getDpidsha1(), resultBuilder::setDpidsha1);
            ProtobufRequestUtils.setNotNull(device.getDpidmd5(), resultBuilder::setDpidmd5);
            ProtobufRequestUtils.setNotNull(device.getMacsha1(), resultBuilder::setMacsha1);
            ProtobufRequestUtils.setNotNull(device.getMacmd5(), resultBuilder::setMacmd5);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, device.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Device.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<DataObject, OpenRtb.NativeRequest.Asset.Data> nativeDataMapper(JsonProtobufExtensionMapper<OpenRtb.NativeRequest.Asset.Data, ProtobufExtensionType> extMapper) {
        return data -> {
            OpenRtb.NativeRequest.Asset.Data.Builder resultBuilder = OpenRtb.NativeRequest.Asset.Data.newBuilder();
            ProtobufRequestUtils.setNotNull(data.getType(), resultBuilder::setType);
            ProtobufRequestUtils.setNotNull(data.getLen(), resultBuilder::setLen);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, data.getExt(), (arg_0, arg_1) -> ((OpenRtb.NativeRequest.Asset.Data.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Data, OpenRtb.BidRequest.Data> dataMapper(ProtobufMapper<Segment, OpenRtb.BidRequest.Data.Segment> segmentMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Data, ProtobufExtensionType> extMapper) {
        return data -> {
            OpenRtb.BidRequest.Data.Builder resultBuilder = OpenRtb.BidRequest.Data.newBuilder();
            ProtobufRequestUtils.setNotNull(data.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(data.getName(), resultBuilder::setName);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(data.getSegment(), segmentMapper::map), resultBuilder::addAllSegment);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, data.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Data.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<TitleObject, OpenRtb.NativeRequest.Asset.Title> titleMapper(JsonProtobufExtensionMapper<OpenRtb.NativeRequest.Asset.Title, ProtobufExtensionType> extMapper) {
        return titleObject -> {
            OpenRtb.NativeRequest.Asset.Title.Builder resultBuilder = OpenRtb.NativeRequest.Asset.Title.newBuilder();
            ProtobufRequestUtils.setNotNull(titleObject.getLen(), resultBuilder::setLen);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, titleObject.getExt(), (arg_0, arg_1) -> ((OpenRtb.NativeRequest.Asset.Title.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Metric, OpenRtb.BidRequest.Imp.Metric> metricMapper(JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Metric, ProtobufExtensionType> extMapper) {
        return metric -> {
            OpenRtb.BidRequest.Imp.Metric.Builder resultBuilder = OpenRtb.BidRequest.Imp.Metric.newBuilder();
            ProtobufRequestUtils.setNotNull(metric.getType(), resultBuilder::setType);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(metric.getValue(), Float::doubleValue), resultBuilder::setValue);
            ProtobufRequestUtils.setNotNull(metric.getVendor(), resultBuilder::setVendor);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, metric.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Metric.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Format, OpenRtb.BidRequest.Imp.Banner.Format> formatMapper(JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Banner.Format, ProtobufExtensionType> extMapper) {
        return format -> {
            OpenRtb.BidRequest.Imp.Banner.Format.Builder resultBuilder = OpenRtb.BidRequest.Imp.Banner.Format.newBuilder();
            ProtobufRequestUtils.setNotNull(format.getW(), resultBuilder::setW);
            ProtobufRequestUtils.setNotNull(format.getH(), resultBuilder::setH);
            ProtobufRequestUtils.setNotNull(format.getWratio(), resultBuilder::setWratio);
            ProtobufRequestUtils.setNotNull(format.getHratio(), resultBuilder::setHratio);
            ProtobufRequestUtils.setNotNull(format.getWmin(), resultBuilder::setWmin);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, format.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Banner.Format.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Publisher, OpenRtb.BidRequest.Publisher> publisherMapper(ProtobufForwardExtensionMapper<OpenRtb.BidRequest.Publisher, ExtPublisher, ProtobufExtensionType> extMapper) {
        return publisher -> {
            OpenRtb.BidRequest.Publisher.Builder resultBuilder = OpenRtb.BidRequest.Publisher.newBuilder();
            ProtobufRequestUtils.setNotNull(publisher.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(publisher.getName(), resultBuilder::setName);
            ProtobufRequestUtils.setNotNull(publisher.getCat(), resultBuilder::addAllCat);
            ProtobufRequestUtils.setNotNull(publisher.getDomain(), resultBuilder::setDomain);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, publisher.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Publisher.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Deal, OpenRtb.BidRequest.Imp.Pmp.Deal> dealMapper(JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Pmp.Deal, ProtobufExtensionType> extMapper) {
        return deal -> {
            OpenRtb.BidRequest.Imp.Pmp.Deal.Builder resultBuilder = OpenRtb.BidRequest.Imp.Pmp.Deal.newBuilder();
            ProtobufRequestUtils.setNotNull(deal.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(deal.getBidfloor(), BigDecimal::doubleValue), resultBuilder::setBidfloor);
            ProtobufRequestUtils.setNotNull(deal.getBidfloorcur(), resultBuilder::setBidfloorcur);
            ProtobufRequestUtils.setNotNull(deal.getAt(), resultBuilder::setAt);
            ProtobufRequestUtils.setNotNull(deal.getWseat(), resultBuilder::addAllWseat);
            ProtobufRequestUtils.setNotNull(deal.getWadomain(), resultBuilder::addAllWadomain);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, deal.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Pmp.Deal.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<EventTracker, OpenRtb.NativeRequest.EventTrackers> eventTrackerMapper(JsonProtobufExtensionMapper<OpenRtb.NativeRequest.EventTrackers, ProtobufExtensionType> extMapper) {
        return eventTracker -> {
            OpenRtb.NativeRequest.EventTrackers.Builder resultBuilder = OpenRtb.NativeRequest.EventTrackers.newBuilder();
            ProtobufRequestUtils.setNotNull(eventTracker.getEvent(), resultBuilder::setEvent);
            ProtobufRequestUtils.setNotNull(eventTracker.getMethods(), resultBuilder::addAllMethods);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, eventTracker.getExt(), (arg_0, arg_1) -> ((OpenRtb.NativeRequest.EventTrackers.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Regs, OpenRtb.BidRequest.Regs> regsMapper(ProtobufForwardExtensionMapper<OpenRtb.BidRequest.Regs, ExtRegs, ProtobufExtensionType> extMapper) {
        return regs -> {
            OpenRtb.BidRequest.Regs.Builder resultBuilder = OpenRtb.BidRequest.Regs.newBuilder();
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(regs.getCoppa(), BooleanUtils::toBoolean), resultBuilder::setCoppa);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, regs.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Regs.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<App, OpenRtb.BidRequest.App> appMapper(ProtobufMapper<Publisher, OpenRtb.BidRequest.Publisher> publisherMapper, ProtobufMapper<Content, OpenRtb.BidRequest.Content> contentMapper, ProtobufForwardExtensionMapper<OpenRtb.BidRequest.App, ExtApp, ProtobufExtensionType> extMapper) {
        return app -> {
            OpenRtb.BidRequest.App.Builder resultBuilder = OpenRtb.BidRequest.App.newBuilder();
            ProtobufRequestUtils.setNotNull(app.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(app.getName(), resultBuilder::setName);
            ProtobufRequestUtils.setNotNull(app.getBundle(), resultBuilder::setBundle);
            ProtobufRequestUtils.setNotNull(app.getDomain(), resultBuilder::setDomain);
            ProtobufRequestUtils.setNotNull(app.getStoreurl(), resultBuilder::setStoreurl);
            ProtobufRequestUtils.setNotNull(app.getCat(), resultBuilder::addAllCat);
            ProtobufRequestUtils.setNotNull(app.getSectioncat(), resultBuilder::addAllSectioncat);
            ProtobufRequestUtils.setNotNull(app.getPagecat(), resultBuilder::addAllPagecat);
            ProtobufRequestUtils.setNotNull(app.getVer(), resultBuilder::setVer);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(app.getPrivacypolicy(), BooleanUtils::toBoolean), resultBuilder::setPrivacypolicy);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(app.getPaid(), BooleanUtils::toBoolean), resultBuilder::setPaid);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(app.getPublisher(), publisherMapper::map), resultBuilder::setPublisher);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(app.getContent(), contentMapper::map), resultBuilder::setContent);
            ProtobufRequestUtils.setNotNull(app.getKeywords(), resultBuilder::setKeywords);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, app.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.App.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Audio, OpenRtb.BidRequest.Imp.Audio> audioMapper(ProtobufMapper<Banner, OpenRtb.BidRequest.Imp.Banner> bannerMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Audio, ProtobufExtensionType> extMapper) {
        return audio -> {
            OpenRtb.BidRequest.Imp.Audio.Builder resultBuilder = OpenRtb.BidRequest.Imp.Audio.newBuilder();
            ProtobufRequestUtils.setNotNull(audio.getMimes(), resultBuilder::addAllMimes);
            ProtobufRequestUtils.setNotNull(audio.getMinduration(), resultBuilder::setMinduration);
            ProtobufRequestUtils.setNotNull(audio.getMaxduration(), resultBuilder::setMaxduration);
            ProtobufRequestUtils.setNotNull(audio.getProtocols(), resultBuilder::addAllProtocols);
            ProtobufRequestUtils.setNotNull(audio.getStartdelay(), resultBuilder::setStartdelay);
            ProtobufRequestUtils.setNotNull(audio.getSequence(), resultBuilder::setSequence);
            ProtobufRequestUtils.setNotNull(audio.getBattr(), resultBuilder::addAllBattr);
            ProtobufRequestUtils.setNotNull(audio.getMaxextended(), resultBuilder::setMaxextended);
            ProtobufRequestUtils.setNotNull(audio.getMinbitrate(), resultBuilder::setMinbitrate);
            ProtobufRequestUtils.setNotNull(audio.getMaxbitrate(), resultBuilder::setMaxbitrate);
            ProtobufRequestUtils.setNotNull(audio.getDelivery(), resultBuilder::addAllDelivery);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(audio.getCompanionad(), bannerMapper::map), resultBuilder::addAllCompanionad);
            ProtobufRequestUtils.setNotNull(audio.getApi(), resultBuilder::addAllApi);
            ProtobufRequestUtils.setNotNull(audio.getCompaniontype(), resultBuilder::addAllCompaniontype);
            ProtobufRequestUtils.setNotNull(audio.getMaxseq(), resultBuilder::setMaxseq);
            ProtobufRequestUtils.setNotNull(audio.getFeed(), resultBuilder::setFeed);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(audio.getStitched(), BooleanUtils::toBoolean), resultBuilder::setStitched);
            ProtobufRequestUtils.setNotNull(audio.getNvol(), resultBuilder::setNvol);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, audio.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Audio.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static ProtobufMapper<String, OpenRtb.NativeRequest> nativeRequestMapper(ObjectMapper objectMapper, ProtobufMapper<Request, OpenRtb.NativeRequest> nativeRequestMapper) {
        return value -> {
            try {
                Request request = (Request)objectMapper.readValue(value, Request.class);
                return (OpenRtb.NativeRequest)nativeRequestMapper.map(request);
            }
            catch (Throwable e) {
                return null;
            }
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Request, OpenRtb.NativeRequest> nativeRequestMapper(ProtobufMapper<Asset, OpenRtb.NativeRequest.Asset> assetsMapper, ProtobufMapper<EventTracker, OpenRtb.NativeRequest.EventTrackers> eventTrackerMapper, JsonProtobufExtensionMapper<OpenRtb.NativeRequest, ProtobufExtensionType> extMapper) {
        return request -> {
            OpenRtb.NativeRequest.Builder resultBuilder = OpenRtb.NativeRequest.newBuilder();
            ProtobufRequestUtils.setNotNull(request.getVer(), resultBuilder::setVer);
            ProtobufRequestUtils.setNotNull(request.getContext(), resultBuilder::setContext);
            ProtobufRequestUtils.setNotNull(request.getContextsubtype(), resultBuilder::setContextsubtype);
            ProtobufRequestUtils.setNotNull(request.getPlcmttype(), resultBuilder::setPlcmttype);
            ProtobufRequestUtils.setNotNull(request.getPlcmtcnt(), resultBuilder::setPlcmtcnt);
            ProtobufRequestUtils.setNotNull(request.getSeq(), resultBuilder::setSeq);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(request.getAssets(), assetsMapper::map), resultBuilder::addAllAssets);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(request.getAurlsupport(), BooleanUtils::toBoolean), resultBuilder::setAurlsupport);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(request.getDurlsupport(), BooleanUtils::toBoolean), resultBuilder::setDurlsupport);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(request.getEventtrackers(), eventTrackerMapper::map), resultBuilder::addAllEventtrackers);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(request.getPrivacy(), BooleanUtils::toBoolean), resultBuilder::setPrivacy);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, request.getExt(), (arg_0, arg_1) -> ((OpenRtb.NativeRequest.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Native, OpenRtb.BidRequest.Imp.Native> nativeMapper(ProtobufMapper<String, OpenRtb.NativeRequest> nativeRequestMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Native, ProtobufExtensionType> extMapper) {
        return xNative -> {
            OpenRtb.BidRequest.Imp.Native.Builder resultBuilder = OpenRtb.BidRequest.Imp.Native.newBuilder();
            OpenRtb.NativeRequest nativeRequest = (OpenRtb.NativeRequest)nativeRequestMapper.map(xNative.getRequest());
            if (nativeRequest != null) {
                resultBuilder.setRequestNative(nativeRequest);
            } else {
                resultBuilder.setRequest(xNative.getRequest());
            }
            ProtobufRequestUtils.setNotNull(xNative.getVer(), resultBuilder::setVer);
            ProtobufRequestUtils.setNotNull(xNative.getApi(), resultBuilder::addAllApi);
            ProtobufRequestUtils.setNotNull(xNative.getBattr(), resultBuilder::addAllBattr);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, xNative.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Native.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Asset, OpenRtb.NativeRequest.Asset> assetMapper(ProtobufMapper<TitleObject, OpenRtb.NativeRequest.Asset.Title> titleMapper, ProtobufMapper<ImageObject, OpenRtb.NativeRequest.Asset.Image> imgMapper, ProtobufMapper<VideoObject, OpenRtb.BidRequest.Imp.Video> videoMapper, ProtobufMapper<DataObject, OpenRtb.NativeRequest.Asset.Data> dataMapper, JsonProtobufExtensionMapper<OpenRtb.NativeRequest.Asset, ProtobufExtensionType> extMapper) {
        return asset -> {
            OpenRtb.NativeRequest.Asset.Builder resultBuilder = OpenRtb.NativeRequest.Asset.newBuilder();
            ProtobufRequestUtils.setNotNull(asset.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(asset.getRequired(), BooleanUtils::toBoolean), resultBuilder::setRequired);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(asset.getTitle(), titleMapper::map), resultBuilder::setTitle);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(asset.getImg(), imgMapper::map), resultBuilder::setImg);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(asset.getVideo(), videoMapper::map), resultBuilder::setVideo);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(asset.getData(), dataMapper::map), resultBuilder::setData);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, asset.getExt(), (arg_0, arg_1) -> ((OpenRtb.NativeRequest.Asset.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Segment, OpenRtb.BidRequest.Data.Segment> segmentMapper(JsonProtobufExtensionMapper<OpenRtb.BidRequest.Data.Segment, ProtobufExtensionType> extMapper) {
        return segment -> {
            OpenRtb.BidRequest.Data.Segment.Builder resultBuilder = OpenRtb.BidRequest.Data.Segment.newBuilder();
            ProtobufRequestUtils.setNotNull(segment.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(segment.getName(), resultBuilder::setName);
            ProtobufRequestUtils.setNotNull(segment.getValue(), resultBuilder::setValue);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, segment.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Data.Segment.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Imp, OpenRtb.BidRequest.Imp> impMapper(ProtobufMapper<Metric, OpenRtb.BidRequest.Imp.Metric> metricMapper, ProtobufMapper<Banner, OpenRtb.BidRequest.Imp.Banner> bannerMapper, ProtobufMapper<Video, OpenRtb.BidRequest.Imp.Video> videoMapper, ProtobufMapper<Audio, OpenRtb.BidRequest.Imp.Audio> audioMapper, ProtobufMapper<Native, OpenRtb.BidRequest.Imp.Native> nativeMapper, ProtobufMapper<Pmp, OpenRtb.BidRequest.Imp.Pmp> pmpMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp, ProtobufExtensionType> extMapper) {
        return imp -> {
            OpenRtb.BidRequest.Imp.Builder resultBuilder = OpenRtb.BidRequest.Imp.newBuilder();
            ProtobufRequestUtils.setNotNull(imp.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(imp.getMetric(), metricMapper::map), resultBuilder::addAllMetric);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getBanner(), bannerMapper::map), resultBuilder::setBanner);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getVideo(), videoMapper::map), resultBuilder::setVideo);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getAudio(), audioMapper::map), resultBuilder::setAudio);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getXNative(), nativeMapper::map), resultBuilder::setNative);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getPmp(), pmpMapper::map), resultBuilder::setPmp);
            ProtobufRequestUtils.setNotNull(imp.getDisplaymanager(), resultBuilder::setDisplaymanager);
            ProtobufRequestUtils.setNotNull(imp.getDisplaymanagerver(), resultBuilder::setDisplaymanagerver);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getInstl(), BooleanUtils::toBoolean), resultBuilder::setInstl);
            ProtobufRequestUtils.setNotNull(imp.getTagid(), resultBuilder::setTagid);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getBidfloor(), BigDecimal::doubleValue), resultBuilder::setBidfloor);
            ProtobufRequestUtils.setNotNull(imp.getBidfloorcur(), resultBuilder::setBidfloorcur);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getClickbrowser(), BooleanUtils::toBoolean), resultBuilder::setClickbrowser);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(imp.getSecure(), BooleanUtils::toBoolean), resultBuilder::setSecure);
            ProtobufRequestUtils.setNotNull(imp.getIframebuster(), resultBuilder::addAllIframebuster);
            ProtobufRequestUtils.setNotNull(imp.getExp(), resultBuilder::setExp);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, imp.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<Video, OpenRtb.BidRequest.Imp.Video> videoMapper(ProtobufMapper<Banner, OpenRtb.BidRequest.Imp.Banner> bannerMapper, JsonProtobufExtensionMapper<OpenRtb.BidRequest.Imp.Video, ProtobufExtensionType> extMapper) {
        return video -> {
            OpenRtb.BidRequest.Imp.Video.Builder resultBuilder = OpenRtb.BidRequest.Imp.Video.newBuilder();
            ProtobufRequestUtils.setNotNull(video.getMimes(), resultBuilder::addAllMimes);
            ProtobufRequestUtils.setNotNull(video.getMinduration(), resultBuilder::setMinduration);
            ProtobufRequestUtils.setNotNull(video.getMaxduration(), resultBuilder::setMaxduration);
            ProtobufRequestUtils.setNotNull(video.getStartdelay(), resultBuilder::setStartdelay);
            ProtobufRequestUtils.setNotNull(video.getProtocols(), resultBuilder::addAllProtocols);
            ProtobufRequestUtils.setNotNull(video.getW(), resultBuilder::setW);
            ProtobufRequestUtils.setNotNull(video.getH(), resultBuilder::setH);
            ProtobufRequestUtils.setNotNull(video.getPlacement(), resultBuilder::setPlacement);
            ProtobufRequestUtils.setNotNull(video.getLinearity(), resultBuilder::setLinearity);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(video.getSkip(), BooleanUtils::toBoolean), resultBuilder::setSkip);
            ProtobufRequestUtils.setNotNull(video.getSkipmin(), resultBuilder::setSkipmin);
            ProtobufRequestUtils.setNotNull(video.getSkipafter(), resultBuilder::setSkipafter);
            ProtobufRequestUtils.setNotNull(video.getSequence(), resultBuilder::setSequence);
            ProtobufRequestUtils.setNotNull(video.getBattr(), resultBuilder::addAllBattr);
            ProtobufRequestUtils.setNotNull(video.getMaxextended(), resultBuilder::setMaxextended);
            ProtobufRequestUtils.setNotNull(video.getMinbitrate(), resultBuilder::setMinbitrate);
            ProtobufRequestUtils.setNotNull(video.getMaxbitrate(), resultBuilder::setMaxbitrate);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(video.getBoxingallowed(), BooleanUtils::toBoolean), resultBuilder::setBoxingallowed);
            ProtobufRequestUtils.setNotNull(video.getPlaybackmethod(), resultBuilder::addAllPlaybackmethod);
            ProtobufRequestUtils.setNotNull(video.getPlaybackend(), resultBuilder::setPlaybackend);
            ProtobufRequestUtils.setNotNull(video.getDelivery(), resultBuilder::addAllDelivery);
            ProtobufRequestUtils.setNotNull(video.getPos(), resultBuilder::setPos);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(video.getCompanionad(), bannerMapper::map), resultBuilder::addAllCompanionad);
            ProtobufRequestUtils.setNotNull(video.getApi(), resultBuilder::addAllApi);
            ProtobufRequestUtils.setNotNull(video.getCompaniontype(), resultBuilder::addAllCompaniontype);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, video.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.Imp.Video.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<User, OpenRtb.BidRequest.User> userMapper(ProtobufMapper<Geo, OpenRtb.BidRequest.Geo> geoMapper, ProtobufMapper<Data, OpenRtb.BidRequest.Data> dataMapper, ProtobufForwardExtensionMapper<OpenRtb.BidRequest.User, ExtUser, ProtobufExtensionType> extMapper) {
        return user -> {
            OpenRtb.BidRequest.User.Builder resultBuilder = OpenRtb.BidRequest.User.newBuilder();
            ProtobufRequestUtils.setNotNull(user.getId(), resultBuilder::setId);
            ProtobufRequestUtils.setNotNull(user.getBuyeruid(), resultBuilder::setBuyeruid);
            ProtobufRequestUtils.setNotNull(user.getYob(), resultBuilder::setYob);
            ProtobufRequestUtils.setNotNull(user.getGender(), resultBuilder::setGender);
            ProtobufRequestUtils.setNotNull(user.getKeywords(), resultBuilder::setKeywords);
            ProtobufRequestUtils.setNotNull(user.getCustomdata(), resultBuilder::setCustomdata);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapNotNull(user.getGeo(), geoMapper::map), resultBuilder::setGeo);
            ProtobufRequestUtils.setNotNull(ProtobufRequestUtils.mapList(user.getData(), dataMapper::map), resultBuilder::addAllData);
            ProtobufRequestUtils.mapAndSetExtension(extMapper, user.getExt(), (arg_0, arg_1) -> ((OpenRtb.BidRequest.User.Builder)resultBuilder).setExtension(arg_0, arg_1));
            return resultBuilder.build();
        };
    }

    private static <T, U> U mapNotNull(T value, Function<T, U> mapper) {
        return value != null ? (U)mapper.apply(value) : null;
    }

    private static <T> void setNotNull(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }

    private static <T, U> List<U> mapList(List<T> values, Function<T, U> mapper) {
        return CollectionUtils.isEmpty(values) ? Collections.emptyList() : values.stream().map(mapper).toList();
    }

    private static <ContainingType extends Message, FromType, ToType> void mapAndSetExtension(ProtobufForwardExtensionMapper<ContainingType, FromType, ToType> mapper, FromType value, BiConsumer<ExtensionLite<ContainingType, ToType>, ToType> extensionSetter) {
        if (mapper == null || value == null) {
            return;
        }
        ToType mappedExt = mapper.map(value);
        if (mappedExt != null) {
            extensionSetter.accept((ExtensionLite<ContainingType, ToType>)mapper.extensionDescriptor(), mappedExt);
        }
    }
}

