/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.model;

import java.beans.ConstructorProperties;
import java.util.List;
import org.prebid.server.privacy.ccpa.Ccpa;

public final class Privacy {
    private final String gdpr;
    private final String consentString;
    private final Ccpa ccpa;
    private final Integer coppa;
    private final String gpp;
    private final List<Integer> gppSid;

    public Privacy withoutConsent() {
        return this.toBuilder().consentString("").build();
    }

    @ConstructorProperties(value={"gdpr", "consentString", "ccpa", "coppa", "gpp", "gppSid"})
    Privacy(String gdpr, String consentString, Ccpa ccpa, Integer coppa, String gpp, List<Integer> gppSid) {
        this.gdpr = gdpr;
        this.consentString = consentString;
        this.ccpa = ccpa;
        this.coppa = coppa;
        this.gpp = gpp;
        this.gppSid = gppSid;
    }

    public static PrivacyBuilder builder() {
        return new PrivacyBuilder();
    }

    public PrivacyBuilder toBuilder() {
        return new PrivacyBuilder().gdpr(this.gdpr).consentString(this.consentString).ccpa(this.ccpa).coppa(this.coppa).gpp(this.gpp).gppSid(this.gppSid);
    }

    public String getGdpr() {
        return this.gdpr;
    }

    public String getConsentString() {
        return this.consentString;
    }

    public Ccpa getCcpa() {
        return this.ccpa;
    }

    public Integer getCoppa() {
        return this.coppa;
    }

    public String getGpp() {
        return this.gpp;
    }

    public List<Integer> getGppSid() {
        return this.gppSid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Privacy)) {
            return false;
        }
        Privacy other = (Privacy)o;
        Integer this$coppa = this.getCoppa();
        Integer other$coppa = other.getCoppa();
        if (this$coppa == null ? other$coppa != null : !((Object)this$coppa).equals(other$coppa)) {
            return false;
        }
        String this$gdpr = this.getGdpr();
        String other$gdpr = other.getGdpr();
        if (this$gdpr == null ? other$gdpr != null : !this$gdpr.equals(other$gdpr)) {
            return false;
        }
        String this$consentString = this.getConsentString();
        String other$consentString = other.getConsentString();
        if (this$consentString == null ? other$consentString != null : !this$consentString.equals(other$consentString)) {
            return false;
        }
        Ccpa this$ccpa = this.getCcpa();
        Ccpa other$ccpa = other.getCcpa();
        if (this$ccpa == null ? other$ccpa != null : !((Object)this$ccpa).equals(other$ccpa)) {
            return false;
        }
        String this$gpp = this.getGpp();
        String other$gpp = other.getGpp();
        if (this$gpp == null ? other$gpp != null : !this$gpp.equals(other$gpp)) {
            return false;
        }
        List<Integer> this$gppSid = this.getGppSid();
        List<Integer> other$gppSid = other.getGppSid();
        return !(this$gppSid == null ? other$gppSid != null : !((Object)this$gppSid).equals(other$gppSid));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $coppa = this.getCoppa();
        result = result * 59 + ($coppa == null ? 43 : ((Object)$coppa).hashCode());
        String $gdpr = this.getGdpr();
        result = result * 59 + ($gdpr == null ? 43 : $gdpr.hashCode());
        String $consentString = this.getConsentString();
        result = result * 59 + ($consentString == null ? 43 : $consentString.hashCode());
        Ccpa $ccpa = this.getCcpa();
        result = result * 59 + ($ccpa == null ? 43 : ((Object)$ccpa).hashCode());
        String $gpp = this.getGpp();
        result = result * 59 + ($gpp == null ? 43 : $gpp.hashCode());
        List<Integer> $gppSid = this.getGppSid();
        result = result * 59 + ($gppSid == null ? 43 : ((Object)$gppSid).hashCode());
        return result;
    }

    public String toString() {
        return "Privacy(gdpr=" + this.getGdpr() + ", consentString=" + this.getConsentString() + ", ccpa=" + this.getCcpa() + ", coppa=" + this.getCoppa() + ", gpp=" + this.getGpp() + ", gppSid=" + this.getGppSid() + ")";
    }

    public static class PrivacyBuilder {
        private String gdpr;
        private String consentString;
        private Ccpa ccpa;
        private Integer coppa;
        private String gpp;
        private List<Integer> gppSid;

        PrivacyBuilder() {
        }

        public PrivacyBuilder gdpr(String gdpr) {
            this.gdpr = gdpr;
            return this;
        }

        public PrivacyBuilder consentString(String consentString) {
            this.consentString = consentString;
            return this;
        }

        public PrivacyBuilder ccpa(Ccpa ccpa) {
            this.ccpa = ccpa;
            return this;
        }

        public PrivacyBuilder coppa(Integer coppa) {
            this.coppa = coppa;
            return this;
        }

        public PrivacyBuilder gpp(String gpp) {
            this.gpp = gpp;
            return this;
        }

        public PrivacyBuilder gppSid(List<Integer> gppSid) {
            this.gppSid = gppSid;
            return this;
        }

        public Privacy build() {
            return new Privacy(this.gdpr, this.consentString, this.ccpa, this.coppa, this.gpp, this.gppSid);
        }

        public String toString() {
            return "Privacy.PrivacyBuilder(gdpr=" + this.gdpr + ", consentString=" + this.consentString + ", ccpa=" + this.ccpa + ", coppa=" + this.coppa + ", gpp=" + this.gpp + ", gppSid=" + this.gppSid + ")";
        }
    }
}

