/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.tcfstrategies.specialfeature;

import com.iabtcf.decoder.TCString;
import com.iabtcf.utils.IntIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.settings.model.SpecialFeature;

public abstract class SpecialFeaturesStrategy {
    public abstract int getSpecialFeatureId();

    public abstract void allow(PrivacyEnforcementAction var1);

    public Collection<VendorPermission> processSpecialFeaturesStrategy(TCString vendorConsent, SpecialFeature specialFeature, Collection<VendorPermission> vendorPermissions) {
        if (BooleanUtils.isFalse((Boolean)specialFeature.getEnforce())) {
            return this.allowFor(vendorPermissions);
        }
        IntIterable specialFeatureOptIns = vendorConsent.getSpecialFeatureOptIns();
        boolean isSpecialFeatureIsOptIn = specialFeatureOptIns.contains(this.getSpecialFeatureId());
        return isSpecialFeatureIsOptIn ? this.allowFor(vendorPermissions) : this.allowOnlyExcluded(vendorPermissions, specialFeature);
    }

    private Collection<VendorPermission> allowFor(Collection<VendorPermission> vendorPermissions) {
        vendorPermissions.forEach(vendorPermission -> this.allow(vendorPermission.getPrivacyEnforcementAction()));
        return vendorPermissions;
    }

    private Collection<VendorPermission> allowOnlyExcluded(Collection<VendorPermission> vendorPermissions, SpecialFeature specialFeature) {
        this.excludedVendors(vendorPermissions, specialFeature).forEach(vendorPermission -> this.allow(vendorPermission.getPrivacyEnforcementAction()));
        return vendorPermissions;
    }

    protected Collection<VendorPermission> excludedVendors(Collection<VendorPermission> vendorPermissions, SpecialFeature specialFeature) {
        List<String> bidderNameExceptions = specialFeature.getVendorExceptions();
        return CollectionUtils.isEmpty(bidderNameExceptions) ? Collections.emptyList() : CollectionUtils.select(vendorPermissions, vendorPermission -> bidderNameExceptions.contains(vendorPermission.getBidderName()));
    }
}

