/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies;

import com.iabtcf.decoder.TCString;
import com.iabtcf.v2.PublisherRestriction;
import com.iabtcf.v2.RestrictionType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies.EnforcePurposeStrategy;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;
import org.prebid.server.privacy.gdpr.vendorlist.proto.Vendor;

public class FullEnforcePurposeStrategy
extends EnforcePurposeStrategy {
    @Override
    public Collection<VendorPermission> allowedByTypeStrategy(PurposeCode purpose, TCString vendorConsent, Collection<VendorPermissionWithGvl> vendorsForPurpose, Collection<VendorPermissionWithGvl> excludedVendors, boolean isEnforceVendors) {
        List<PublisherRestriction> publisherRestrictions = vendorConsent.getPublisherRestrictions().stream().filter(publisherRestriction -> publisherRestriction.getPurposeId() == purpose.code()).toList();
        List<VendorPermission> allowedExcluded = this.allowedExcludedVendorPermission(excludedVendors, publisherRestrictions);
        Map<VendorPermissionWithGvl, RestrictionType> vendorPermissionToRestriction = this.mapVendorPermission(vendorsForPurpose, publisherRestrictions);
        List<VendorPermission> allowedVendorPermissions = vendorPermissionToRestriction.entrySet().stream().filter(permissionAndRestriction -> this.isAllowedByPublisherRestrictionAndFlexible(purpose, isEnforceVendors, (VendorPermissionWithGvl)permissionAndRestriction.getKey(), vendorConsent, (RestrictionType)permissionAndRestriction.getValue())).map(Map.Entry::getKey).map(VendorPermissionWithGvl::getVendorPermission).toList();
        return CollectionUtils.union(allowedExcluded, allowedVendorPermissions);
    }

    private List<VendorPermission> allowedExcludedVendorPermission(Collection<VendorPermissionWithGvl> excludedVendors, Collection<PublisherRestriction> publisherRestrictions) {
        List notAllowedVendorIds = publisherRestrictions.stream().filter(publisherRestriction -> publisherRestriction.getRestrictionType().equals((Object)RestrictionType.NOT_ALLOWED)).map(PublisherRestriction::getVendorIds).flatMap(vendorIds -> StreamSupport.stream(vendorIds.spliterator(), false)).toList();
        return excludedVendors.stream().map(VendorPermissionWithGvl::getVendorPermission).filter(vendorPermissionWithGvl -> this.isNotRestricted(notAllowedVendorIds, (VendorPermission)vendorPermissionWithGvl)).toList();
    }

    private boolean isNotRestricted(List<Integer> notAllowedVendorIds, VendorPermission vendorPermission) {
        Integer vendorId = vendorPermission.getVendorId();
        return vendorId == null || !notAllowedVendorIds.contains(vendorId);
    }

    private Map<VendorPermissionWithGvl, RestrictionType> mapVendorPermission(Collection<VendorPermissionWithGvl> vendorsForPurpose, Collection<PublisherRestriction> publisherRestrictions) {
        return vendorsForPurpose.stream().collect(Collectors.toMap(Function.identity(), vendorPermissionWithGvl -> this.restrictionType((VendorPermissionWithGvl)vendorPermissionWithGvl, publisherRestrictions)));
    }

    private RestrictionType restrictionType(VendorPermissionWithGvl vendorPermissionWithGvl, Collection<PublisherRestriction> publisherRestrictions) {
        VendorPermission vendorPermission = vendorPermissionWithGvl.getVendorPermission();
        Integer vendorId = vendorPermission.getVendorId();
        return publisherRestrictions.stream().filter(publisherRestriction -> publisherRestriction.getVendorIds().contains(vendorId.intValue())).map(PublisherRestriction::getRestrictionType).findFirst().orElse(RestrictionType.UNDEFINED);
    }

    private boolean isAllowedByPublisherRestrictionAndFlexible(PurposeCode purpose, boolean isEnforceVendor, VendorPermissionWithGvl vendorPermissionWithGvl, TCString tcString, RestrictionType restrictionType) {
        if (restrictionType.equals((Object)RestrictionType.NOT_ALLOWED)) {
            return false;
        }
        Integer vendorId = vendorPermissionWithGvl.getVendorPermission().getVendorId();
        Vendor vendorGvl = vendorPermissionWithGvl.getVendor();
        EnumSet<PurposeCode> flexiblePurposes = vendorGvl.getFlexiblePurposes();
        boolean isFlexible = CollectionUtils.isNotEmpty(flexiblePurposes) && flexiblePurposes.contains((Object)purpose);
        EnumSet<PurposeCode> gvlPurposeCodes = vendorGvl.getPurposes();
        if (gvlPurposeCodes != null && gvlPurposeCodes.contains((Object)purpose)) {
            return isFlexible ? this.isAllowedByFlexible(purpose, vendorId, isEnforceVendor, tcString, restrictionType) : this.isAllowedByNotFlexiblePurpose(purpose, vendorId, isEnforceVendor, tcString, restrictionType);
        }
        EnumSet<PurposeCode> legIntGvlPurposeCodes = vendorGvl.getLegIntPurposes();
        if (legIntGvlPurposeCodes != null && legIntGvlPurposeCodes.contains((Object)purpose)) {
            return isFlexible ? this.isAllowedByFlexible(purpose, vendorId, isEnforceVendor, tcString, restrictionType) : this.isAllowedByNotFlexibleLegitimateInterest(purpose, vendorId, isEnforceVendor, tcString, restrictionType);
        }
        return false;
    }

    private boolean isAllowedByNotFlexiblePurpose(PurposeCode purpose, Integer vendorId, boolean isEnforceVendor, TCString tcString, RestrictionType restrictionType) {
        boolean isSupportedRestriction = restrictionType.equals((Object)RestrictionType.REQUIRE_CONSENT) || restrictionType.equals((Object)RestrictionType.UNDEFINED);
        return isSupportedRestriction && this.isAllowedBySimpleConsent(purpose, vendorId, isEnforceVendor, tcString);
    }

    private boolean isAllowedByNotFlexibleLegitimateInterest(PurposeCode purpose, Integer vendorId, boolean isEnforceVendor, TCString tcString, RestrictionType restrictionType) {
        boolean isSupportedRestriction = restrictionType.equals((Object)RestrictionType.REQUIRE_LEGITIMATE_INTEREST) || restrictionType.equals((Object)RestrictionType.UNDEFINED);
        return isSupportedRestriction && this.isAllowedByLegitimateInterest(purpose, vendorId, isEnforceVendor, tcString);
    }

    private boolean isAllowedByFlexible(PurposeCode purpose, Integer vendorId, boolean isEnforceVendor, TCString tcString, RestrictionType restrictionType) {
        return switch (restrictionType) {
            default -> throw new IncompatibleClassChangeError();
            case RestrictionType.NOT_ALLOWED -> false;
            case RestrictionType.REQUIRE_CONSENT -> this.isAllowedBySimpleConsent(purpose, vendorId, isEnforceVendor, tcString);
            case RestrictionType.REQUIRE_LEGITIMATE_INTEREST -> this.isAllowedByLegitimateInterest(purpose, vendorId, isEnforceVendor, tcString);
            case RestrictionType.UNDEFINED -> this.isAllowedBySimpleConsentOrLegitimateInterest(purpose, vendorId, isEnforceVendor, tcString);
        };
    }
}

