/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies;

import com.iabtcf.decoder.TCString;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies.EnforcePurposeStrategy;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;

public class BasicEnforcePurposeStrategy
extends EnforcePurposeStrategy {
    private static final Logger logger = LoggerFactory.getLogger(BasicEnforcePurposeStrategy.class);

    @Override
    public Collection<VendorPermission> allowedByTypeStrategy(PurposeCode purpose, TCString vendorConsent, Collection<VendorPermissionWithGvl> vendorsForPurpose, Collection<VendorPermissionWithGvl> excludedVendors, boolean isEnforceVendors) {
        logger.debug((Object)"Basic strategy used for purpose {0}", new Object[]{purpose});
        List<VendorPermission> allowedVendorPermissions = vendorsForPurpose.stream().map(VendorPermissionWithGvl::getVendorPermission).filter(vendorPermission -> vendorPermission.getVendorId() != null).filter(vendorPermission -> this.isAllowedBySimpleConsent(purpose, vendorPermission.getVendorId(), isEnforceVendors, vendorConsent)).toList();
        return CollectionUtils.union(allowedVendorPermissions, BasicEnforcePurposeStrategy.toVendorPermissions(excludedVendors));
    }
}

