/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.tcfstrategies.purpose;

import com.iabtcf.decoder.TCString;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies.BasicEnforcePurposeStrategy;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies.FullEnforcePurposeStrategy;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies.NoEnforcePurposeStrategy;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;
import org.prebid.server.settings.model.EnforcePurpose;
import org.prebid.server.settings.model.Purpose;

public abstract class PurposeStrategy {
    private final FullEnforcePurposeStrategy fullEnforcePurposeStrategy;
    private final BasicEnforcePurposeStrategy basicEnforcePurposeStrategy;
    private final NoEnforcePurposeStrategy noEnforcePurposeStrategy;

    public PurposeStrategy(FullEnforcePurposeStrategy fullEnforcePurposeStrategy, BasicEnforcePurposeStrategy basicEnforcePurposeStrategy, NoEnforcePurposeStrategy noEnforcePurposeStrategy) {
        this.fullEnforcePurposeStrategy = fullEnforcePurposeStrategy;
        this.basicEnforcePurposeStrategy = basicEnforcePurposeStrategy;
        this.noEnforcePurposeStrategy = noEnforcePurposeStrategy;
    }

    public abstract PurposeCode getPurpose();

    public abstract void allow(PrivacyEnforcementAction var1);

    public abstract void allowNaturally(PrivacyEnforcementAction var1);

    public Collection<VendorPermission> processTypePurposeStrategy(TCString vendorConsent, Purpose purpose, Collection<VendorPermissionWithGvl> vendorPermissions, boolean wasDowngraded) {
        Collection<VendorPermissionWithGvl> excludedVendors = this.excludedVendors(vendorPermissions, purpose);
        List<VendorPermissionWithGvl> vendorForPurpose = vendorPermissions.stream().filter(vendorPermission -> !excludedVendors.contains(vendorPermission)).toList();
        this.allowedByTypeStrategy(vendorConsent, purpose, vendorForPurpose, excludedVendors).stream().map(VendorPermission::getPrivacyEnforcementAction).forEach(this::allow);
        Collection<VendorPermission> naturalVendorPermission = wasDowngraded ? this.allowedByBasicTypeStrategy(vendorConsent, true, vendorForPurpose, excludedVendors) : this.allowedByFullTypeStrategy(vendorConsent, true, vendorForPurpose, excludedVendors);
        naturalVendorPermission.stream().map(VendorPermission::getPrivacyEnforcementAction).forEach(this::allowNaturally);
        return vendorPermissions.stream().map(VendorPermissionWithGvl::getVendorPermission).toList();
    }

    private Collection<VendorPermission> allowedByTypeStrategy(TCString vendorConsent, Purpose purpose, Collection<VendorPermissionWithGvl> vendorForPurpose, Collection<VendorPermissionWithGvl> excludedVendors) {
        boolean isEnforceVendors = BooleanUtils.isNotFalse((Boolean)purpose.getEnforceVendors());
        EnforcePurpose purposeType = purpose.getEnforcePurpose();
        if (Objects.equals((Object)purposeType, (Object)EnforcePurpose.basic)) {
            return this.allowedByBasicTypeStrategy(vendorConsent, isEnforceVendors, vendorForPurpose, excludedVendors);
        }
        if (Objects.equals((Object)purposeType, (Object)EnforcePurpose.no)) {
            return this.allowedByNoTypeStrategy(vendorConsent, isEnforceVendors, vendorForPurpose, excludedVendors);
        }
        if (purposeType == null || purposeType.equals((Object)EnforcePurpose.full)) {
            return this.allowedByFullTypeStrategy(vendorConsent, isEnforceVendors, vendorForPurpose, excludedVendors);
        }
        throw new IllegalArgumentException("Invalid type strategy provided. no/base/full != " + purposeType);
    }

    protected Collection<VendorPermissionWithGvl> excludedVendors(Collection<VendorPermissionWithGvl> vendorPermissions, Purpose purpose) {
        List<String> bidderNameExceptions = purpose.getVendorExceptions();
        return CollectionUtils.isEmpty(bidderNameExceptions) ? Collections.emptyList() : CollectionUtils.select(vendorPermissions, vendorPermission -> bidderNameExceptions.contains(vendorPermission.getVendorPermission().getBidderName()));
    }

    protected Collection<VendorPermission> allowedByBasicTypeStrategy(TCString vendorConsent, boolean isEnforceVendors, Collection<VendorPermissionWithGvl> vendorForPurpose, Collection<VendorPermissionWithGvl> excludedVendors) {
        return this.basicEnforcePurposeStrategy.allowedByTypeStrategy(this.getPurpose(), vendorConsent, vendorForPurpose, excludedVendors, isEnforceVendors);
    }

    protected Collection<VendorPermission> allowedByNoTypeStrategy(TCString vendorConsent, boolean isEnforceVendors, Collection<VendorPermissionWithGvl> vendorForPurpose, Collection<VendorPermissionWithGvl> excludedVendors) {
        return this.noEnforcePurposeStrategy.allowedByTypeStrategy(this.getPurpose(), vendorConsent, vendorForPurpose, excludedVendors, isEnforceVendors);
    }

    protected Collection<VendorPermission> allowedByFullTypeStrategy(TCString vendorConsent, boolean isEnforceVendors, Collection<VendorPermissionWithGvl> vendorForPurpose, Collection<VendorPermissionWithGvl> excludedVendors) {
        return this.fullEnforcePurposeStrategy.allowedByTypeStrategy(this.getPurpose(), vendorConsent, vendorForPurpose, excludedVendors, isEnforceVendors);
    }
}

