/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr;

import com.iabtcf.decoder.TCString;
import io.vertx.core.Future;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.privacy.gdpr.VendorIdResolver;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.PurposeStrategy;
import org.prebid.server.privacy.gdpr.tcfstrategies.specialfeature.SpecialFeaturesStrategy;
import org.prebid.server.privacy.gdpr.vendorlist.VersionedVendorListService;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;
import org.prebid.server.privacy.gdpr.vendorlist.proto.Vendor;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.EnforcePurpose;
import org.prebid.server.settings.model.GdprConfig;
import org.prebid.server.settings.model.Purpose;
import org.prebid.server.settings.model.PurposeOneTreatmentInterpretation;
import org.prebid.server.settings.model.Purposes;
import org.prebid.server.settings.model.SpecialFeature;
import org.prebid.server.settings.model.SpecialFeatures;

public class Tcf2Service {
    private final Purposes defaultPurposes;
    private final SpecialFeatures defaultSpecialFeatures;
    private final VersionedVendorListService versionedVendorListService;
    private final List<PurposeStrategy> purposeStrategies;
    private final List<SpecialFeaturesStrategy> specialFeaturesStrategies;
    private final BidderCatalog bidderCatalog;
    private final PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation;

    public Tcf2Service(GdprConfig gdprConfig, List<PurposeStrategy> purposeStrategies, List<SpecialFeaturesStrategy> specialFeaturesStrategies, VersionedVendorListService versionedVendorListService, BidderCatalog bidderCatalog) {
        this.defaultPurposes = gdprConfig.getPurposes() == null ? Purposes.builder().build() : gdprConfig.getPurposes();
        this.defaultSpecialFeatures = gdprConfig.getSpecialFeatures() == null ? SpecialFeatures.builder().build() : gdprConfig.getSpecialFeatures();
        this.purposeOneTreatmentInterpretation = gdprConfig.getPurposeOneTreatmentInterpretation();
        this.versionedVendorListService = Objects.requireNonNull(versionedVendorListService);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.purposeStrategies = Objects.requireNonNull(purposeStrategies);
        this.specialFeaturesStrategies = Objects.requireNonNull(specialFeaturesStrategies);
    }

    public Future<Collection<VendorPermission>> permissionsFor(Set<Integer> vendorIds, TCString tcfConsent) {
        return this.permissionsForInternal(this.vendorPermissions(vendorIds), tcfConsent, null);
    }

    public Future<Collection<VendorPermission>> permissionsFor(Set<String> bidderNames, VendorIdResolver vendorIdResolver, TCString tcfConsent, AccountGdprConfig accountGdprConfig) {
        return this.permissionsForInternal(this.vendorPermissions(bidderNames, vendorIdResolver), tcfConsent, accountGdprConfig);
    }

    private Collection<VendorPermission> vendorPermissions(Set<Integer> vendorIds) {
        return vendorIds.stream().filter(Objects::nonNull).map(vendorId -> VendorPermission.of(vendorId, this.bidderCatalog.nameByVendorId((Integer)vendorId), PrivacyEnforcementAction.restrictAll())).toList();
    }

    private Collection<VendorPermission> vendorPermissions(Set<String> bidderNames, VendorIdResolver vendorIdResolver) {
        return bidderNames.stream().filter(Objects::nonNull).map(bidderName -> VendorPermission.of(vendorIdResolver.resolve((String)bidderName), bidderName, PrivacyEnforcementAction.restrictAll())).toList();
    }

    private Future<Collection<VendorPermission>> permissionsForInternal(Collection<VendorPermission> vendorPermissions, TCString tcfConsent, AccountGdprConfig accountGdprConfig) {
        Purposes mergedPurposes = this.mergeAccountPurposes(accountGdprConfig);
        SpecialFeatures mergedSpecialFeatures = this.mergeAccountSpecialFeatures(accountGdprConfig);
        PurposeOneTreatmentInterpretation mergedPurposeOneTreatmentInterpretation = this.mergePurposeOneTreatmentInterpretation(accountGdprConfig);
        VendorPermissionsByType<VendorPermission> vendorPermissionsByType = Tcf2Service.toVendorPermissionsByType(vendorPermissions, accountGdprConfig);
        return this.versionedVendorListService.forConsent(tcfConsent).map(vendorGvlPermissions -> Tcf2Service.wrapWithGVL(vendorPermissionsByType, (Map<Integer, Vendor>)vendorGvlPermissions)).compose(gvlResult -> this.processSupportedPurposeStrategies(tcfConsent, (VendorPermissionsByType<VendorPermissionWithGvl>)gvlResult, mergedPurposes, this.purposeOneTreatmentInterpretation), ignoredFailed -> this.processDowngradedSupportedPurposeStrategies(tcfConsent, vendorPermissionsByType, mergedPurposes, mergedPurposeOneTreatmentInterpretation)).map(changedVendorPermissions -> this.processSupportedSpecialFeatureStrategies(tcfConsent, (Collection<VendorPermission>)changedVendorPermissions, mergedSpecialFeatures));
    }

    private static VendorPermissionsByType<VendorPermission> toVendorPermissionsByType(Collection<VendorPermission> vendorPermissions, AccountGdprConfig accountGdprConfig) {
        List<String> basicEnforcedVendors;
        List<String> list = basicEnforcedVendors = accountGdprConfig != null ? accountGdprConfig.getBasicEnforcementVendors() : null;
        if (CollectionUtils.isEmpty(basicEnforcedVendors)) {
            return VendorPermissionsByType.of(Collections.emptyList(), vendorPermissions);
        }
        Map<Boolean, List<VendorPermission>> isBasicEnforcedToPermissions = vendorPermissions.stream().collect(Collectors.partitioningBy(vendorPermission -> basicEnforcedVendors.contains(vendorPermission.getBidderName())));
        List weakPermissions = isBasicEnforcedToPermissions.getOrDefault(true, Collections.emptyList());
        List standardPermissions = isBasicEnforcedToPermissions.getOrDefault(false, Collections.emptyList());
        return VendorPermissionsByType.of(weakPermissions, standardPermissions);
    }

    private static VendorPermissionsByType<VendorPermissionWithGvl> wrapWithGVL(VendorPermissionsByType<VendorPermission> vendorPermissionsByType, Map<Integer, Vendor> vendorGvlPermissions) {
        List<VendorPermissionWithGvl> weakPermissions = vendorPermissionsByType.getWeakPermissions().stream().map(vendorPermission -> Tcf2Service.wrapWithGVL(vendorPermission, vendorGvlPermissions)).toList();
        List<VendorPermissionWithGvl> standardPermissions = vendorPermissionsByType.getStandardPermissions().stream().map(vendorPermission -> Tcf2Service.wrapWithGVL(vendorPermission, vendorGvlPermissions)).toList();
        return VendorPermissionsByType.of(weakPermissions, standardPermissions);
    }

    private static VendorPermissionWithGvl wrapWithGVL(VendorPermission vendorPermission, Map<Integer, Vendor> vendorGvlPermissions) {
        Integer vendorId = vendorPermission.getVendorId();
        Vendor vendorGvlByVendorId = vendorId != null ? vendorGvlPermissions.getOrDefault(vendorId, Vendor.empty(vendorId)) : Vendor.empty(vendorId);
        return VendorPermissionWithGvl.of(vendorPermission, vendorGvlByVendorId);
    }

    private Future<Collection<VendorPermission>> processSupportedPurposeStrategies(TCString tcfConsent, VendorPermissionsByType<VendorPermissionWithGvl> vendorPermissionsByType, Purposes purposes, PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation) {
        for (PurposeStrategy purposeStrategy : this.purposeStrategies) {
            PurposeCode tcfPurpose = purposeStrategy.getPurpose();
            Purpose purposeById = this.findPurposeByTcfPurpose(tcfPurpose, purposes);
            Purpose weakPurpose = Tcf2Service.weakPurpose(purposeById);
            Collection<VendorPermissionWithGvl> standardPermissions = vendorPermissionsByType.getStandardPermissions();
            Collection<VendorPermissionWithGvl> weakPermissions = vendorPermissionsByType.getWeakPermissions();
            this.processPurposeStrategy(tcfConsent, standardPermissions, purposeById, purposeStrategy, purposeOneTreatmentInterpretation, false);
            this.processPurposeStrategy(tcfConsent, weakPermissions, weakPurpose, purposeStrategy, purposeOneTreatmentInterpretation, true);
        }
        return Future.succeededFuture(vendorPermissionsByType.joinPermissions().stream().map(VendorPermissionWithGvl::getVendorPermission).toList());
    }

    private Future<Collection<VendorPermission>> processDowngradedSupportedPurposeStrategies(TCString tcfConsent, VendorPermissionsByType<VendorPermission> vendorPermissionsByType, Purposes purposes, PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation) {
        VendorPermissionsByType<VendorPermissionWithGvl> vendorPermissionsWithGvlByType = Tcf2Service.wrapWithGVL(vendorPermissionsByType, Collections.emptyMap());
        for (PurposeStrategy purposeStrategy : this.purposeStrategies) {
            PurposeCode tcfPurpose = purposeStrategy.getPurpose();
            Purpose downgradedPurposeById = Tcf2Service.downgradePurpose(this.findPurposeByTcfPurpose(tcfPurpose, purposes));
            Purpose weakPurpose = Tcf2Service.weakPurpose(downgradedPurposeById);
            Collection<VendorPermissionWithGvl> standardPermissions = vendorPermissionsWithGvlByType.getStandardPermissions();
            Collection<VendorPermissionWithGvl> weakPermissions = vendorPermissionsWithGvlByType.getWeakPermissions();
            this.processPurposeStrategy(tcfConsent, standardPermissions, downgradedPurposeById, purposeStrategy, purposeOneTreatmentInterpretation, true);
            this.processPurposeStrategy(tcfConsent, weakPermissions, weakPurpose, purposeStrategy, purposeOneTreatmentInterpretation, true);
        }
        return Future.succeededFuture(vendorPermissionsByType.joinPermissions());
    }

    private void processPurposeStrategy(TCString tcfConsent, Collection<VendorPermissionWithGvl> vendorPermissionsWithGvl, Purpose purpose, PurposeStrategy purposeStrategy, PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation, boolean wasDowngraded) {
        if (purposeStrategy.getPurpose() == PurposeCode.ONE && tcfConsent.getPurposeOneTreatment()) {
            this.processPurposeOneTreatment(purposeOneTreatmentInterpretation, tcfConsent, purpose, purposeStrategy, vendorPermissionsWithGvl, wasDowngraded);
        } else {
            purposeStrategy.processTypePurposeStrategy(tcfConsent, purpose, vendorPermissionsWithGvl, wasDowngraded);
        }
    }

    private void processPurposeOneTreatment(PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation, TCString tcfConsent, Purpose purposeOne, PurposeStrategy purposeOneStrategy, Collection<VendorPermissionWithGvl> vendorPermissionsWithGvl, boolean wasDowngraded) {
        switch (purposeOneTreatmentInterpretation) {
            case accessAllowed: {
                vendorPermissionsWithGvl.forEach(vendorPermission -> purposeOneStrategy.allow(vendorPermission.getVendorPermission().getPrivacyEnforcementAction()));
                break;
            }
            case noAccessAllowed: {
                break;
            }
            case ignore: {
                purposeOneStrategy.processTypePurposeStrategy(tcfConsent, purposeOne, vendorPermissionsWithGvl, wasDowngraded);
            }
        }
    }

    private static Purpose downgradePurpose(Purpose purpose) {
        EnforcePurpose enforcePurpose = purpose.getEnforcePurpose();
        return enforcePurpose == null || Objects.equals((Object)enforcePurpose, (Object)EnforcePurpose.full) ? Purpose.of(EnforcePurpose.basic, purpose.getEnforceVendors(), purpose.getVendorExceptions()) : purpose;
    }

    private static Purpose weakPurpose(Purpose purpose) {
        EnforcePurpose enforcePurpose = purpose.getEnforcePurpose();
        EnforcePurpose downgradedEnforce = enforcePurpose == null || Objects.equals((Object)enforcePurpose, (Object)EnforcePurpose.full) ? EnforcePurpose.basic : enforcePurpose;
        return Purpose.of(downgradedEnforce, false, purpose.getVendorExceptions());
    }

    private Collection<VendorPermission> processSupportedSpecialFeatureStrategies(TCString tcfConsent, Collection<VendorPermission> vendorPermissions, SpecialFeatures specialFeatures) {
        for (SpecialFeaturesStrategy specialFeaturesStrategy : this.specialFeaturesStrategies) {
            int specialFeatureId = specialFeaturesStrategy.getSpecialFeatureId();
            SpecialFeature specialFeatureById = this.findSpecialFeatureById(specialFeatureId, specialFeatures);
            specialFeaturesStrategy.processSpecialFeaturesStrategy(tcfConsent, specialFeatureById, vendorPermissions);
        }
        return vendorPermissions;
    }

    private Purposes mergeAccountPurposes(AccountGdprConfig accountGdprConfig) {
        if (accountGdprConfig == null || accountGdprConfig.getPurposes() == null) {
            return this.defaultPurposes;
        }
        Purposes accountPurposes = accountGdprConfig.getPurposes();
        return Purposes.builder().p1(Tcf2Service.mergeItem(accountPurposes.getP1(), this.defaultPurposes.getP1())).p2(Tcf2Service.mergeItem(accountPurposes.getP2(), this.defaultPurposes.getP2())).p3(Tcf2Service.mergeItem(accountPurposes.getP3(), this.defaultPurposes.getP3())).p4(Tcf2Service.mergeItem(accountPurposes.getP4(), this.defaultPurposes.getP4())).p5(Tcf2Service.mergeItem(accountPurposes.getP5(), this.defaultPurposes.getP5())).p6(Tcf2Service.mergeItem(accountPurposes.getP6(), this.defaultPurposes.getP6())).p7(Tcf2Service.mergeItem(accountPurposes.getP7(), this.defaultPurposes.getP7())).p8(Tcf2Service.mergeItem(accountPurposes.getP8(), this.defaultPurposes.getP8())).p9(Tcf2Service.mergeItem(accountPurposes.getP9(), this.defaultPurposes.getP9())).p10(Tcf2Service.mergeItem(accountPurposes.getP10(), this.defaultPurposes.getP10())).build();
    }

    private SpecialFeatures mergeAccountSpecialFeatures(AccountGdprConfig accountGdprConfig) {
        if (accountGdprConfig == null || accountGdprConfig.getSpecialFeatures() == null) {
            return this.defaultSpecialFeatures;
        }
        SpecialFeatures accountSpecialFeatures = accountGdprConfig.getSpecialFeatures();
        return SpecialFeatures.builder().sf1(Tcf2Service.mergeItem(accountSpecialFeatures.getSf1(), this.defaultSpecialFeatures.getSf1())).sf2(Tcf2Service.mergeItem(accountSpecialFeatures.getSf2(), this.defaultSpecialFeatures.getSf2())).build();
    }

    private Purpose findPurposeByTcfPurpose(PurposeCode tcfPurpose, Purposes purposes) {
        return switch (tcfPurpose) {
            case PurposeCode.ONE -> purposes.getP1();
            case PurposeCode.TWO -> purposes.getP2();
            case PurposeCode.THREE -> purposes.getP3();
            case PurposeCode.FOUR -> purposes.getP4();
            case PurposeCode.FIVE -> purposes.getP5();
            case PurposeCode.SIX -> purposes.getP6();
            case PurposeCode.SEVEN -> purposes.getP7();
            case PurposeCode.EIGHT -> purposes.getP8();
            case PurposeCode.NINE -> purposes.getP9();
            case PurposeCode.TEN -> purposes.getP10();
            default -> throw new IllegalArgumentException("Illegal TCF code for purpose: " + tcfPurpose);
        };
    }

    private SpecialFeature findSpecialFeatureById(int specialFeatureId, SpecialFeatures specialFeatures) {
        return switch (specialFeatureId) {
            case 1 -> specialFeatures.getSf1();
            case 2 -> specialFeatures.getSf2();
            default -> throw new IllegalArgumentException("Illegal TCF code for special feature: " + specialFeatureId);
        };
    }

    private PurposeOneTreatmentInterpretation mergePurposeOneTreatmentInterpretation(AccountGdprConfig accountGdprConfig) {
        if (accountGdprConfig == null || accountGdprConfig.getPurposeOneTreatmentInterpretation() == null) {
            return this.purposeOneTreatmentInterpretation;
        }
        return Tcf2Service.mergeItem(accountGdprConfig.getPurposeOneTreatmentInterpretation(), this.purposeOneTreatmentInterpretation);
    }

    private static <T> T mergeItem(T prioritisedItem, T item) {
        return prioritisedItem == null ? item : prioritisedItem;
    }

    private static final class VendorPermissionsByType<T> {
        private final Collection<T> weakPermissions;
        private final Collection<T> standardPermissions;

        public Collection<T> joinPermissions() {
            return Stream.concat(this.weakPermissions.stream(), this.standardPermissions.stream()).toList();
        }

        @ConstructorProperties(value={"weakPermissions", "standardPermissions"})
        private VendorPermissionsByType(Collection<T> weakPermissions, Collection<T> standardPermissions) {
            this.weakPermissions = weakPermissions;
            this.standardPermissions = standardPermissions;
        }

        public static <T> VendorPermissionsByType<T> of(Collection<T> weakPermissions, Collection<T> standardPermissions) {
            return new VendorPermissionsByType<T>(weakPermissions, standardPermissions);
        }

        public Collection<T> getWeakPermissions() {
            return this.weakPermissions;
        }

        public Collection<T> getStandardPermissions() {
            return this.standardPermissions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VendorPermissionsByType)) {
                return false;
            }
            VendorPermissionsByType other = (VendorPermissionsByType)o;
            Collection<T> this$weakPermissions = this.getWeakPermissions();
            Collection<T> other$weakPermissions = other.getWeakPermissions();
            if (this$weakPermissions == null ? other$weakPermissions != null : !((Object)this$weakPermissions).equals(other$weakPermissions)) {
                return false;
            }
            Collection<T> this$standardPermissions = this.getStandardPermissions();
            Collection<T> other$standardPermissions = other.getStandardPermissions();
            return !(this$standardPermissions == null ? other$standardPermissions != null : !((Object)this$standardPermissions).equals(other$standardPermissions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<T> $weakPermissions = this.getWeakPermissions();
            result = result * 59 + ($weakPermissions == null ? 43 : ((Object)$weakPermissions).hashCode());
            Collection<T> $standardPermissions = this.getStandardPermissions();
            result = result * 59 + ($standardPermissions == null ? 43 : ((Object)$standardPermissions).hashCode());
            return result;
        }

        public String toString() {
            return "Tcf2Service.VendorPermissionsByType(weakPermissions=" + this.getWeakPermissions() + ", standardPermissions=" + this.getStandardPermissions() + ")";
        }
    }
}

