/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.optout;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.optout.model.RecaptchaResponse;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

public class GoogleRecaptchaVerifier {
    private static final Logger logger = LoggerFactory.getLogger(GoogleRecaptchaVerifier.class);
    private final String recaptchaUrl;
    private final String recaptchaSecret;
    private final HttpClient httpClient;
    private final JacksonMapper mapper;

    public GoogleRecaptchaVerifier(String recaptchaUrl, String recaptchaSecret, HttpClient httpClient, JacksonMapper mapper) {
        this.recaptchaUrl = Objects.requireNonNull(recaptchaUrl);
        this.recaptchaSecret = Objects.requireNonNull(recaptchaSecret);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Future<RecaptchaResponse> verify(String recaptcha) {
        return this.httpClient.post(this.recaptchaUrl, GoogleRecaptchaVerifier.headers(), GoogleRecaptchaVerifier.encodedBody(this.recaptchaSecret, recaptcha), 2000L).compose(this::processResponse).recover(GoogleRecaptchaVerifier::failResponse);
    }

    private static MultiMap headers() {
        return MultiMap.caseInsensitiveMultiMap().add(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED).add(HttpUtil.ACCEPT_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
    }

    private static String encodedBody(String secret, String recaptcha) {
        return "secret=" + GoogleRecaptchaVerifier.encodeValue(secret) + "&response=" + GoogleRecaptchaVerifier.encodeValue(recaptcha);
    }

    private static String encodeValue(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private Future<RecaptchaResponse> processResponse(HttpClientResponse response) {
        RecaptchaResponse recaptchaResponse;
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("HTTP status code " + statusCode);
        }
        String body = response.getBody();
        try {
            recaptchaResponse = this.mapper.decodeValue(body, RecaptchaResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Cannot parse response: " + body, e);
        }
        if (!Objects.equals(recaptchaResponse.getSuccess(), Boolean.TRUE)) {
            List<String> errorCodes = recaptchaResponse.getErrorCodes();
            String errors = errorCodes != null ? String.join((CharSequence)", ", errorCodes) : null;
            throw new PreBidException("Verification failed: " + errors);
        }
        return Future.succeededFuture((Object)recaptchaResponse);
    }

    private static Future<RecaptchaResponse> failResponse(Throwable exception) {
        logger.warn((Object)"Error occurred while verifying Google Recaptcha", exception);
        return Future.failedFuture((Throwable)exception);
    }
}

