/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.SpecificValidationMetrics;
import org.prebid.server.metric.UpdatableMetrics;

class ValidationMetrics
extends UpdatableMetrics {
    private final SpecificValidationMetrics sizeValidationMetrics;
    private final SpecificValidationMetrics secureValidationMetrics;

    ValidationMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), ValidationMetrics.nameCreator(ValidationMetrics.createPrefix(Objects.requireNonNull(prefix))));
        this.sizeValidationMetrics = new SpecificValidationMetrics(metricRegistry, counterType, ValidationMetrics.createPrefix(prefix), "size");
        this.secureValidationMetrics = new SpecificValidationMetrics(metricRegistry, counterType, ValidationMetrics.createPrefix(prefix), "secure");
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    private static String createPrefix(String prefix) {
        return prefix + ".validation";
    }

    SpecificValidationMetrics size() {
        return this.sizeValidationMetrics;
    }

    SpecificValidationMetrics secure() {
        return this.secureValidationMetrics;
    }
}

