/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.UpdatableMetrics;

class TcfMetrics
extends UpdatableMetrics {
    private static final int TCF_V1_VERSION = 1;
    private static final int TCF_V2_VERSION = 2;
    private final TcfVersionMetrics tcfVersion1Metrics;
    private final TcfVersionMetrics tcfVersion2Metrics;

    TcfMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), TcfMetrics.nameCreator(TcfMetrics.createTcfPrefix(Objects.requireNonNull(prefix))));
        this.tcfVersion1Metrics = new TcfVersionMetrics(metricRegistry, counterType, TcfMetrics.createTcfPrefix(prefix), "v1");
        this.tcfVersion2Metrics = new TcfVersionMetrics(metricRegistry, counterType, TcfMetrics.createTcfPrefix(prefix), "v2");
    }

    TcfVersionMetrics fromVersion(int version) {
        return switch (version) {
            case 1 -> this.tcfVersion1Metrics;
            case 2 -> this.tcfVersion2Metrics;
            default -> throw new PreBidException("Unknown tcf version " + version);
        };
    }

    private static String createTcfPrefix(String prefix) {
        return prefix + ".tcf";
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    static class TcfVersionMetrics
    extends UpdatableMetrics {
        private final VendorListMetrics vendorListMetrics;

        TcfVersionMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix, String version) {
            super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), TcfVersionMetrics.nameCreator(TcfVersionMetrics.createVersionPrefix(Objects.requireNonNull(prefix), Objects.requireNonNull(version))));
            this.vendorListMetrics = new VendorListMetrics(metricRegistry, counterType, TcfVersionMetrics.createVersionPrefix(prefix, version));
        }

        private static String createVersionPrefix(String prefix, String version) {
            return "%s.%s".formatted(prefix, version);
        }

        private static Function<MetricName, String> nameCreator(String prefix) {
            return metricName -> "%s.%s".formatted(prefix, metricName);
        }

        VendorListMetrics vendorList() {
            return this.vendorListMetrics;
        }
    }

    static class VendorListMetrics
    extends UpdatableMetrics {
        VendorListMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix) {
            super(metricRegistry, counterType, VendorListMetrics.nameCreator(VendorListMetrics.createVersionPrefix(prefix)));
        }

        private static String createVersionPrefix(String prefix) {
            return prefix + ".vendorlist";
        }

        private static Function<MetricName, String> nameCreator(String prefix) {
            return metricName -> "%s.%s".formatted(prefix, metricName);
        }
    }
}

