/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.UpdatableMetrics;

class CircuitBreakerMetrics
extends UpdatableMetrics {
    private static final String SUFFIX = ".count";
    private final Function<String, NamedCircuitBreakerMetrics> namedCircuitBreakerMetricsCreator = name -> new NamedCircuitBreakerMetrics(metricRegistry, counterType, CircuitBreakerMetrics.createPrefix(type), (String)name);
    private final Map<String, NamedCircuitBreakerMetrics> namedCircuitBreakerMetrics = new HashMap<String, NamedCircuitBreakerMetrics>();

    CircuitBreakerMetrics(MetricRegistry metricRegistry, CounterType counterType, MetricName type) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), CircuitBreakerMetrics.nameCreator(CircuitBreakerMetrics.createPrefix(Objects.requireNonNull(type))));
    }

    NamedCircuitBreakerMetrics forName(String name) {
        return this.namedCircuitBreakerMetrics.computeIfAbsent(name, this.namedCircuitBreakerMetricsCreator);
    }

    private static String createPrefix(MetricName type) {
        return "circuit-breaker.%s".formatted(type.toString());
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s%s".formatted(prefix, metricName, SUFFIX);
    }

    @Override
    void incCounter(MetricName metricName) {
        throw new UnsupportedOperationException();
    }

    @Override
    void incCounter(MetricName metricName, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateTimer(MetricName metricName, long millis) {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateHistogram(MetricName metricName, long value) {
        throw new UnsupportedOperationException();
    }

    static class NamedCircuitBreakerMetrics
    extends UpdatableMetrics {
        NamedCircuitBreakerMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix, String name) {
            super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), NamedCircuitBreakerMetrics.nameCreator(Objects.requireNonNull(prefix), Objects.requireNonNull(name)));
        }

        private static Function<MetricName, String> nameCreator(String prefix, String name) {
            return metricName -> "%s.named.%s.%s%s".formatted(prefix, name, metricName, CircuitBreakerMetrics.SUFFIX);
        }

        @Override
        void incCounter(MetricName metricName) {
            throw new UnsupportedOperationException();
        }

        @Override
        void incCounter(MetricName metricName, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        void updateTimer(MetricName metricName, long millis) {
            throw new UnsupportedOperationException();
        }

        @Override
        void updateHistogram(MetricName metricName, long value) {
            throw new UnsupportedOperationException();
        }
    }
}

