/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.ActivitiesMetrics;
import org.prebid.server.metric.AdapterMetrics;
import org.prebid.server.metric.CacheMetrics;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.HooksMetrics;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.RequestMetrics;
import org.prebid.server.metric.RequestTypeMetrics;
import org.prebid.server.metric.ResponseMetrics;
import org.prebid.server.metric.UpdatableMetrics;

class AccountMetrics
extends UpdatableMetrics {
    private final Function<MetricName, RequestTypeMetrics> requestTypeMetricsCreator = requestType -> new RequestTypeMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account), (MetricName)((Object)requestType));
    private final Map<MetricName, RequestTypeMetrics> requestTypeMetrics;
    private final AdapterMetrics adapterMetrics;
    private final RequestMetrics requestsMetrics;
    private final CacheMetrics cacheMetrics;
    private final ResponseMetrics responseMetrics;
    private final HooksMetrics hooksMetrics;
    private final ActivitiesMetrics activitiesMetrics;

    AccountMetrics(MetricRegistry metricRegistry, CounterType counterType, String account) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), AccountMetrics.nameCreator(AccountMetrics.createPrefix(Objects.requireNonNull(account))));
        this.adapterMetrics = new AdapterMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account));
        this.requestTypeMetrics = new HashMap<MetricName, RequestTypeMetrics>();
        this.requestsMetrics = new RequestMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account));
        this.cacheMetrics = new CacheMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account));
        this.responseMetrics = new ResponseMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account));
        this.hooksMetrics = new HooksMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account));
        this.activitiesMetrics = new ActivitiesMetrics(metricRegistry, counterType, AccountMetrics.createPrefix(account));
    }

    private static String createPrefix(String account) {
        return "account." + account;
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    AdapterMetrics adapter() {
        return this.adapterMetrics;
    }

    RequestTypeMetrics requestType(MetricName requestType) {
        return this.requestTypeMetrics.computeIfAbsent(requestType, this.requestTypeMetricsCreator);
    }

    RequestMetrics requests() {
        return this.requestsMetrics;
    }

    CacheMetrics cache() {
        return this.cacheMetrics;
    }

    ResponseMetrics response() {
        return this.responseMetrics;
    }

    HooksMetrics hooks() {
        return this.hooksMetrics;
    }

    ActivitiesMetrics activities() {
        return this.activitiesMetrics;
    }
}

