/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.prebid.server.deals.model.LogCriteriaFilter;
import org.prebid.server.log.Criteria;
import org.prebid.server.log.CriteriaLogManager;

public class CriteriaManager {
    private static final long MAX_CRITERIA_DURATION = 300000L;
    private static final Logger logger = LoggerFactory.getLogger(CriteriaManager.class);
    private final CriteriaLogManager criteriaLogManager;
    private final Vertx vertx;

    public CriteriaManager(CriteriaLogManager criteriaLogManager, Vertx vertx) {
        this.criteriaLogManager = criteriaLogManager;
        this.vertx = vertx;
    }

    public void addCriteria(String accountId, String bidderCode, String lineItemId, String loggerLevel, Integer durationMillis) {
        Criteria criteria = Criteria.create(accountId, bidderCode, lineItemId, this.resolveLogLevel(loggerLevel));
        this.criteriaLogManager.addCriteria(criteria);
        this.vertx.setTimer(this.limitDuration(durationMillis.intValue()), ignored -> this.criteriaLogManager.removeCriteria(criteria));
    }

    public void addCriteria(LogCriteriaFilter filter, Long durationSeconds) {
        if (filter != null) {
            Criteria criteria = Criteria.create(filter.getAccountId(), filter.getBidderCode(), filter.getLineItemId(), Logger::error);
            this.criteriaLogManager.addCriteria(criteria);
            logger.info((Object)"Logger was updated with new criteria {0}", new Object[]{criteria});
            this.vertx.setTimer(this.limitDuration(TimeUnit.SECONDS.toMillis(durationSeconds)), ignored -> this.criteriaLogManager.removeCriteria(criteria));
        }
    }

    public void stop() {
        this.criteriaLogManager.removeAllCriteria();
    }

    private long limitDuration(long durationMillis) {
        return Math.min(durationMillis, 300000L);
    }

    private BiConsumer<Logger, Object> resolveLogLevel(String rawLogLevel) {
        LogLevel logLevel;
        try {
            logLevel = LogLevel.valueOf(rawLogLevel.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid LoggingLevel: " + rawLogLevel);
        }
        return switch (logLevel) {
            default -> throw new IncompatibleClassChangeError();
            case LogLevel.info -> Logger::info;
            case LogLevel.warn -> Logger::warn;
            case LogLevel.trace -> Logger::trace;
            case LogLevel.error -> Logger::error;
            case LogLevel.fatal -> Logger::fatal;
            case LogLevel.debug -> Logger::debug;
        };
    }

    private static enum LogLevel {
        info,
        warn,
        trace,
        error,
        fatal,
        debug;

    }
}

