/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

class ZonedDateTimeModule
extends SimpleModule {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendPattern("XXX").toFormatter();

    ZonedDateTimeModule() {
        this.addSerializer(ZonedDateTime.class, new ZonedDateTimeSerializer());
        this.addDeserializer(ZonedDateTime.class, new ZonedDateTimeDeserializer());
    }

    private static class ZonedDateTimeSerializer
    extends JsonSerializer<ZonedDateTime> {
        private ZonedDateTimeSerializer() {
        }

        public void serialize(ZonedDateTime value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeString(FORMATTER.format(value));
        }
    }

    private static class ZonedDateTimeDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        private ZonedDateTimeDeserializer() {
        }

        public ZonedDateTime deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            return ZonedDateTime.parse(parser.getValueAsString(), FORMATTER);
        }
    }
}

